package org.cloudfoundry.client.v3.serviceInstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.LastOperation;
import org.cloudfoundry.client.v3.MaintenanceInfo;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Update Application operation
 */
@Generated(from = "_UpdateServiceInstanceResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceInstanceResponse
    extends org.cloudfoundry.client.v3.serviceInstances._UpdateServiceInstanceResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final @Nullable String dashboardUrl;
  private final @Nullable LastOperation lastOperation;
  private final @Nullable MaintenanceInfo maintenanceInfo;
  private final @Nullable Metadata metadata;
  private final String name;
  private final @Nullable ServiceInstanceRelationships relationships;
  private final @Nullable String routeServiceUrl;
  private final @Nullable String syslogDrainUrl;
  private final @Nullable List<String> tags;
  private final @Nullable ServiceInstanceType type;
  private final @Nullable Boolean updateAvailable;

  private UpdateServiceInstanceResponse(UpdateServiceInstanceResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.dashboardUrl = builder.dashboardUrl;
    this.lastOperation = builder.lastOperation;
    this.maintenanceInfo = builder.maintenanceInfo;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.relationships = builder.relationships;
    this.routeServiceUrl = builder.routeServiceUrl;
    this.syslogDrainUrl = builder.syslogDrainUrl;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.type = builder.type;
    this.updateAvailable = builder.updateAvailable;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The dashboard url
   */
  @JsonProperty("dashboard_url")
  @Override
  public @Nullable String getDashboardUrl() {
    return dashboardUrl;
  }

  /**
   * The last operation
   */
  @JsonProperty("last_operation")
  @Override
  public @Nullable LastOperation getLastOperation() {
    return lastOperation;
  }

  /**
   * The maintenance info
   */
  @JsonProperty("maintenance_info")
  @Override
  public @Nullable MaintenanceInfo getMaintenanceInfo() {
    return maintenanceInfo;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable ServiceInstanceRelationships getRelationships() {
    return relationships;
  }

  /**
   * The route service url
   */
  @JsonProperty("route_service_url")
  @Override
  public @Nullable String getRouteServiceUrl() {
    return routeServiceUrl;
  }

  /**
   * The syslog drain url
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * A list of tags for the service instance
   */
  @JsonProperty("tags")
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * The type of the service instance
   */
  @JsonProperty("type")
  @Override
  public @Nullable ServiceInstanceType getType() {
    return type;
  }

  /**
   * Whether or not an upgrade of this service instance is available on the current Service Plan
   */
  @JsonProperty("upgrade_available")
  @Override
  public @Nullable Boolean getUpdateAvailable() {
    return updateAvailable;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceInstanceResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceInstanceResponse
        && equalTo((UpdateServiceInstanceResponse) another);
  }

  private boolean equalTo(UpdateServiceInstanceResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(dashboardUrl, another.dashboardUrl)
        && Objects.equals(lastOperation, another.lastOperation)
        && Objects.equals(maintenanceInfo, another.maintenanceInfo)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && Objects.equals(relationships, another.relationships)
        && Objects.equals(routeServiceUrl, another.routeServiceUrl)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl)
        && Objects.equals(tags, another.tags)
        && Objects.equals(type, another.type)
        && Objects.equals(updateAvailable, another.updateAvailable);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code dashboardUrl}, {@code lastOperation}, {@code maintenanceInfo}, {@code metadata}, {@code name}, {@code relationships}, {@code routeServiceUrl}, {@code syslogDrainUrl}, {@code tags}, {@code type}, {@code updateAvailable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(dashboardUrl);
    h += (h << 5) + Objects.hashCode(lastOperation);
    h += (h << 5) + Objects.hashCode(maintenanceInfo);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(relationships);
    h += (h << 5) + Objects.hashCode(routeServiceUrl);
    h += (h << 5) + Objects.hashCode(syslogDrainUrl);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(updateAvailable);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceInstanceResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceInstanceResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", dashboardUrl=" + dashboardUrl
        + ", lastOperation=" + lastOperation
        + ", maintenanceInfo=" + maintenanceInfo
        + ", metadata=" + metadata
        + ", name=" + name
        + ", relationships=" + relationships
        + ", routeServiceUrl=" + routeServiceUrl
        + ", syslogDrainUrl=" + syslogDrainUrl
        + ", tags=" + tags
        + ", type=" + type
        + ", updateAvailable=" + updateAvailable
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServiceInstanceResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceInstances._UpdateServiceInstanceResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    String dashboardUrl;
    LastOperation lastOperation;
    MaintenanceInfo maintenanceInfo;
    Metadata metadata;
    String name;
    ServiceInstanceRelationships relationships;
    String routeServiceUrl;
    String syslogDrainUrl;
    List<String> tags = null;
    ServiceInstanceType type;
    Boolean updateAvailable;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("dashboard_url")
    public void setDashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
    }
    @JsonProperty("last_operation")
    public void setLastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
    }
    @JsonProperty("maintenance_info")
    public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable ServiceInstanceRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("route_service_url")
    public void setRouteServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @JsonProperty("tags")
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("type")
    public void setType(@Nullable ServiceInstanceType type) {
      this.type = type;
    }
    @JsonProperty("upgrade_available")
    public void setUpdateAvailable(@Nullable Boolean updateAvailable) {
      this.updateAvailable = updateAvailable;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getDashboardUrl() { throw new UnsupportedOperationException(); }
    @Override
    public LastOperation getLastOperation() { throw new UnsupportedOperationException(); }
    @Override
    public MaintenanceInfo getMaintenanceInfo() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceInstanceRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteServiceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceInstanceType getType() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getUpdateAvailable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServiceInstanceResponse fromJson(Json json) {
    UpdateServiceInstanceResponse.Builder builder = UpdateServiceInstanceResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.dashboardUrl != null) {
      builder.dashboardUrl(json.dashboardUrl);
    }
    if (json.lastOperation != null) {
      builder.lastOperation(json.lastOperation);
    }
    if (json.maintenanceInfo != null) {
      builder.maintenanceInfo(json.maintenanceInfo);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.routeServiceUrl != null) {
      builder.routeServiceUrl(json.routeServiceUrl);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.updateAvailable != null) {
      builder.updateAvailable(json.updateAvailable);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServiceInstanceResponse UpdateServiceInstanceResponse}.
   * <pre>
   * UpdateServiceInstanceResponse.builder()
   *    .createdAt(String) // required {@link UpdateServiceInstanceResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link UpdateServiceInstanceResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link UpdateServiceInstanceResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link UpdateServiceInstanceResponse#getUpdatedAt() updatedAt}
   *    .dashboardUrl(String | null) // nullable {@link UpdateServiceInstanceResponse#getDashboardUrl() dashboardUrl}
   *    .lastOperation(org.cloudfoundry.client.v3.LastOperation | null) // nullable {@link UpdateServiceInstanceResponse#getLastOperation() lastOperation}
   *    .maintenanceInfo(org.cloudfoundry.client.v3.MaintenanceInfo | null) // nullable {@link UpdateServiceInstanceResponse#getMaintenanceInfo() maintenanceInfo}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateServiceInstanceResponse#getMetadata() metadata}
   *    .name(String) // required {@link UpdateServiceInstanceResponse#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.serviceInstances.ServiceInstanceRelationships | null) // nullable {@link UpdateServiceInstanceResponse#getRelationships() relationships}
   *    .routeServiceUrl(String | null) // nullable {@link UpdateServiceInstanceResponse#getRouteServiceUrl() routeServiceUrl}
   *    .syslogDrainUrl(String | null) // nullable {@link UpdateServiceInstanceResponse#getSyslogDrainUrl() syslogDrainUrl}
   *    .tags(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateServiceInstanceResponse#getTags() tags}
   *    .type(org.cloudfoundry.client.v3.serviceInstances.ServiceInstanceType | null) // nullable {@link UpdateServiceInstanceResponse#getType() type}
   *    .updateAvailable(Boolean | null) // nullable {@link UpdateServiceInstanceResponse#getUpdateAvailable() updateAvailable}
   *    .build();
   * </pre>
   * @return A new UpdateServiceInstanceResponse builder
   */
  public static UpdateServiceInstanceResponse.Builder builder() {
    return new UpdateServiceInstanceResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceInstanceResponse UpdateServiceInstanceResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceInstanceResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private long initBits = 0x7L;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private String dashboardUrl;
    private LastOperation lastOperation;
    private MaintenanceInfo maintenanceInfo;
    private Metadata metadata;
    private String name;
    private ServiceInstanceRelationships relationships;
    private String routeServiceUrl;
    private String syslogDrainUrl;
    private List<String> tags = null;
    private ServiceInstanceType type;
    private Boolean updateAvailable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.serviceInstances.ServiceInstance} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceInstance instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceInstanceResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceInstanceResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateServiceInstanceResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateServiceInstanceResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
      if (object instanceof ServiceInstance) {
        ServiceInstance instance = (ServiceInstance) object;
        ServiceInstanceRelationships relationshipsValue = instance.getRelationships();
        if (relationshipsValue != null) {
          relationships(relationshipsValue);
        }
        String dashboardUrlValue = instance.getDashboardUrl();
        if (dashboardUrlValue != null) {
          dashboardUrl(dashboardUrlValue);
        }
        Metadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
          metadata(metadataValue);
        }
        LastOperation lastOperationValue = instance.getLastOperation();
        if (lastOperationValue != null) {
          lastOperation(lastOperationValue);
        }
        name(instance.getName());
        ServiceInstanceType typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        String routeServiceUrlValue = instance.getRouteServiceUrl();
        if (routeServiceUrlValue != null) {
          routeServiceUrl(routeServiceUrlValue);
        }
        Boolean updateAvailableValue = instance.getUpdateAvailable();
        if (updateAvailableValue != null) {
          updateAvailable(updateAvailableValue);
        }
        MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
        if (maintenanceInfoValue != null) {
          maintenanceInfo(maintenanceInfoValue);
        }
        String syslogDrainUrlValue = instance.getSyslogDrainUrl();
        if (syslogDrainUrlValue != null) {
          syslogDrainUrl(syslogDrainUrlValue);
        }
        List<String> tagsValue = instance.getTags();
        if (tagsValue != null) {
          addAllTags(tagsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link UpdateServiceInstanceResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateServiceInstanceResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateServiceInstanceResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateServiceInstanceResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getDashboardUrl() dashboardUrl} attribute.
     * @param dashboardUrl The value for dashboardUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dashboard_url")
    public final Builder dashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getLastOperation() lastOperation} attribute.
     * @param lastOperation The value for lastOperation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_operation")
    public final Builder lastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getMaintenanceInfo() maintenanceInfo} attribute.
     * @param maintenanceInfo The value for maintenanceInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maintenance_info")
    public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(@Nullable ServiceInstanceRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getRouteServiceUrl() routeServiceUrl} attribute.
     * @param routeServiceUrl The value for routeServiceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("route_service_url")
    public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("syslog_drain_url")
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Adds one element to {@link UpdateServiceInstanceResponse#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateServiceInstanceResponse#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateServiceInstanceResponse#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link UpdateServiceInstanceResponse#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable ServiceInstanceType type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceResponse#getUpdateAvailable() updateAvailable} attribute.
     * @param updateAvailable The value for updateAvailable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("upgrade_available")
    public final Builder updateAvailable(@Nullable Boolean updateAvailable) {
      this.updateAvailable = updateAvailable;
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceInstanceResponse UpdateServiceInstanceResponse}.
     * @return An immutable instance of UpdateServiceInstanceResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceInstanceResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceInstanceResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build UpdateServiceInstanceResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
