package org.cloudfoundry.client.v3.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Isolation Segment operation
 */
@Generated(from = "_GetSpaceIsolationSegmentRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetSpaceIsolationSegmentRequest
    extends org.cloudfoundry.client.v3.spaces._GetSpaceIsolationSegmentRequest {
  private final String spaceId;

  private GetSpaceIsolationSegmentRequest(GetSpaceIsolationSegmentRequest.Builder builder) {
    this.spaceId = builder.spaceId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code GetSpaceIsolationSegmentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSpaceIsolationSegmentRequest
        && equalTo((GetSpaceIsolationSegmentRequest) another);
  }

  private boolean equalTo(GetSpaceIsolationSegmentRequest another) {
    return spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetSpaceIsolationSegmentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSpaceIsolationSegmentRequest{"
        + "spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link GetSpaceIsolationSegmentRequest GetSpaceIsolationSegmentRequest}.
   * <pre>
   * GetSpaceIsolationSegmentRequest.builder()
   *    .spaceId(String) // required {@link GetSpaceIsolationSegmentRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new GetSpaceIsolationSegmentRequest builder
   */
  public static GetSpaceIsolationSegmentRequest.Builder builder() {
    return new GetSpaceIsolationSegmentRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetSpaceIsolationSegmentRequest GetSpaceIsolationSegmentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetSpaceIsolationSegmentRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSpaceIsolationSegmentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSpaceIsolationSegmentRequest instance) {
      return from((_GetSpaceIsolationSegmentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetSpaceIsolationSegmentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSpaceIsolationSegmentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetSpaceIsolationSegmentRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link GetSpaceIsolationSegmentRequest GetSpaceIsolationSegmentRequest}.
     * @return An immutable instance of GetSpaceIsolationSegmentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSpaceIsolationSegmentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetSpaceIsolationSegmentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build GetSpaceIsolationSegmentRequest, some of required attributes are not set " + attributes;
    }
  }
}
