package org.cloudfoundry.client.v3.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Space operation
 */
@Generated(from = "_UpdateSpaceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateSpaceRequest extends org.cloudfoundry.client.v3.spaces._UpdateSpaceRequest {
  private final @Nullable Metadata metadata;
  private final String spaceId;

  private UpdateSpaceRequest(UpdateSpaceRequest.Builder builder) {
    this.metadata = builder.metadata;
    this.spaceId = builder.spaceId;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The space id
   */
  @JsonProperty("spaceId")
  @JsonIgnore
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSpaceRequest
        && equalTo((UpdateSpaceRequest) another);
  }

  private boolean equalTo(UpdateSpaceRequest another) {
    return Objects.equals(metadata, another.metadata)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSpaceRequest{"
        + "metadata=" + metadata
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateSpaceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.spaces._UpdateSpaceRequest {
    Metadata metadata;
    String spaceId;
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("spaceId")
    @JsonIgnore
    public void setSpaceId(String spaceId) {
      this.spaceId = spaceId;
    }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateSpaceRequest fromJson(Json json) {
    UpdateSpaceRequest.Builder builder = UpdateSpaceRequest.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateSpaceRequest UpdateSpaceRequest}.
   * <pre>
   * UpdateSpaceRequest.builder()
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateSpaceRequest#getMetadata() metadata}
   *    .spaceId(String) // required {@link UpdateSpaceRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new UpdateSpaceRequest builder
   */
  public static UpdateSpaceRequest.Builder builder() {
    return new UpdateSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSpaceRequest UpdateSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateSpaceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private Metadata metadata;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSpaceRequest instance) {
      return from((_UpdateSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateSpaceRequest UpdateSpaceRequest}.
     * @return An immutable instance of UpdateSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build UpdateSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
