/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes._ScaleProcessRequest;
import org.immutables.value.Generated;

@Generated(from="_ScaleProcessRequest", generator="Immutables")
public final class ScaleProcessRequest
extends _ScaleProcessRequest {
    @Nullable
    private final Integer diskInMb;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memoryInMb;
    private final String processId;

    private ScaleProcessRequest(Builder builder) {
        this.diskInMb = builder.diskInMb;
        this.instances = builder.instances;
        this.memoryInMb = builder.memoryInMb;
        this.processId = builder.processId;
    }

    @Override
    @JsonProperty(value="disk_in_mb")
    @Nullable
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    @Override
    @JsonProperty(value="instances")
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @JsonProperty(value="memory_in_mb")
    @Nullable
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    @JsonProperty(value="processId")
    @JsonIgnore
    public String getProcessId() {
        return this.processId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScaleProcessRequest && this.equalTo((ScaleProcessRequest)another);
    }

    private boolean equalTo(ScaleProcessRequest another) {
        return Objects.equals(this.diskInMb, another.diskInMb) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memoryInMb, another.memoryInMb) && this.processId.equals(another.processId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.diskInMb);
        h += (h << 5) + Objects.hashCode(this.instances);
        h += (h << 5) + Objects.hashCode(this.memoryInMb);
        h += (h << 5) + this.processId.hashCode();
        return h;
    }

    public String toString() {
        return "ScaleProcessRequest{diskInMb=" + this.diskInMb + ", instances=" + this.instances + ", memoryInMb=" + this.memoryInMb + ", processId=" + this.processId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ScaleProcessRequest fromJson(Json json) {
        Builder builder = ScaleProcessRequest.builder();
        if (json.diskInMb != null) {
            builder.diskInMb(json.diskInMb);
        }
        if (json.instances != null) {
            builder.instances(json.instances);
        }
        if (json.memoryInMb != null) {
            builder.memoryInMb(json.memoryInMb);
        }
        if (json.processId != null) {
            builder.processId(json.processId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_ScaleProcessRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PROCESS_ID = 1L;
        private long initBits = 1L;
        private Integer diskInMb;
        private Integer instances;
        private Integer memoryInMb;
        private String processId;

        private Builder() {
        }

        public final Builder from(ScaleProcessRequest instance) {
            return this.from((_ScaleProcessRequest)instance);
        }

        final Builder from(_ScaleProcessRequest instance) {
            Integer memoryInMbValue;
            Integer instancesValue;
            Objects.requireNonNull(instance, "instance");
            Integer diskInMbValue = instance.getDiskInMb();
            if (diskInMbValue != null) {
                this.diskInMb(diskInMbValue);
            }
            if ((instancesValue = instance.getInstances()) != null) {
                this.instances(instancesValue);
            }
            if ((memoryInMbValue = instance.getMemoryInMb()) != null) {
                this.memoryInMb(memoryInMbValue);
            }
            this.processId(instance.getProcessId());
            return this;
        }

        public final Builder diskInMb(@Nullable Integer diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder memoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public final Builder processId(String processId) {
            this.processId = Objects.requireNonNull(processId, "processId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ScaleProcessRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ScaleProcessRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("processId");
            }
            return "Cannot build ScaleProcessRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ScaleProcessRequest", generator="Immutables")
    static final class Json
    extends _ScaleProcessRequest {
        Integer diskInMb;
        Integer instances;
        Integer memoryInMb;
        String processId;

        Json() {
        }

        @JsonProperty(value="disk_in_mb")
        public void setDiskInMb(@Nullable Integer diskInMb) {
            this.diskInMb = diskInMb;
        }

        @JsonProperty(value="instances")
        public void setInstances(@Nullable Integer instances) {
            this.instances = instances;
        }

        @JsonProperty(value="memory_in_mb")
        public void setMemoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
        }

        @JsonProperty(value="processId")
        @JsonIgnore
        public void setProcessId(String processId) {
            this.processId = processId;
        }

        @Override
        public Integer getDiskInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProcessId() {
            throw new UnsupportedOperationException();
        }
    }
}

