/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.routes._ListRouteDestinationsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListRouteDestinationsRequest", generator="Immutables")
public final class ListRouteDestinationsRequest
extends _ListRouteDestinationsRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> applicationIds;
    private final List<String> destinationIds;
    private final String routeId;

    private ListRouteDestinationsRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.applicationIds = ListRouteDestinationsRequest.createUnmodifiableList(true, builder.applicationIds);
        this.destinationIds = ListRouteDestinationsRequest.createUnmodifiableList(true, builder.destinationIds);
        this.routeId = builder.routeId;
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public List<String> getDestinationIds() {
        return this.destinationIds;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListRouteDestinationsRequest && this.equalTo((ListRouteDestinationsRequest)another);
    }

    private boolean equalTo(ListRouteDestinationsRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.applicationIds.equals(another.applicationIds) && this.destinationIds.equals(another.destinationIds) && this.routeId.equals(another.routeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.applicationIds.hashCode();
        h += (h << 5) + this.destinationIds.hashCode();
        h += (h << 5) + this.routeId.hashCode();
        return h;
    }

    public String toString() {
        return "ListRouteDestinationsRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", applicationIds=" + this.applicationIds + ", destinationIds=" + this.destinationIds + ", routeId=" + this.routeId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListRouteDestinationsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ROUTE_ID = 1L;
        private long initBits = 1L;
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> applicationIds = new ArrayList<String>();
        private List<String> destinationIds = new ArrayList<String>();
        private String routeId;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListRouteDestinationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListRouteDestinationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListRouteDestinationsRequest) {
                instance = (_ListRouteDestinationsRequest)object;
                this.addAllDestinationIds(((_ListRouteDestinationsRequest)instance).getDestinationIds());
                this.routeId(((_ListRouteDestinationsRequest)instance).getRouteId());
                this.addAllApplicationIds(((_ListRouteDestinationsRequest)instance).getApplicationIds());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder applicationId(String element) {
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(Iterable<String> elements) {
            this.applicationIds.clear();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder destinationId(String element) {
            this.destinationIds.add(Objects.requireNonNull(element, "destinationIds element"));
            return this;
        }

        public final Builder destinationIds(String ... elements) {
            for (String element : elements) {
                this.destinationIds.add(Objects.requireNonNull(element, "destinationIds element"));
            }
            return this;
        }

        public final Builder destinationIds(Iterable<String> elements) {
            this.destinationIds.clear();
            return this.addAllDestinationIds(elements);
        }

        public final Builder addAllDestinationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.destinationIds.add(Objects.requireNonNull(element, "destinationIds element"));
            }
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ListRouteDestinationsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListRouteDestinationsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("routeId");
            }
            return "Cannot build ListRouteDestinationsRequest, some of required attributes are not set " + attributes;
        }
    }
}

