package org.cloudfoundry.client.v2.buildpacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.*;
import org.immutables.value.Generated;

/**
 * The response payload for the List Buildpacks operation
 */
@Generated(from = "_ListBuildpacksResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListBuildpacksResponse
    extends org.cloudfoundry.client.v2.buildpacks._ListBuildpacksResponse {
  private final @Nullable String nextUrl;
  private final @Nullable String previousUrl;
  private final @Nullable List<BuildpackResource> resources;
  private final @Nullable Integer totalPages;
  private final @Nullable Integer totalResults;

  private ListBuildpacksResponse(ListBuildpacksResponse.Builder builder) {
    this.nextUrl = builder.nextUrl;
    this.previousUrl = builder.previousUrl;
    this.resources = builder.resources == null ? null : createUnmodifiableList(true, builder.resources);
    this.totalPages = builder.totalPages;
    this.totalResults = builder.totalResults;
  }

  /**
   * The next url
   */
  @JsonProperty("next_url")
  @Override
  public @Nullable String getNextUrl() {
    return nextUrl;
  }

  /**
   * The previous url
   */
  @JsonProperty("prev_url")
  @Override
  public @Nullable String getPreviousUrl() {
    return previousUrl;
  }

  /**
   * The resources
   */
  @JsonProperty("resources")
  @Override
  public @Nullable List<BuildpackResource> getResources() {
    return resources;
  }

  /**
   * The total pages
   */
  @JsonProperty("total_pages")
  @Override
  public @Nullable Integer getTotalPages() {
    return totalPages;
  }

  /**
   * The total results
   */
  @JsonProperty("total_results")
  @Override
  public @Nullable Integer getTotalResults() {
    return totalResults;
  }

  /**
   * This instance is equal to all instances of {@code ListBuildpacksResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListBuildpacksResponse
        && equalTo((ListBuildpacksResponse) another);
  }

  private boolean equalTo(ListBuildpacksResponse another) {
    return Objects.equals(nextUrl, another.nextUrl)
        && Objects.equals(previousUrl, another.previousUrl)
        && Objects.equals(resources, another.resources)
        && Objects.equals(totalPages, another.totalPages)
        && Objects.equals(totalResults, another.totalResults);
  }

  /**
   * Computes a hash code from attributes: {@code nextUrl}, {@code previousUrl}, {@code resources}, {@code totalPages}, {@code totalResults}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(nextUrl);
    h += (h << 5) + Objects.hashCode(previousUrl);
    h += (h << 5) + Objects.hashCode(resources);
    h += (h << 5) + Objects.hashCode(totalPages);
    h += (h << 5) + Objects.hashCode(totalResults);
    return h;
  }

  /**
   * Prints the immutable value {@code ListBuildpacksResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListBuildpacksResponse{"
        + "nextUrl=" + nextUrl
        + ", previousUrl=" + previousUrl
        + ", resources=" + resources
        + ", totalPages=" + totalPages
        + ", totalResults=" + totalResults
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListBuildpacksResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.buildpacks._ListBuildpacksResponse {
    String nextUrl;
    String previousUrl;
    List<BuildpackResource> resources = null;
    Integer totalPages;
    Integer totalResults;
    @JsonProperty("next_url")
    public void setNextUrl(@Nullable String nextUrl) {
      this.nextUrl = nextUrl;
    }
    @JsonProperty("prev_url")
    public void setPreviousUrl(@Nullable String previousUrl) {
      this.previousUrl = previousUrl;
    }
    @JsonProperty("resources")
    public void setResources(@Nullable List<BuildpackResource> resources) {
      this.resources = resources;
    }
    @JsonProperty("total_pages")
    public void setTotalPages(@Nullable Integer totalPages) {
      this.totalPages = totalPages;
    }
    @JsonProperty("total_results")
    public void setTotalResults(@Nullable Integer totalResults) {
      this.totalResults = totalResults;
    }
    @Override
    public String getNextUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getPreviousUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<BuildpackResource> getResources() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalPages() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalResults() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListBuildpacksResponse fromJson(Json json) {
    ListBuildpacksResponse.Builder builder = ListBuildpacksResponse.builder();
    if (json.nextUrl != null) {
      builder.nextUrl(json.nextUrl);
    }
    if (json.previousUrl != null) {
      builder.previousUrl(json.previousUrl);
    }
    if (json.resources != null) {
      builder.addAllResources(json.resources);
    }
    if (json.totalPages != null) {
      builder.totalPages(json.totalPages);
    }
    if (json.totalResults != null) {
      builder.totalResults(json.totalResults);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListBuildpacksResponse ListBuildpacksResponse}.
   * <pre>
   * ListBuildpacksResponse.builder()
   *    .nextUrl(String | null) // nullable {@link ListBuildpacksResponse#getNextUrl() nextUrl}
   *    .previousUrl(String | null) // nullable {@link ListBuildpacksResponse#getPreviousUrl() previousUrl}
   *    .resources(List&amp;lt;BuildpackResource&amp;gt; | null) // nullable {@link ListBuildpacksResponse#getResources() resources}
   *    .totalPages(Integer | null) // nullable {@link ListBuildpacksResponse#getTotalPages() totalPages}
   *    .totalResults(Integer | null) // nullable {@link ListBuildpacksResponse#getTotalResults() totalResults}
   *    .build();
   * </pre>
   * @return A new ListBuildpacksResponse builder
   */
  public static ListBuildpacksResponse.Builder builder() {
    return new ListBuildpacksResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListBuildpacksResponse ListBuildpacksResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListBuildpacksResponse", generator = "Immutables")
  public static final class Builder {
    private String nextUrl;
    private String previousUrl;
    private List<BuildpackResource> resources = null;
    private Integer totalPages;
    private Integer totalResults;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListBuildpacksResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListBuildpacksResponse instance) {
      return from((_ListBuildpacksResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListBuildpacksResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListBuildpacksResponse instance) {
      Objects.requireNonNull(instance, "instance");
      String nextUrlValue = instance.getNextUrl();
      if (nextUrlValue != null) {
        nextUrl(nextUrlValue);
      }
      String previousUrlValue = instance.getPreviousUrl();
      if (previousUrlValue != null) {
        previousUrl(previousUrlValue);
      }
      List<BuildpackResource> resourcesValue = instance.getResources();
      if (resourcesValue != null) {
        addAllResources(resourcesValue);
      }
      Integer totalPagesValue = instance.getTotalPages();
      if (totalPagesValue != null) {
        totalPages(totalPagesValue);
      }
      Integer totalResultsValue = instance.getTotalResults();
      if (totalResultsValue != null) {
        totalResults(totalResultsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListBuildpacksResponse#getNextUrl() nextUrl} attribute.
     * @param nextUrl The value for nextUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("next_url")
    public final Builder nextUrl(@Nullable String nextUrl) {
      this.nextUrl = nextUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ListBuildpacksResponse#getPreviousUrl() previousUrl} attribute.
     * @param previousUrl The value for previousUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("prev_url")
    public final Builder previousUrl(@Nullable String previousUrl) {
      this.previousUrl = previousUrl;
      return this;
    }

    /**
     * Adds one element to {@link ListBuildpacksResponse#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(BuildpackResource element) {
      if (this.resources == null) {
        this.resources = new ArrayList<BuildpackResource>();
      }
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link ListBuildpacksResponse#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(BuildpackResource... elements) {
      if (this.resources == null) {
        this.resources = new ArrayList<BuildpackResource>();
      }
      for (BuildpackResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListBuildpacksResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resources")
    public final Builder resources(@Nullable Iterable<? extends BuildpackResource> elements) {
      if (elements == null) {
        this.resources = null;
        return this;
      }
      this.resources = new ArrayList<BuildpackResource>();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link ListBuildpacksResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends BuildpackResource> elements) {
      Objects.requireNonNull(elements, "resources element");
      if (this.resources == null) {
        this.resources = new ArrayList<BuildpackResource>();
      }
      for (BuildpackResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListBuildpacksResponse#getTotalPages() totalPages} attribute.
     * @param totalPages The value for totalPages (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_pages")
    public final Builder totalPages(@Nullable Integer totalPages) {
      this.totalPages = totalPages;
      return this;
    }

    /**
     * Initializes the value for the {@link ListBuildpacksResponse#getTotalResults() totalResults} attribute.
     * @param totalResults The value for totalResults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_results")
    public final Builder totalResults(@Nullable Integer totalResults) {
      this.totalResults = totalResults;
      return this;
    }

    /**
     * Builds a new {@link ListBuildpacksResponse ListBuildpacksResponse}.
     * @return An immutable instance of ListBuildpacksResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListBuildpacksResponse build() {
      return new ListBuildpacksResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
