package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for the Organization resource
 */
@Generated(from = "_OrganizationEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OrganizationEntity extends org.cloudfoundry.client.v2.organizations._OrganizationEntity {
  private final @Nullable String applicationEventsUrl;
  private final @Nullable String auditorsUrl;
  private final @Nullable Boolean billingEnabled;
  private final @Nullable String billingManagersUrl;
  private final @Nullable String defaultIsolationSegmentId;
  private final @Nullable String domainsUrl;
  private final @Nullable String isolationSegmentUrl;
  private final @Nullable String managersUrl;
  private final @Nullable String name;
  private final @Nullable String privateDomainsUrl;
  private final @Nullable String quotaDefinitionId;
  private final @Nullable String quotaDefinitionUrl;
  private final @Nullable String spaceQuotaDefinitionsUrl;
  private final @Nullable String spacesUrl;
  private final @Nullable String status;
  private final @Nullable String usersUrl;

  private OrganizationEntity(OrganizationEntity.Builder builder) {
    this.applicationEventsUrl = builder.applicationEventsUrl;
    this.auditorsUrl = builder.auditorsUrl;
    this.billingEnabled = builder.billingEnabled;
    this.billingManagersUrl = builder.billingManagersUrl;
    this.defaultIsolationSegmentId = builder.defaultIsolationSegmentId;
    this.domainsUrl = builder.domainsUrl;
    this.isolationSegmentUrl = builder.isolationSegmentUrl;
    this.managersUrl = builder.managersUrl;
    this.name = builder.name;
    this.privateDomainsUrl = builder.privateDomainsUrl;
    this.quotaDefinitionId = builder.quotaDefinitionId;
    this.quotaDefinitionUrl = builder.quotaDefinitionUrl;
    this.spaceQuotaDefinitionsUrl = builder.spaceQuotaDefinitionsUrl;
    this.spacesUrl = builder.spacesUrl;
    this.status = builder.status;
    this.usersUrl = builder.usersUrl;
  }

  /**
   * The application events url
   */
  @JsonProperty("app_events_url")
  @Override
  public @Nullable String getApplicationEventsUrl() {
    return applicationEventsUrl;
  }

  /**
   * The auditors url
   */
  @JsonProperty("auditors_url")
  @Override
  public @Nullable String getAuditorsUrl() {
    return auditorsUrl;
  }

  /**
   * Billing enabled
   */
  @JsonProperty("billing_enabled")
  @Override
  public @Nullable Boolean getBillingEnabled() {
    return billingEnabled;
  }

  /**
   * The billing managers url
   */
  @JsonProperty("billing_managers_url")
  @Override
  public @Nullable String getBillingManagersUrl() {
    return billingManagersUrl;
  }

  /**
   * The default isolation segment id
   */
  @JsonProperty("default_isolation_segment_guid")
  @Override
  public @Nullable String getDefaultIsolationSegmentId() {
    return defaultIsolationSegmentId;
  }

  /**
   * The domains url
   */
  @JsonProperty("domains_url")
  @Override
  public @Nullable String getDomainsUrl() {
    return domainsUrl;
  }

  /**
   * The isolation segment url
   */
  @JsonProperty("isolation_segment_url")
  @Override
  public @Nullable String getIsolationSegmentUrl() {
    return isolationSegmentUrl;
  }

  /**
   * The managers url
   */
  @JsonProperty("managers_url")
  @Override
  public @Nullable String getManagersUrl() {
    return managersUrl;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The private domains url
   */
  @JsonProperty("private_domains_url")
  @Override
  public @Nullable String getPrivateDomainsUrl() {
    return privateDomainsUrl;
  }

  /**
   * The quota definition id
   */
  @JsonProperty("quota_definition_guid")
  @Override
  public @Nullable String getQuotaDefinitionId() {
    return quotaDefinitionId;
  }

  /**
   * The quota definition url
   */
  @JsonProperty("quota_definition_url")
  @Override
  public @Nullable String getQuotaDefinitionUrl() {
    return quotaDefinitionUrl;
  }

  /**
   * The space quota definition url
   */
  @JsonProperty("space_quota_definitions_url")
  @Override
  public @Nullable String getSpaceQuotaDefinitionsUrl() {
    return spaceQuotaDefinitionsUrl;
  }

  /**
   * The spaces url
   */
  @JsonProperty("spaces_url")
  @Override
  public @Nullable String getSpacesUrl() {
    return spacesUrl;
  }

  /**
   * The status
   */
  @JsonProperty("status")
  @Override
  public @Nullable String getStatus() {
    return status;
  }

  /**
   * The users url
   */
  @JsonProperty("users_url")
  @Override
  public @Nullable String getUsersUrl() {
    return usersUrl;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationEntity
        && equalTo((OrganizationEntity) another);
  }

  private boolean equalTo(OrganizationEntity another) {
    return Objects.equals(applicationEventsUrl, another.applicationEventsUrl)
        && Objects.equals(auditorsUrl, another.auditorsUrl)
        && Objects.equals(billingEnabled, another.billingEnabled)
        && Objects.equals(billingManagersUrl, another.billingManagersUrl)
        && Objects.equals(defaultIsolationSegmentId, another.defaultIsolationSegmentId)
        && Objects.equals(domainsUrl, another.domainsUrl)
        && Objects.equals(isolationSegmentUrl, another.isolationSegmentUrl)
        && Objects.equals(managersUrl, another.managersUrl)
        && Objects.equals(name, another.name)
        && Objects.equals(privateDomainsUrl, another.privateDomainsUrl)
        && Objects.equals(quotaDefinitionId, another.quotaDefinitionId)
        && Objects.equals(quotaDefinitionUrl, another.quotaDefinitionUrl)
        && Objects.equals(spaceQuotaDefinitionsUrl, another.spaceQuotaDefinitionsUrl)
        && Objects.equals(spacesUrl, another.spacesUrl)
        && Objects.equals(status, another.status)
        && Objects.equals(usersUrl, another.usersUrl);
  }

  /**
   * Computes a hash code from attributes: {@code applicationEventsUrl}, {@code auditorsUrl}, {@code billingEnabled}, {@code billingManagersUrl}, {@code defaultIsolationSegmentId}, {@code domainsUrl}, {@code isolationSegmentUrl}, {@code managersUrl}, {@code name}, {@code privateDomainsUrl}, {@code quotaDefinitionId}, {@code quotaDefinitionUrl}, {@code spaceQuotaDefinitionsUrl}, {@code spacesUrl}, {@code status}, {@code usersUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationEventsUrl);
    h += (h << 5) + Objects.hashCode(auditorsUrl);
    h += (h << 5) + Objects.hashCode(billingEnabled);
    h += (h << 5) + Objects.hashCode(billingManagersUrl);
    h += (h << 5) + Objects.hashCode(defaultIsolationSegmentId);
    h += (h << 5) + Objects.hashCode(domainsUrl);
    h += (h << 5) + Objects.hashCode(isolationSegmentUrl);
    h += (h << 5) + Objects.hashCode(managersUrl);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(privateDomainsUrl);
    h += (h << 5) + Objects.hashCode(quotaDefinitionId);
    h += (h << 5) + Objects.hashCode(quotaDefinitionUrl);
    h += (h << 5) + Objects.hashCode(spaceQuotaDefinitionsUrl);
    h += (h << 5) + Objects.hashCode(spacesUrl);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(usersUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationEntity{"
        + "applicationEventsUrl=" + applicationEventsUrl
        + ", auditorsUrl=" + auditorsUrl
        + ", billingEnabled=" + billingEnabled
        + ", billingManagersUrl=" + billingManagersUrl
        + ", defaultIsolationSegmentId=" + defaultIsolationSegmentId
        + ", domainsUrl=" + domainsUrl
        + ", isolationSegmentUrl=" + isolationSegmentUrl
        + ", managersUrl=" + managersUrl
        + ", name=" + name
        + ", privateDomainsUrl=" + privateDomainsUrl
        + ", quotaDefinitionId=" + quotaDefinitionId
        + ", quotaDefinitionUrl=" + quotaDefinitionUrl
        + ", spaceQuotaDefinitionsUrl=" + spaceQuotaDefinitionsUrl
        + ", spacesUrl=" + spacesUrl
        + ", status=" + status
        + ", usersUrl=" + usersUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_OrganizationEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.organizations._OrganizationEntity {
    String applicationEventsUrl;
    String auditorsUrl;
    Boolean billingEnabled;
    String billingManagersUrl;
    String defaultIsolationSegmentId;
    String domainsUrl;
    String isolationSegmentUrl;
    String managersUrl;
    String name;
    String privateDomainsUrl;
    String quotaDefinitionId;
    String quotaDefinitionUrl;
    String spaceQuotaDefinitionsUrl;
    String spacesUrl;
    String status;
    String usersUrl;
    @JsonProperty("app_events_url")
    public void setApplicationEventsUrl(@Nullable String applicationEventsUrl) {
      this.applicationEventsUrl = applicationEventsUrl;
    }
    @JsonProperty("auditors_url")
    public void setAuditorsUrl(@Nullable String auditorsUrl) {
      this.auditorsUrl = auditorsUrl;
    }
    @JsonProperty("billing_enabled")
    public void setBillingEnabled(@Nullable Boolean billingEnabled) {
      this.billingEnabled = billingEnabled;
    }
    @JsonProperty("billing_managers_url")
    public void setBillingManagersUrl(@Nullable String billingManagersUrl) {
      this.billingManagersUrl = billingManagersUrl;
    }
    @JsonProperty("default_isolation_segment_guid")
    public void setDefaultIsolationSegmentId(@Nullable String defaultIsolationSegmentId) {
      this.defaultIsolationSegmentId = defaultIsolationSegmentId;
    }
    @JsonProperty("domains_url")
    public void setDomainsUrl(@Nullable String domainsUrl) {
      this.domainsUrl = domainsUrl;
    }
    @JsonProperty("isolation_segment_url")
    public void setIsolationSegmentUrl(@Nullable String isolationSegmentUrl) {
      this.isolationSegmentUrl = isolationSegmentUrl;
    }
    @JsonProperty("managers_url")
    public void setManagersUrl(@Nullable String managersUrl) {
      this.managersUrl = managersUrl;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("private_domains_url")
    public void setPrivateDomainsUrl(@Nullable String privateDomainsUrl) {
      this.privateDomainsUrl = privateDomainsUrl;
    }
    @JsonProperty("quota_definition_guid")
    public void setQuotaDefinitionId(@Nullable String quotaDefinitionId) {
      this.quotaDefinitionId = quotaDefinitionId;
    }
    @JsonProperty("quota_definition_url")
    public void setQuotaDefinitionUrl(@Nullable String quotaDefinitionUrl) {
      this.quotaDefinitionUrl = quotaDefinitionUrl;
    }
    @JsonProperty("space_quota_definitions_url")
    public void setSpaceQuotaDefinitionsUrl(@Nullable String spaceQuotaDefinitionsUrl) {
      this.spaceQuotaDefinitionsUrl = spaceQuotaDefinitionsUrl;
    }
    @JsonProperty("spaces_url")
    public void setSpacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
    }
    @JsonProperty("status")
    public void setStatus(@Nullable String status) {
      this.status = status;
    }
    @JsonProperty("users_url")
    public void setUsersUrl(@Nullable String usersUrl) {
      this.usersUrl = usersUrl;
    }
    @Override
    public String getApplicationEventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuditorsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getBillingEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public String getBillingManagersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getDefaultIsolationSegmentId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDomainsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getIsolationSegmentUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getManagersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrivateDomainsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getQuotaDefinitionId() { throw new UnsupportedOperationException(); }
    @Override
    public String getQuotaDefinitionUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceQuotaDefinitionsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpacesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsersUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static OrganizationEntity fromJson(Json json) {
    OrganizationEntity.Builder builder = OrganizationEntity.builder();
    if (json.applicationEventsUrl != null) {
      builder.applicationEventsUrl(json.applicationEventsUrl);
    }
    if (json.auditorsUrl != null) {
      builder.auditorsUrl(json.auditorsUrl);
    }
    if (json.billingEnabled != null) {
      builder.billingEnabled(json.billingEnabled);
    }
    if (json.billingManagersUrl != null) {
      builder.billingManagersUrl(json.billingManagersUrl);
    }
    if (json.defaultIsolationSegmentId != null) {
      builder.defaultIsolationSegmentId(json.defaultIsolationSegmentId);
    }
    if (json.domainsUrl != null) {
      builder.domainsUrl(json.domainsUrl);
    }
    if (json.isolationSegmentUrl != null) {
      builder.isolationSegmentUrl(json.isolationSegmentUrl);
    }
    if (json.managersUrl != null) {
      builder.managersUrl(json.managersUrl);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.privateDomainsUrl != null) {
      builder.privateDomainsUrl(json.privateDomainsUrl);
    }
    if (json.quotaDefinitionId != null) {
      builder.quotaDefinitionId(json.quotaDefinitionId);
    }
    if (json.quotaDefinitionUrl != null) {
      builder.quotaDefinitionUrl(json.quotaDefinitionUrl);
    }
    if (json.spaceQuotaDefinitionsUrl != null) {
      builder.spaceQuotaDefinitionsUrl(json.spaceQuotaDefinitionsUrl);
    }
    if (json.spacesUrl != null) {
      builder.spacesUrl(json.spacesUrl);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.usersUrl != null) {
      builder.usersUrl(json.usersUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link OrganizationEntity OrganizationEntity}.
   * <pre>
   * OrganizationEntity.builder()
   *    .applicationEventsUrl(String | null) // nullable {@link OrganizationEntity#getApplicationEventsUrl() applicationEventsUrl}
   *    .auditorsUrl(String | null) // nullable {@link OrganizationEntity#getAuditorsUrl() auditorsUrl}
   *    .billingEnabled(Boolean | null) // nullable {@link OrganizationEntity#getBillingEnabled() billingEnabled}
   *    .billingManagersUrl(String | null) // nullable {@link OrganizationEntity#getBillingManagersUrl() billingManagersUrl}
   *    .defaultIsolationSegmentId(String | null) // nullable {@link OrganizationEntity#getDefaultIsolationSegmentId() defaultIsolationSegmentId}
   *    .domainsUrl(String | null) // nullable {@link OrganizationEntity#getDomainsUrl() domainsUrl}
   *    .isolationSegmentUrl(String | null) // nullable {@link OrganizationEntity#getIsolationSegmentUrl() isolationSegmentUrl}
   *    .managersUrl(String | null) // nullable {@link OrganizationEntity#getManagersUrl() managersUrl}
   *    .name(String | null) // nullable {@link OrganizationEntity#getName() name}
   *    .privateDomainsUrl(String | null) // nullable {@link OrganizationEntity#getPrivateDomainsUrl() privateDomainsUrl}
   *    .quotaDefinitionId(String | null) // nullable {@link OrganizationEntity#getQuotaDefinitionId() quotaDefinitionId}
   *    .quotaDefinitionUrl(String | null) // nullable {@link OrganizationEntity#getQuotaDefinitionUrl() quotaDefinitionUrl}
   *    .spaceQuotaDefinitionsUrl(String | null) // nullable {@link OrganizationEntity#getSpaceQuotaDefinitionsUrl() spaceQuotaDefinitionsUrl}
   *    .spacesUrl(String | null) // nullable {@link OrganizationEntity#getSpacesUrl() spacesUrl}
   *    .status(String | null) // nullable {@link OrganizationEntity#getStatus() status}
   *    .usersUrl(String | null) // nullable {@link OrganizationEntity#getUsersUrl() usersUrl}
   *    .build();
   * </pre>
   * @return A new OrganizationEntity builder
   */
  public static OrganizationEntity.Builder builder() {
    return new OrganizationEntity.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationEntity OrganizationEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OrganizationEntity", generator = "Immutables")
  public static final class Builder {
    private String applicationEventsUrl;
    private String auditorsUrl;
    private Boolean billingEnabled;
    private String billingManagersUrl;
    private String defaultIsolationSegmentId;
    private String domainsUrl;
    private String isolationSegmentUrl;
    private String managersUrl;
    private String name;
    private String privateDomainsUrl;
    private String quotaDefinitionId;
    private String quotaDefinitionUrl;
    private String spaceQuotaDefinitionsUrl;
    private String spacesUrl;
    private String status;
    private String usersUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationEntity instance) {
      return from((_OrganizationEntity) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String applicationEventsUrlValue = instance.getApplicationEventsUrl();
      if (applicationEventsUrlValue != null) {
        applicationEventsUrl(applicationEventsUrlValue);
      }
      String auditorsUrlValue = instance.getAuditorsUrl();
      if (auditorsUrlValue != null) {
        auditorsUrl(auditorsUrlValue);
      }
      Boolean billingEnabledValue = instance.getBillingEnabled();
      if (billingEnabledValue != null) {
        billingEnabled(billingEnabledValue);
      }
      String billingManagersUrlValue = instance.getBillingManagersUrl();
      if (billingManagersUrlValue != null) {
        billingManagersUrl(billingManagersUrlValue);
      }
      String defaultIsolationSegmentIdValue = instance.getDefaultIsolationSegmentId();
      if (defaultIsolationSegmentIdValue != null) {
        defaultIsolationSegmentId(defaultIsolationSegmentIdValue);
      }
      String domainsUrlValue = instance.getDomainsUrl();
      if (domainsUrlValue != null) {
        domainsUrl(domainsUrlValue);
      }
      String isolationSegmentUrlValue = instance.getIsolationSegmentUrl();
      if (isolationSegmentUrlValue != null) {
        isolationSegmentUrl(isolationSegmentUrlValue);
      }
      String managersUrlValue = instance.getManagersUrl();
      if (managersUrlValue != null) {
        managersUrl(managersUrlValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String privateDomainsUrlValue = instance.getPrivateDomainsUrl();
      if (privateDomainsUrlValue != null) {
        privateDomainsUrl(privateDomainsUrlValue);
      }
      String quotaDefinitionIdValue = instance.getQuotaDefinitionId();
      if (quotaDefinitionIdValue != null) {
        quotaDefinitionId(quotaDefinitionIdValue);
      }
      String quotaDefinitionUrlValue = instance.getQuotaDefinitionUrl();
      if (quotaDefinitionUrlValue != null) {
        quotaDefinitionUrl(quotaDefinitionUrlValue);
      }
      String spaceQuotaDefinitionsUrlValue = instance.getSpaceQuotaDefinitionsUrl();
      if (spaceQuotaDefinitionsUrlValue != null) {
        spaceQuotaDefinitionsUrl(spaceQuotaDefinitionsUrlValue);
      }
      String spacesUrlValue = instance.getSpacesUrl();
      if (spacesUrlValue != null) {
        spacesUrl(spacesUrlValue);
      }
      String statusValue = instance.getStatus();
      if (statusValue != null) {
        status(statusValue);
      }
      String usersUrlValue = instance.getUsersUrl();
      if (usersUrlValue != null) {
        usersUrl(usersUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getApplicationEventsUrl() applicationEventsUrl} attribute.
     * @param applicationEventsUrl The value for applicationEventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_events_url")
    public final Builder applicationEventsUrl(@Nullable String applicationEventsUrl) {
      this.applicationEventsUrl = applicationEventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getAuditorsUrl() auditorsUrl} attribute.
     * @param auditorsUrl The value for auditorsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("auditors_url")
    public final Builder auditorsUrl(@Nullable String auditorsUrl) {
      this.auditorsUrl = auditorsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getBillingEnabled() billingEnabled} attribute.
     * @param billingEnabled The value for billingEnabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("billing_enabled")
    public final Builder billingEnabled(@Nullable Boolean billingEnabled) {
      this.billingEnabled = billingEnabled;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getBillingManagersUrl() billingManagersUrl} attribute.
     * @param billingManagersUrl The value for billingManagersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("billing_managers_url")
    public final Builder billingManagersUrl(@Nullable String billingManagersUrl) {
      this.billingManagersUrl = billingManagersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getDefaultIsolationSegmentId() defaultIsolationSegmentId} attribute.
     * @param defaultIsolationSegmentId The value for defaultIsolationSegmentId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("default_isolation_segment_guid")
    public final Builder defaultIsolationSegmentId(@Nullable String defaultIsolationSegmentId) {
      this.defaultIsolationSegmentId = defaultIsolationSegmentId;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getDomainsUrl() domainsUrl} attribute.
     * @param domainsUrl The value for domainsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("domains_url")
    public final Builder domainsUrl(@Nullable String domainsUrl) {
      this.domainsUrl = domainsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getIsolationSegmentUrl() isolationSegmentUrl} attribute.
     * @param isolationSegmentUrl The value for isolationSegmentUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("isolation_segment_url")
    public final Builder isolationSegmentUrl(@Nullable String isolationSegmentUrl) {
      this.isolationSegmentUrl = isolationSegmentUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getManagersUrl() managersUrl} attribute.
     * @param managersUrl The value for managersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("managers_url")
    public final Builder managersUrl(@Nullable String managersUrl) {
      this.managersUrl = managersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getPrivateDomainsUrl() privateDomainsUrl} attribute.
     * @param privateDomainsUrl The value for privateDomainsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("private_domains_url")
    public final Builder privateDomainsUrl(@Nullable String privateDomainsUrl) {
      this.privateDomainsUrl = privateDomainsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getQuotaDefinitionId() quotaDefinitionId} attribute.
     * @param quotaDefinitionId The value for quotaDefinitionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("quota_definition_guid")
    public final Builder quotaDefinitionId(@Nullable String quotaDefinitionId) {
      this.quotaDefinitionId = quotaDefinitionId;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getQuotaDefinitionUrl() quotaDefinitionUrl} attribute.
     * @param quotaDefinitionUrl The value for quotaDefinitionUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("quota_definition_url")
    public final Builder quotaDefinitionUrl(@Nullable String quotaDefinitionUrl) {
      this.quotaDefinitionUrl = quotaDefinitionUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getSpaceQuotaDefinitionsUrl() spaceQuotaDefinitionsUrl} attribute.
     * @param spaceQuotaDefinitionsUrl The value for spaceQuotaDefinitionsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_quota_definitions_url")
    public final Builder spaceQuotaDefinitionsUrl(@Nullable String spaceQuotaDefinitionsUrl) {
      this.spaceQuotaDefinitionsUrl = spaceQuotaDefinitionsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getSpacesUrl() spacesUrl} attribute.
     * @param spacesUrl The value for spacesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("spaces_url")
    public final Builder spacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationEntity#getUsersUrl() usersUrl} attribute.
     * @param usersUrl The value for usersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("users_url")
    public final Builder usersUrl(@Nullable String usersUrl) {
      this.usersUrl = usersUrl;
      return this;
    }

    /**
     * Builds a new {@link OrganizationEntity OrganizationEntity}.
     * @return An immutable instance of OrganizationEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationEntity build() {
      return new OrganizationEntity(this);
    }
  }
}
