package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload to Update a Service Broker
 */
@Generated(from = "_UpdateServiceBrokerRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceBrokerRequest
    extends org.cloudfoundry.client.v2.servicebrokers._UpdateServiceBrokerRequest {
  private final @Nullable String authenticationPassword;
  private final @Nullable String authenticationUsername;
  private final @Nullable String brokerUrl;
  private final @Nullable String name;
  private final String serviceBrokerId;

  private UpdateServiceBrokerRequest(UpdateServiceBrokerRequest.Builder builder) {
    this.authenticationPassword = builder.authenticationPassword;
    this.authenticationUsername = builder.authenticationUsername;
    this.brokerUrl = builder.brokerUrl;
    this.name = builder.name;
    this.serviceBrokerId = builder.serviceBrokerId;
  }

  /**
   * The password with which to authenticate against the service broker.
   */
  @JsonProperty("auth_password")
  @Override
  public @Nullable String getAuthenticationPassword() {
    return authenticationPassword;
  }

  /**
   * The username with which to authenticate against the service broker.
   */
  @JsonProperty("auth_username")
  @Override
  public @Nullable String getAuthenticationUsername() {
    return authenticationUsername;
  }

  /**
   * The url of the service broker.
   */
  @JsonProperty("broker_url")
  @Override
  public @Nullable String getBrokerUrl() {
    return brokerUrl;
  }

  /**
   * The name of the service broker.
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The service broker id
   */
  @JsonProperty("serviceBrokerId")
  @JsonIgnore
  @Override
  public String getServiceBrokerId() {
    return serviceBrokerId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceBrokerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceBrokerRequest
        && equalTo((UpdateServiceBrokerRequest) another);
  }

  private boolean equalTo(UpdateServiceBrokerRequest another) {
    return Objects.equals(authenticationPassword, another.authenticationPassword)
        && Objects.equals(authenticationUsername, another.authenticationUsername)
        && Objects.equals(brokerUrl, another.brokerUrl)
        && Objects.equals(name, another.name)
        && serviceBrokerId.equals(another.serviceBrokerId);
  }

  /**
   * Computes a hash code from attributes: {@code authenticationPassword}, {@code authenticationUsername}, {@code brokerUrl}, {@code name}, {@code serviceBrokerId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(authenticationPassword);
    h += (h << 5) + Objects.hashCode(authenticationUsername);
    h += (h << 5) + Objects.hashCode(brokerUrl);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + serviceBrokerId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceBrokerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceBrokerRequest{"
        + "authenticationPassword=" + authenticationPassword
        + ", authenticationUsername=" + authenticationUsername
        + ", brokerUrl=" + brokerUrl
        + ", name=" + name
        + ", serviceBrokerId=" + serviceBrokerId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServiceBrokerRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.servicebrokers._UpdateServiceBrokerRequest {
    String authenticationPassword;
    String authenticationUsername;
    String brokerUrl;
    String name;
    String serviceBrokerId;
    @JsonProperty("auth_password")
    public void setAuthenticationPassword(@Nullable String authenticationPassword) {
      this.authenticationPassword = authenticationPassword;
    }
    @JsonProperty("auth_username")
    public void setAuthenticationUsername(@Nullable String authenticationUsername) {
      this.authenticationUsername = authenticationUsername;
    }
    @JsonProperty("broker_url")
    public void setBrokerUrl(@Nullable String brokerUrl) {
      this.brokerUrl = brokerUrl;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("serviceBrokerId")
    @JsonIgnore
    public void setServiceBrokerId(String serviceBrokerId) {
      this.serviceBrokerId = serviceBrokerId;
    }
    @Override
    public String getAuthenticationPassword() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthenticationUsername() { throw new UnsupportedOperationException(); }
    @Override
    public String getBrokerUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBrokerId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServiceBrokerRequest fromJson(Json json) {
    UpdateServiceBrokerRequest.Builder builder = UpdateServiceBrokerRequest.builder();
    if (json.authenticationPassword != null) {
      builder.authenticationPassword(json.authenticationPassword);
    }
    if (json.authenticationUsername != null) {
      builder.authenticationUsername(json.authenticationUsername);
    }
    if (json.brokerUrl != null) {
      builder.brokerUrl(json.brokerUrl);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.serviceBrokerId != null) {
      builder.serviceBrokerId(json.serviceBrokerId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
   * <pre>
   * UpdateServiceBrokerRequest.builder()
   *    .authenticationPassword(String | null) // nullable {@link UpdateServiceBrokerRequest#getAuthenticationPassword() authenticationPassword}
   *    .authenticationUsername(String | null) // nullable {@link UpdateServiceBrokerRequest#getAuthenticationUsername() authenticationUsername}
   *    .brokerUrl(String | null) // nullable {@link UpdateServiceBrokerRequest#getBrokerUrl() brokerUrl}
   *    .name(String | null) // nullable {@link UpdateServiceBrokerRequest#getName() name}
   *    .serviceBrokerId(String) // required {@link UpdateServiceBrokerRequest#getServiceBrokerId() serviceBrokerId}
   *    .build();
   * </pre>
   * @return A new UpdateServiceBrokerRequest builder
   */
  public static UpdateServiceBrokerRequest.Builder builder() {
    return new UpdateServiceBrokerRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceBrokerRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BROKER_ID = 0x1L;
    private long initBits = 0x1L;

    private String authenticationPassword;
    private String authenticationUsername;
    private String brokerUrl;
    private String name;
    private String serviceBrokerId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceBrokerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceBrokerRequest instance) {
      return from((_UpdateServiceBrokerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceBrokerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceBrokerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String authenticationPasswordValue = instance.getAuthenticationPassword();
      if (authenticationPasswordValue != null) {
        authenticationPassword(authenticationPasswordValue);
      }
      String authenticationUsernameValue = instance.getAuthenticationUsername();
      if (authenticationUsernameValue != null) {
        authenticationUsername(authenticationUsernameValue);
      }
      String brokerUrlValue = instance.getBrokerUrl();
      if (brokerUrlValue != null) {
        brokerUrl(brokerUrlValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      serviceBrokerId(instance.getServiceBrokerId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getAuthenticationPassword() authenticationPassword} attribute.
     * @param authenticationPassword The value for authenticationPassword (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authenticationPassword(@Nullable String authenticationPassword) {
      this.authenticationPassword = authenticationPassword;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getAuthenticationUsername() authenticationUsername} attribute.
     * @param authenticationUsername The value for authenticationUsername (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authenticationUsername(@Nullable String authenticationUsername) {
      this.authenticationUsername = authenticationUsername;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getBrokerUrl() brokerUrl} attribute.
     * @param brokerUrl The value for brokerUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder brokerUrl(@Nullable String brokerUrl) {
      this.brokerUrl = brokerUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getServiceBrokerId() serviceBrokerId} attribute.
     * @param serviceBrokerId The value for serviceBrokerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String serviceBrokerId) {
      this.serviceBrokerId = Objects.requireNonNull(serviceBrokerId, "serviceBrokerId");
      initBits &= ~INIT_BIT_SERVICE_BROKER_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
     * @return An immutable instance of UpdateServiceBrokerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceBrokerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceBrokerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_BROKER_ID) != 0) attributes.add("serviceBrokerId");
      return "Cannot build UpdateServiceBrokerRequest, some of required attributes are not set " + attributes;
    }
  }
}
