package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.jobs.JobEntity;
import org.cloudfoundry.client.v2.serviceinstances._DeleteServiceInstanceResponse.DeleteServiceInstanceResponseTypeIdResolver;
import org.immutables.value.Generated;

/**
 * The response for the Delete Service Instance operation
 */
@Generated(from = "_DeleteServiceInstanceResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteServiceInstanceResponse
    extends org.cloudfoundry.client.v2.serviceinstances._DeleteServiceInstanceResponse {
  private final @Nullable Metadata metadata;
  private final @Nullable Object entity;

  private DeleteServiceInstanceResponse(DeleteServiceInstanceResponse.Builder builder) {
    this.metadata = builder.metadata;
    this.entity = builder.entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @JsonTypeIdResolver(DeleteServiceInstanceResponseTypeIdResolver.class)
  @JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", defaultImpl = JobEntity.class, visible = true)
  @Override
  public @Nullable Object getEntity() {
    return entity;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceInstanceResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceInstanceResponse
        && equalTo((DeleteServiceInstanceResponse) another);
  }

  private boolean equalTo(DeleteServiceInstanceResponse another) {
    return Objects.equals(metadata, another.metadata)
        && Objects.equals(entity, another.entity);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code entity}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(entity);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceInstanceResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceInstanceResponse{"
        + "metadata=" + metadata
        + ", entity=" + entity
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_DeleteServiceInstanceResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._DeleteServiceInstanceResponse {
    Metadata metadata;
    Object entity;
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("entity")
    @JsonTypeIdResolver(DeleteServiceInstanceResponseTypeIdResolver.class)
    @JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", defaultImpl = JobEntity.class, visible = true)
    public void setEntity(@Nullable Object entity) {
      this.entity = entity;
    }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Object getEntity() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DeleteServiceInstanceResponse fromJson(Json json) {
    DeleteServiceInstanceResponse.Builder builder = DeleteServiceInstanceResponse.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DeleteServiceInstanceResponse DeleteServiceInstanceResponse}.
   * <pre>
   * DeleteServiceInstanceResponse.builder()
   *    .metadata(org.cloudfoundry.client.v2.Metadata | null) // nullable {@link DeleteServiceInstanceResponse#getMetadata() metadata}
   *    .entity(Object | null) // nullable {@link DeleteServiceInstanceResponse#getEntity() entity}
   *    .build();
   * </pre>
   * @return A new DeleteServiceInstanceResponse builder
   */
  public static DeleteServiceInstanceResponse.Builder builder() {
    return new DeleteServiceInstanceResponse.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceInstanceResponse DeleteServiceInstanceResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteServiceInstanceResponse", generator = "Immutables")
  public static final class Builder {
    private Metadata metadata;
    private Object entity;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceInstanceResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceInstanceResponse instance) {
      return from((_DeleteServiceInstanceResponse) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceInstanceResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceInstanceResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      Object entityValue = instance.getEntity();
      if (entityValue != null) {
        entity(entityValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceInstanceResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceInstanceResponse#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    @JsonTypeIdResolver(DeleteServiceInstanceResponseTypeIdResolver.class)
    @JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", defaultImpl = JobEntity.class, visible = true)
    public final Builder entity(@Nullable Object entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceInstanceResponse DeleteServiceInstanceResponse}.
     * @return An immutable instance of DeleteServiceInstanceResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceInstanceResponse build() {
      return new DeleteServiceInstanceResponse(this);
    }
  }
}
