package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for shared (to or from) services
 */
@Generated(from = "_Share", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Share extends org.cloudfoundry.client.v2.serviceinstances._Share {
  private final @Nullable String organizationName;
  private final @Nullable String spaceId;
  private final @Nullable String spaceName;

  private Share(Share.Builder builder) {
    this.organizationName = builder.organizationName;
    this.spaceId = builder.spaceId;
    this.spaceName = builder.spaceName;
  }

  /**
   * The organization name
   */
  @JsonProperty("organization_name")
  @Override
  public @Nullable String getOrganizationName() {
    return organizationName;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The space name
   */
  @JsonProperty("space_name")
  @Override
  public @Nullable String getSpaceName() {
    return spaceName;
  }

  /**
   * This instance is equal to all instances of {@code Share} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Share
        && equalTo((Share) another);
  }

  private boolean equalTo(Share another) {
    return Objects.equals(organizationName, another.organizationName)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(spaceName, another.spaceName);
  }

  /**
   * Computes a hash code from attributes: {@code organizationName}, {@code spaceId}, {@code spaceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(organizationName);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(spaceName);
    return h;
  }

  /**
   * Prints the immutable value {@code Share} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Share{"
        + "organizationName=" + organizationName
        + ", spaceId=" + spaceId
        + ", spaceName=" + spaceName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Share", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._Share {
    String organizationName;
    String spaceId;
    String spaceName;
    @JsonProperty("organization_name")
    public void setOrganizationName(@Nullable String organizationName) {
      this.organizationName = organizationName;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("space_name")
    public void setSpaceName(@Nullable String spaceName) {
      this.spaceName = spaceName;
    }
    @Override
    public String getOrganizationName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Share fromJson(Json json) {
    Share.Builder builder = Share.builder();
    if (json.organizationName != null) {
      builder.organizationName(json.organizationName);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.spaceName != null) {
      builder.spaceName(json.spaceName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Share Share}.
   * <pre>
   * Share.builder()
   *    .organizationName(String | null) // nullable {@link Share#getOrganizationName() organizationName}
   *    .spaceId(String | null) // nullable {@link Share#getSpaceId() spaceId}
   *    .spaceName(String | null) // nullable {@link Share#getSpaceName() spaceName}
   *    .build();
   * </pre>
   * @return A new Share builder
   */
  public static Share.Builder builder() {
    return new Share.Builder();
  }

  /**
   * Builds instances of type {@link Share Share}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Share", generator = "Immutables")
  public static final class Builder {
    private String organizationName;
    private String spaceId;
    private String spaceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Share} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Share instance) {
      return from((_Share) instance);
    }

    /**
     * Copy abstract value type {@code _Share} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Share instance) {
      Objects.requireNonNull(instance, "instance");
      String organizationNameValue = instance.getOrganizationName();
      if (organizationNameValue != null) {
        organizationName(organizationNameValue);
      }
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      String spaceNameValue = instance.getSpaceName();
      if (spaceNameValue != null) {
        spaceName(spaceNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Share#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization_name")
    public final Builder organizationName(@Nullable String organizationName) {
      this.organizationName = organizationName;
      return this;
    }

    /**
     * Initializes the value for the {@link Share#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link Share#getSpaceName() spaceName} attribute.
     * @param spaceName The value for spaceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_name")
    public final Builder spaceName(@Nullable String spaceName) {
      this.spaceName = spaceName;
      return this;
    }

    /**
     * Builds a new {@link Share Share}.
     * @return An immutable instance of Share
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Share build() {
      return new Share(this);
    }
  }
}
