package org.cloudfoundry.client.v2.serviceplanvisibilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Service Service Plan Visibilities operation
 */
@Generated(from = "_ListServicePlanVisibilitiesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServicePlanVisibilitiesRequest
    extends org.cloudfoundry.client.v2.serviceplanvisibilities._ListServicePlanVisibilitiesRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable List<String> organizationIds;
  private final @Nullable List<String> servicePlanIds;

  private ListServicePlanVisibilitiesRequest(ListServicePlanVisibilitiesRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.servicePlanIds = builder.servicePlanIds == null ? null : createUnmodifiableList(true, builder.servicePlanIds);
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The service plan ids
   */
  @Override
  public @Nullable List<String> getServicePlanIds() {
    return servicePlanIds;
  }

  /**
   * This instance is equal to all instances of {@code ListServicePlanVisibilitiesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServicePlanVisibilitiesRequest
        && equalTo((ListServicePlanVisibilitiesRequest) another);
  }

  private boolean equalTo(ListServicePlanVisibilitiesRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(organizationIds, another.organizationIds)
        && Objects.equals(servicePlanIds, another.servicePlanIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code organizationIds}, {@code servicePlanIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + Objects.hashCode(servicePlanIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServicePlanVisibilitiesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServicePlanVisibilitiesRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", organizationIds=" + organizationIds
        + ", servicePlanIds=" + servicePlanIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListServicePlanVisibilitiesRequest ListServicePlanVisibilitiesRequest}.
   * <pre>
   * ListServicePlanVisibilitiesRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListServicePlanVisibilitiesRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListServicePlanVisibilitiesRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListServicePlanVisibilitiesRequest#getResultsPerPage() resultsPerPage}
   *    .organizationIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlanVisibilitiesRequest#getOrganizationIds() organizationIds}
   *    .servicePlanIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlanVisibilitiesRequest#getServicePlanIds() servicePlanIds}
   *    .build();
   * </pre>
   * @return A new ListServicePlanVisibilitiesRequest builder
   */
  public static ListServicePlanVisibilitiesRequest.Builder builder() {
    return new ListServicePlanVisibilitiesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServicePlanVisibilitiesRequest ListServicePlanVisibilitiesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServicePlanVisibilitiesRequest", generator = "Immutables")
  public static final class Builder {
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private List<String> organizationIds = null;
    private List<String> servicePlanIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServicePlanVisibilitiesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServicePlanVisibilitiesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServicePlanVisibilitiesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServicePlanVisibilitiesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.serviceplanvisibilities._ListServicePlanVisibilitiesRequest) {
        org.cloudfoundry.client.v2.serviceplanvisibilities._ListServicePlanVisibilitiesRequest instance = (org.cloudfoundry.client.v2.serviceplanvisibilities._ListServicePlanVisibilitiesRequest) object;
        List<String> servicePlanIdsValue = instance.getServicePlanIds();
        if (servicePlanIdsValue != null) {
          addAllServicePlanIds(servicePlanIdsValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListServicePlanVisibilitiesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlanVisibilitiesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlanVisibilitiesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlanVisibilitiesRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlanVisibilitiesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlanVisibilitiesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlanVisibilitiesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlanVisibilitiesRequest#getServicePlanIds() servicePlanIds} list.
     * @param element A servicePlanIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String element) {
      if (this.servicePlanIds == null) {
        this.servicePlanIds = new ArrayList<String>();
      }
      this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlanVisibilitiesRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An array of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanIds(String... elements) {
      if (this.servicePlanIds == null) {
        this.servicePlanIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlanVisibilitiesRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An iterable of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.servicePlanIds = null;
        return this;
      }
      this.servicePlanIds = new ArrayList<String>();
      return addAllServicePlanIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlanVisibilitiesRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An iterable of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServicePlanIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "servicePlanIds element");
      if (this.servicePlanIds == null) {
        this.servicePlanIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListServicePlanVisibilitiesRequest ListServicePlanVisibilitiesRequest}.
     * @return An immutable instance of ListServicePlanVisibilitiesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServicePlanVisibilitiesRequest build() {
      return new ListServicePlanVisibilitiesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
