package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Create a Space Quota Definition operation
 */
@Generated(from = "_CreateSpaceQuotaDefinitionRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateSpaceQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.spacequotadefinitions._CreateSpaceQuotaDefinitionRequest {
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer applicationTaskLimit;
  private final @Nullable Integer instanceMemoryLimit;
  private final Integer memoryLimit;
  private final String name;
  private final Boolean nonBasicServicesAllowed;
  private final String organizationId;
  private final @Nullable Integer totalReservedRoutePorts;
  private final Integer totalRoutes;
  private final @Nullable Integer totalServiceKeys;
  private final Integer totalServices;

  private CreateSpaceQuotaDefinitionRequest(CreateSpaceQuotaDefinitionRequest.Builder builder) {
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.applicationTaskLimit = builder.applicationTaskLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
    this.organizationId = builder.organizationId;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceKeys = builder.totalServiceKeys;
    this.totalServices = builder.totalServices;
  }

  /**
   * How many app instances a space can create. (-1 represents an unlimited amount)
   */
  @JsonProperty("app_instance_limit")
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The number of tasks that can be run per app. (-1 represents an unlimited amount)
   */
  @JsonProperty("app_task_limit")
  @Override
  public @Nullable Integer getApplicationTaskLimit() {
    return applicationTaskLimit;
  }

  /**
   * The maximum amount of memory in megabytes an application instance can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("instance_memory_limit")
  @Override
  public @Nullable Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * How much memory in megabytes a space can have
   */
  @JsonProperty("memory_limit")
  @Override
  public Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * If a space can have non basic services
   */
  @JsonProperty("non_basic_services_allowed")
  @Override
  public Boolean getNonBasicServicesAllowed() {
    return nonBasicServicesAllowed;
  }

  /**
   * The owning organization of the space quota
   */
  @JsonProperty("organization_guid")
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * How many routes a space can have that use a reserved port. These routes count toward total_routes. (-1 represents an unlimited amount; subject to org quota)
   */
  @JsonProperty("total_reserved_route_ports")
  @Override
  public @Nullable Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * How many routes a space can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("total_routes")
  @Override
  public Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * How many service keys an organization can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("total_service_keys")
  @Override
  public @Nullable Integer getTotalServiceKeys() {
    return totalServiceKeys;
  }

  /**
   * How many services a space can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("total_services")
  @Override
  public Integer getTotalServices() {
    return totalServices;
  }

  /**
   * This instance is equal to all instances of {@code CreateSpaceQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSpaceQuotaDefinitionRequest
        && equalTo((CreateSpaceQuotaDefinitionRequest) another);
  }

  private boolean equalTo(CreateSpaceQuotaDefinitionRequest another) {
    return Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(applicationTaskLimit, another.applicationTaskLimit)
        && Objects.equals(instanceMemoryLimit, another.instanceMemoryLimit)
        && memoryLimit.equals(another.memoryLimit)
        && name.equals(another.name)
        && nonBasicServicesAllowed.equals(another.nonBasicServicesAllowed)
        && organizationId.equals(another.organizationId)
        && Objects.equals(totalReservedRoutePorts, another.totalReservedRoutePorts)
        && totalRoutes.equals(another.totalRoutes)
        && Objects.equals(totalServiceKeys, another.totalServiceKeys)
        && totalServices.equals(another.totalServices);
  }

  /**
   * Computes a hash code from attributes: {@code applicationInstanceLimit}, {@code applicationTaskLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code nonBasicServicesAllowed}, {@code organizationId}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServiceKeys}, {@code totalServices}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationInstanceLimit);
    h += (h << 5) + Objects.hashCode(applicationTaskLimit);
    h += (h << 5) + Objects.hashCode(instanceMemoryLimit);
    h += (h << 5) + memoryLimit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + nonBasicServicesAllowed.hashCode();
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(totalReservedRoutePorts);
    h += (h << 5) + totalRoutes.hashCode();
    h += (h << 5) + Objects.hashCode(totalServiceKeys);
    h += (h << 5) + totalServices.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSpaceQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSpaceQuotaDefinitionRequest{"
        + "applicationInstanceLimit=" + applicationInstanceLimit
        + ", applicationTaskLimit=" + applicationTaskLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", nonBasicServicesAllowed=" + nonBasicServicesAllowed
        + ", organizationId=" + organizationId
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceKeys=" + totalServiceKeys
        + ", totalServices=" + totalServices
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateSpaceQuotaDefinitionRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.spacequotadefinitions._CreateSpaceQuotaDefinitionRequest {
    Integer applicationInstanceLimit;
    Integer applicationTaskLimit;
    Integer instanceMemoryLimit;
    Integer memoryLimit;
    String name;
    Boolean nonBasicServicesAllowed;
    String organizationId;
    Integer totalReservedRoutePorts;
    Integer totalRoutes;
    Integer totalServiceKeys;
    Integer totalServices;
    @JsonProperty("app_instance_limit")
    public void setApplicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
    }
    @JsonProperty("app_task_limit")
    public void setApplicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
    }
    @JsonProperty("instance_memory_limit")
    public void setInstanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
    }
    @JsonProperty("memory_limit")
    public void setMemoryLimit(Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("non_basic_services_allowed")
    public void setNonBasicServicesAllowed(Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
    }
    @JsonProperty("organization_guid")
    public void setOrganizationId(String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("total_reserved_route_ports")
    public void setTotalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
    }
    @JsonProperty("total_routes")
    public void setTotalRoutes(Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
    }
    @JsonProperty("total_service_keys")
    public void setTotalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
    }
    @JsonProperty("total_services")
    public void setTotalServices(Integer totalServices) {
      this.totalServices = totalServices;
    }
    @Override
    public Integer getApplicationInstanceLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getApplicationTaskLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstanceMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getNonBasicServicesAllowed() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalReservedRoutePorts() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalRoutes() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServiceKeys() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServices() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateSpaceQuotaDefinitionRequest fromJson(Json json) {
    CreateSpaceQuotaDefinitionRequest.Builder builder = CreateSpaceQuotaDefinitionRequest.builder();
    if (json.applicationInstanceLimit != null) {
      builder.applicationInstanceLimit(json.applicationInstanceLimit);
    }
    if (json.applicationTaskLimit != null) {
      builder.applicationTaskLimit(json.applicationTaskLimit);
    }
    if (json.instanceMemoryLimit != null) {
      builder.instanceMemoryLimit(json.instanceMemoryLimit);
    }
    if (json.memoryLimit != null) {
      builder.memoryLimit(json.memoryLimit);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.nonBasicServicesAllowed != null) {
      builder.nonBasicServicesAllowed(json.nonBasicServicesAllowed);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.totalReservedRoutePorts != null) {
      builder.totalReservedRoutePorts(json.totalReservedRoutePorts);
    }
    if (json.totalRoutes != null) {
      builder.totalRoutes(json.totalRoutes);
    }
    if (json.totalServiceKeys != null) {
      builder.totalServiceKeys(json.totalServiceKeys);
    }
    if (json.totalServices != null) {
      builder.totalServices(json.totalServices);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateSpaceQuotaDefinitionRequest CreateSpaceQuotaDefinitionRequest}.
   * <pre>
   * CreateSpaceQuotaDefinitionRequest.builder()
   *    .applicationInstanceLimit(Integer | null) // nullable {@link CreateSpaceQuotaDefinitionRequest#getApplicationInstanceLimit() applicationInstanceLimit}
   *    .applicationTaskLimit(Integer | null) // nullable {@link CreateSpaceQuotaDefinitionRequest#getApplicationTaskLimit() applicationTaskLimit}
   *    .instanceMemoryLimit(Integer | null) // nullable {@link CreateSpaceQuotaDefinitionRequest#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .memoryLimit(Integer) // required {@link CreateSpaceQuotaDefinitionRequest#getMemoryLimit() memoryLimit}
   *    .name(String) // required {@link CreateSpaceQuotaDefinitionRequest#getName() name}
   *    .nonBasicServicesAllowed(Boolean) // required {@link CreateSpaceQuotaDefinitionRequest#getNonBasicServicesAllowed() nonBasicServicesAllowed}
   *    .organizationId(String) // required {@link CreateSpaceQuotaDefinitionRequest#getOrganizationId() organizationId}
   *    .totalReservedRoutePorts(Integer | null) // nullable {@link CreateSpaceQuotaDefinitionRequest#getTotalReservedRoutePorts() totalReservedRoutePorts}
   *    .totalRoutes(Integer) // required {@link CreateSpaceQuotaDefinitionRequest#getTotalRoutes() totalRoutes}
   *    .totalServiceKeys(Integer | null) // nullable {@link CreateSpaceQuotaDefinitionRequest#getTotalServiceKeys() totalServiceKeys}
   *    .totalServices(Integer) // required {@link CreateSpaceQuotaDefinitionRequest#getTotalServices() totalServices}
   *    .build();
   * </pre>
   * @return A new CreateSpaceQuotaDefinitionRequest builder
   */
  public static CreateSpaceQuotaDefinitionRequest.Builder builder() {
    return new CreateSpaceQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateSpaceQuotaDefinitionRequest CreateSpaceQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateSpaceQuotaDefinitionRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MEMORY_LIMIT = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_NON_BASIC_SERVICES_ALLOWED = 0x4L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x8L;
    private static final long INIT_BIT_TOTAL_ROUTES = 0x10L;
    private static final long INIT_BIT_TOTAL_SERVICES = 0x20L;
    private long initBits = 0x3fL;

    private Integer applicationInstanceLimit;
    private Integer applicationTaskLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Boolean nonBasicServicesAllowed;
    private String organizationId;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServiceKeys;
    private Integer totalServices;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSpaceQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSpaceQuotaDefinitionRequest instance) {
      return from((_CreateSpaceQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSpaceQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSpaceQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer applicationTaskLimitValue = instance.getApplicationTaskLimit();
      if (applicationTaskLimitValue != null) {
        applicationTaskLimit(applicationTaskLimitValue);
      }
      Integer instanceMemoryLimitValue = instance.getInstanceMemoryLimit();
      if (instanceMemoryLimitValue != null) {
        instanceMemoryLimit(instanceMemoryLimitValue);
      }
      memoryLimit(instance.getMemoryLimit());
      name(instance.getName());
      nonBasicServicesAllowed(instance.getNonBasicServicesAllowed());
      organizationId(instance.getOrganizationId());
      Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
      if (totalReservedRoutePortsValue != null) {
        totalReservedRoutePorts(totalReservedRoutePortsValue);
      }
      totalRoutes(instance.getTotalRoutes());
      Integer totalServiceKeysValue = instance.getTotalServiceKeys();
      if (totalServiceKeysValue != null) {
        totalServiceKeys(totalServiceKeysValue);
      }
      totalServices(instance.getTotalServices());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getApplicationTaskLimit() applicationTaskLimit} attribute.
     * @param applicationTaskLimit The value for applicationTaskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(Integer memoryLimit) {
      this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
      initBits &= ~INIT_BIT_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getNonBasicServicesAllowed() nonBasicServicesAllowed} attribute.
     * @param nonBasicServicesAllowed The value for nonBasicServicesAllowed 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nonBasicServicesAllowed(Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = Objects.requireNonNull(nonBasicServicesAllowed, "nonBasicServicesAllowed");
      initBits &= ~INIT_BIT_NON_BASIC_SERVICES_ALLOWED;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(Integer totalRoutes) {
      this.totalRoutes = Objects.requireNonNull(totalRoutes, "totalRoutes");
      initBits &= ~INIT_BIT_TOTAL_ROUTES;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getTotalServiceKeys() totalServiceKeys} attribute.
     * @param totalServiceKeys The value for totalServiceKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionRequest#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServices(Integer totalServices) {
      this.totalServices = Objects.requireNonNull(totalServices, "totalServices");
      initBits &= ~INIT_BIT_TOTAL_SERVICES;
      return this;
    }

    /**
     * Builds a new {@link CreateSpaceQuotaDefinitionRequest CreateSpaceQuotaDefinitionRequest}.
     * @return An immutable instance of CreateSpaceQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSpaceQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateSpaceQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MEMORY_LIMIT) != 0) attributes.add("memoryLimit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NON_BASIC_SERVICES_ALLOWED) != 0) attributes.add("nonBasicServicesAllowed");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_TOTAL_ROUTES) != 0) attributes.add("totalRoutes");
      if ((initBits & INIT_BIT_TOTAL_SERVICES) != 0) attributes.add("totalServices");
      return "Cannot build CreateSpaceQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
