package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the deprecated List all Domains for the Space operation
 */
@Generated(from = "_ListSpaceDomainsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListSpaceDomainsRequest extends org.cloudfoundry.client.v2.spaces._ListSpaceDomainsRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable List<String> names;
  private final @Nullable List<String> owningOrganizationIds;
  private final String spaceId;

  private ListSpaceDomainsRequest(ListSpaceDomainsRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.owningOrganizationIds = builder.owningOrganizationIds == null ? null : createUnmodifiableList(true, builder.owningOrganizationIds);
    this.spaceId = builder.spaceId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The owning organization ids
   */
  @Override
  public @Nullable List<String> getOwningOrganizationIds() {
    return owningOrganizationIds;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code ListSpaceDomainsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSpaceDomainsRequest
        && equalTo((ListSpaceDomainsRequest) another);
  }

  private boolean equalTo(ListSpaceDomainsRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(names, another.names)
        && Objects.equals(owningOrganizationIds, another.owningOrganizationIds)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code names}, {@code owningOrganizationIds}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(owningOrganizationIds);
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListSpaceDomainsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSpaceDomainsRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", names=" + names
        + ", owningOrganizationIds=" + owningOrganizationIds
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link ListSpaceDomainsRequest ListSpaceDomainsRequest}.
   * <pre>
   * ListSpaceDomainsRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListSpaceDomainsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListSpaceDomainsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListSpaceDomainsRequest#getResultsPerPage() resultsPerPage}
   *    .names(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceDomainsRequest#getNames() names}
   *    .owningOrganizationIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceDomainsRequest#getOwningOrganizationIds() owningOrganizationIds}
   *    .spaceId(String) // required {@link ListSpaceDomainsRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new ListSpaceDomainsRequest builder
   */
  public static ListSpaceDomainsRequest.Builder builder() {
    return new ListSpaceDomainsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSpaceDomainsRequest ListSpaceDomainsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListSpaceDomainsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private List<String> names = null;
    private List<String> owningOrganizationIds = null;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSpaceDomainsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSpaceDomainsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListSpaceDomainsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListSpaceDomainsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.spaces._ListSpaceDomainsRequest) {
        org.cloudfoundry.client.v2.spaces._ListSpaceDomainsRequest instance = (org.cloudfoundry.client.v2.spaces._ListSpaceDomainsRequest) object;
        List<String> owningOrganizationIdsValue = instance.getOwningOrganizationIds();
        if (owningOrganizationIdsValue != null) {
          addAllOwningOrganizationIds(owningOrganizationIdsValue);
        }
        spaceId(instance.getSpaceId());
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListSpaceDomainsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceDomainsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceDomainsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceDomainsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceDomainsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceDomainsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListSpaceDomainsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceDomainsRequest#getOwningOrganizationIds() owningOrganizationIds} list.
     * @param element A owningOrganizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationId(String element) {
      if (this.owningOrganizationIds == null) {
        this.owningOrganizationIds = new ArrayList<String>();
      }
      this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceDomainsRequest#getOwningOrganizationIds() owningOrganizationIds} list.
     * @param elements An array of owningOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationIds(String... elements) {
      if (this.owningOrganizationIds == null) {
        this.owningOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceDomainsRequest#getOwningOrganizationIds() owningOrganizationIds} list.
     * @param elements An iterable of owningOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.owningOrganizationIds = null;
        return this;
      }
      this.owningOrganizationIds = new ArrayList<String>();
      return addAllOwningOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceDomainsRequest#getOwningOrganizationIds() owningOrganizationIds} list.
     * @param elements An iterable of owningOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOwningOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "owningOrganizationIds element");
      if (this.owningOrganizationIds == null) {
        this.owningOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceDomainsRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link ListSpaceDomainsRequest ListSpaceDomainsRequest}.
     * @return An immutable instance of ListSpaceDomainsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSpaceDomainsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListSpaceDomainsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build ListSpaceDomainsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
