package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Create User Provided Service Instance
 */
@Generated(from = "_CreateUserProvidedServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateUserProvidedServiceInstanceRequest
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._CreateUserProvidedServiceInstanceRequest {
  private final @Nullable Map<String, Object> credentials;
  private final String name;
  private final @Nullable String routeServiceUrl;
  private final String spaceId;
  private final @Nullable String syslogDrainUrl;
  private final @Nullable List<String> tags;

  private CreateUserProvidedServiceInstanceRequest(CreateUserProvidedServiceInstanceRequest.Builder builder) {
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.name = builder.name;
    this.routeServiceUrl = builder.routeServiceUrl;
    this.spaceId = builder.spaceId;
    this.syslogDrainUrl = builder.syslogDrainUrl;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
  }

  /**
   * Key/value pairs to store credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * URL to which requests for bound routes will be forwarded
   */
  @JsonProperty("route_service_url")
  @Override
  public @Nullable String getRouteServiceUrl() {
    return routeServiceUrl;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The url for the syslog_drain to direct to
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * The tags
   */
  @JsonProperty("tags")
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * This instance is equal to all instances of {@code CreateUserProvidedServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateUserProvidedServiceInstanceRequest
        && equalTo((CreateUserProvidedServiceInstanceRequest) another);
  }

  private boolean equalTo(CreateUserProvidedServiceInstanceRequest another) {
    return Objects.equals(credentials, another.credentials)
        && name.equals(another.name)
        && Objects.equals(routeServiceUrl, another.routeServiceUrl)
        && spaceId.equals(another.spaceId)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code name}, {@code routeServiceUrl}, {@code spaceId}, {@code syslogDrainUrl}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(credentials);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(routeServiceUrl);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + Objects.hashCode(syslogDrainUrl);
    h += (h << 5) + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateUserProvidedServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateUserProvidedServiceInstanceRequest{"
        + "credentials=" + credentials
        + ", name=" + name
        + ", routeServiceUrl=" + routeServiceUrl
        + ", spaceId=" + spaceId
        + ", syslogDrainUrl=" + syslogDrainUrl
        + ", tags=" + tags
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateUserProvidedServiceInstanceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.userprovidedserviceinstances._CreateUserProvidedServiceInstanceRequest {
    Map<String, Object> credentials = null;
    String name;
    String routeServiceUrl;
    String spaceId;
    String syslogDrainUrl;
    List<String> tags = null;
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("route_service_url")
    public void setRouteServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @JsonProperty("tags")
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteServiceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateUserProvidedServiceInstanceRequest fromJson(Json json) {
    CreateUserProvidedServiceInstanceRequest.Builder builder = CreateUserProvidedServiceInstanceRequest.builder();
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.routeServiceUrl != null) {
      builder.routeServiceUrl(json.routeServiceUrl);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateUserProvidedServiceInstanceRequest CreateUserProvidedServiceInstanceRequest}.
   * <pre>
   * CreateUserProvidedServiceInstanceRequest.builder()
   *    .credentials(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link CreateUserProvidedServiceInstanceRequest#getCredentials() credentials}
   *    .name(String) // required {@link CreateUserProvidedServiceInstanceRequest#getName() name}
   *    .routeServiceUrl(String | null) // nullable {@link CreateUserProvidedServiceInstanceRequest#getRouteServiceUrl() routeServiceUrl}
   *    .spaceId(String) // required {@link CreateUserProvidedServiceInstanceRequest#getSpaceId() spaceId}
   *    .syslogDrainUrl(String | null) // nullable {@link CreateUserProvidedServiceInstanceRequest#getSyslogDrainUrl() syslogDrainUrl}
   *    .tags(List&amp;lt;String&amp;gt; | null) // nullable {@link CreateUserProvidedServiceInstanceRequest#getTags() tags}
   *    .build();
   * </pre>
   * @return A new CreateUserProvidedServiceInstanceRequest builder
   */
  public static CreateUserProvidedServiceInstanceRequest.Builder builder() {
    return new CreateUserProvidedServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateUserProvidedServiceInstanceRequest CreateUserProvidedServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateUserProvidedServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private Map<String, Object> credentials = null;
    private String name;
    private String routeServiceUrl;
    private String spaceId;
    private String syslogDrainUrl;
    private List<String> tags = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateUserProvidedServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateUserProvidedServiceInstanceRequest instance) {
      return from((_CreateUserProvidedServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateUserProvidedServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateUserProvidedServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> credentialsValue = instance.getCredentials();
      if (credentialsValue != null) {
        putAllCredentials(credentialsValue);
      }
      name(instance.getName());
      String routeServiceUrlValue = instance.getRouteServiceUrl();
      if (routeServiceUrlValue != null) {
        routeServiceUrl(routeServiceUrlValue);
      }
      spaceId(instance.getSpaceId());
      String syslogDrainUrlValue = instance.getSyslogDrainUrl();
      if (syslogDrainUrlValue != null) {
        syslogDrainUrl(syslogDrainUrlValue);
      }
      List<String> tagsValue = instance.getTags();
      if (tagsValue != null) {
        addAllTags(tagsValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link CreateUserProvidedServiceInstanceRequest#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CreateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credentials(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserProvidedServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserProvidedServiceInstanceRequest#getRouteServiceUrl() routeServiceUrl} attribute.
     * @param routeServiceUrl The value for routeServiceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserProvidedServiceInstanceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserProvidedServiceInstanceRequest#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Adds one element to {@link CreateUserProvidedServiceInstanceRequest#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateUserProvidedServiceInstanceRequest#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateUserProvidedServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link CreateUserProvidedServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Builds a new {@link CreateUserProvidedServiceInstanceRequest CreateUserProvidedServiceInstanceRequest}.
     * @return An immutable instance of CreateUserProvidedServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateUserProvidedServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateUserProvidedServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build CreateUserProvidedServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
