package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Managed Space from the User operation
 */
@Generated(from = "_RemoveUserManagedSpaceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveUserManagedSpaceRequest
    extends org.cloudfoundry.client.v2.users._RemoveUserManagedSpaceRequest {
  private final String managedSpaceId;
  private final String userId;

  private RemoveUserManagedSpaceRequest(RemoveUserManagedSpaceRequest.Builder builder) {
    this.managedSpaceId = builder.managedSpaceId;
    this.userId = builder.userId;
  }

  /**
   * The id of the managed space
   */
  @Override
  public String getManagedSpaceId() {
    return managedSpaceId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveUserManagedSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveUserManagedSpaceRequest
        && equalTo((RemoveUserManagedSpaceRequest) another);
  }

  private boolean equalTo(RemoveUserManagedSpaceRequest another) {
    return managedSpaceId.equals(another.managedSpaceId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code managedSpaceId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + managedSpaceId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveUserManagedSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveUserManagedSpaceRequest{"
        + "managedSpaceId=" + managedSpaceId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveUserManagedSpaceRequest RemoveUserManagedSpaceRequest}.
   * <pre>
   * RemoveUserManagedSpaceRequest.builder()
   *    .managedSpaceId(String) // required {@link RemoveUserManagedSpaceRequest#getManagedSpaceId() managedSpaceId}
   *    .userId(String) // required {@link RemoveUserManagedSpaceRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new RemoveUserManagedSpaceRequest builder
   */
  public static RemoveUserManagedSpaceRequest.Builder builder() {
    return new RemoveUserManagedSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveUserManagedSpaceRequest RemoveUserManagedSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveUserManagedSpaceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MANAGED_SPACE_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String managedSpaceId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveUserManagedSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveUserManagedSpaceRequest instance) {
      return from((_RemoveUserManagedSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveUserManagedSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveUserManagedSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      managedSpaceId(instance.getManagedSpaceId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserManagedSpaceRequest#getManagedSpaceId() managedSpaceId} attribute.
     * @param managedSpaceId The value for managedSpaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpaceId(String managedSpaceId) {
      this.managedSpaceId = Objects.requireNonNull(managedSpaceId, "managedSpaceId");
      initBits &= ~INIT_BIT_MANAGED_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserManagedSpaceRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveUserManagedSpaceRequest RemoveUserManagedSpaceRequest}.
     * @return An immutable instance of RemoveUserManagedSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveUserManagedSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveUserManagedSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANAGED_SPACE_ID) != 0) attributes.add("managedSpaceId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build RemoveUserManagedSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
