package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Represents a relationship to another entity
 */
@Generated(from = "_Relationship", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Relationship extends org.cloudfoundry.client.v3._Relationship {
  private final String id;

  private Relationship(Relationship.Builder builder) {
    this.id = builder.id;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * This instance is equal to all instances of {@code Relationship} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Relationship
        && equalTo((Relationship) another);
  }

  private boolean equalTo(Relationship another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Relationship} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Relationship{"
        + "id=" + id
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Relationship", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Relationship {
    String id;
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Relationship fromJson(Json json) {
    Relationship.Builder builder = Relationship.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Relationship Relationship}.
   * <pre>
   * Relationship.builder()
   *    .id(String) // required {@link Relationship#getId() id}
   *    .build();
   * </pre>
   * @return A new Relationship builder
   */
  public static Relationship.Builder builder() {
    return new Relationship.Builder();
  }

  /**
   * Builds instances of type {@link Relationship Relationship}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Relationship", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Relationship} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Relationship instance) {
      return from((_Relationship) instance);
    }

    /**
     * Copy abstract value type {@code _Relationship} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Relationship instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      return this;
    }

    /**
     * Initializes the value for the {@link Relationship#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link Relationship Relationship}.
     * @return An immutable instance of Relationship
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Relationship build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Relationship(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Relationship, some of required attributes are not set " + attributes;
    }
  }
}
