package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Represents a to-one relationship to another entity
 */
@Generated(from = "_ToOneRelationship", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ToOneRelationship extends org.cloudfoundry.client.v3._ToOneRelationship {
  private final @Nullable Relationship data;

  private ToOneRelationship(ToOneRelationship.Builder builder) {
    this.data = builder.data;
  }

  /**
   * The relationship data
   */
  @JsonProperty("data")
  @Override
  public @Nullable Relationship getData() {
    return data;
  }

  /**
   * This instance is equal to all instances of {@code ToOneRelationship} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ToOneRelationship
        && equalTo((ToOneRelationship) another);
  }

  private boolean equalTo(ToOneRelationship another) {
    return Objects.equals(data, another.data);
  }

  /**
   * Computes a hash code from attributes: {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    return h;
  }

  /**
   * Prints the immutable value {@code ToOneRelationship} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ToOneRelationship{"
        + "data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ToOneRelationship", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._ToOneRelationship {
    Relationship data;
    @JsonProperty("data")
    public void setData(@Nullable Relationship data) {
      this.data = data;
    }
    @Override
    public Relationship getData() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ToOneRelationship fromJson(Json json) {
    ToOneRelationship.Builder builder = ToOneRelationship.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ToOneRelationship ToOneRelationship}.
   * <pre>
   * ToOneRelationship.builder()
   *    .data(org.cloudfoundry.client.v3.Relationship | null) // nullable {@link ToOneRelationship#getData() data}
   *    .build();
   * </pre>
   * @return A new ToOneRelationship builder
   */
  public static ToOneRelationship.Builder builder() {
    return new ToOneRelationship.Builder();
  }

  /**
   * Builds instances of type {@link ToOneRelationship ToOneRelationship}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ToOneRelationship", generator = "Immutables")
  public static final class Builder {
    private Relationship data;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ToOneRelationship} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ToOneRelationship instance) {
      return from((_ToOneRelationship) instance);
    }

    /**
     * Copy abstract value type {@code _ToOneRelationship} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ToOneRelationship instance) {
      Objects.requireNonNull(instance, "instance");
      Relationship dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ToOneRelationship#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Relationship data) {
      this.data = data;
      return this;
    }

    /**
     * Builds a new {@link ToOneRelationship ToOneRelationship}.
     * @return An immutable instance of ToOneRelationship
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ToOneRelationship build() {
      return new ToOneRelationship(this);
    }
  }
}
