package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.packages.PackageState;
import org.immutables.value.Generated;

/**
 * The request payload for the List Application Tasks operation
 */
@Generated(from = "_ListApplicationTasksRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListApplicationTasksRequest
    extends org.cloudfoundry.client.v3.applications._ListApplicationTasksRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final String applicationId;
  private final List<String> names;
  private final List<String> sequenceIds;
  private final List<PackageState> states;
  private final List<String> taskIds;

  private ListApplicationTasksRequest(ListApplicationTasksRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationId = builder.applicationId;
    this.names = createUnmodifiableList(true, builder.names);
    this.sequenceIds = createUnmodifiableList(true, builder.sequenceIds);
    this.states = createUnmodifiableList(true, builder.states);
    this.taskIds = createUnmodifiableList(true, builder.taskIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * List of names to filter by
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * List of sequence ids to filter by
   */
  @Override
  public List<String> getSequenceIds() {
    return sequenceIds;
  }

  /**
   * List of states to filter by
   */
  @Override
  public List<PackageState> getStates() {
    return states;
  }

  /**
   * List of task ids to filter by
   */
  @Override
  public List<String> getTaskIds() {
    return taskIds;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationTasksRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationTasksRequest
        && equalTo((ListApplicationTasksRequest) another);
  }

  private boolean equalTo(ListApplicationTasksRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationId.equals(another.applicationId)
        && names.equals(another.names)
        && sequenceIds.equals(another.sequenceIds)
        && states.equals(another.states)
        && taskIds.equals(another.taskIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationId}, {@code names}, {@code sequenceIds}, {@code states}, {@code taskIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + sequenceIds.hashCode();
    h += (h << 5) + states.hashCode();
    h += (h << 5) + taskIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationTasksRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationTasksRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationId=" + applicationId
        + ", names=" + names
        + ", sequenceIds=" + sequenceIds
        + ", states=" + states
        + ", taskIds=" + taskIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationTasksRequest ListApplicationTasksRequest}.
   * <pre>
   * ListApplicationTasksRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListApplicationTasksRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListApplicationTasksRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListApplicationTasksRequest#getPerPage() perPage}
   *    .applicationId(String) // required {@link ListApplicationTasksRequest#getApplicationId() applicationId}
   *    .name|addAllNames(String) // {@link ListApplicationTasksRequest#getNames() names} elements
   *    .sequenceId|addAllSequenceIds(String) // {@link ListApplicationTasksRequest#getSequenceIds() sequenceIds} elements
   *    .state|addAllStates(org.cloudfoundry.client.v3.packages.PackageState) // {@link ListApplicationTasksRequest#getStates() states} elements
   *    .taskId|addAllTaskIds(String) // {@link ListApplicationTasksRequest#getTaskIds() taskIds} elements
   *    .build();
   * </pre>
   * @return A new ListApplicationTasksRequest builder
   */
  public static ListApplicationTasksRequest.Builder builder() {
    return new ListApplicationTasksRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationTasksRequest ListApplicationTasksRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListApplicationTasksRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String orderBy;
    private Integer page;
    private Integer perPage;
    private String applicationId;
    private List<String> names = new ArrayList<String>();
    private List<String> sequenceIds = new ArrayList<String>();
    private List<PackageState> states = new ArrayList<PackageState>();
    private List<String> taskIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationTasksRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationTasksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationTasksRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListApplicationTasksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.applications._ListApplicationTasksRequest) {
        org.cloudfoundry.client.v3.applications._ListApplicationTasksRequest instance = (org.cloudfoundry.client.v3.applications._ListApplicationTasksRequest) object;
        addAllNames(instance.getNames());
        applicationId(instance.getApplicationId());
        addAllTaskIds(instance.getTaskIds());
        addAllSequenceIds(instance.getSequenceIds());
        addAllStates(instance.getStates());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListApplicationTasksRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationTasksRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationTasksRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationTasksRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationTasksRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationTasksRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationTasksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListApplicationTasksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationTasksRequest#getSequenceIds() sequenceIds} list.
     * @param element A sequenceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sequenceId(String element) {
      this.sequenceIds.add(Objects.requireNonNull(element, "sequenceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationTasksRequest#getSequenceIds() sequenceIds} list.
     * @param elements An array of sequenceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sequenceIds(String... elements) {
      for (String element : elements) {
        this.sequenceIds.add(Objects.requireNonNull(element, "sequenceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationTasksRequest#getSequenceIds() sequenceIds} list.
     * @param elements An iterable of sequenceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sequenceIds(Iterable<String> elements) {
      this.sequenceIds.clear();
      return addAllSequenceIds(elements);
    }

    /**
     * Adds elements to {@link ListApplicationTasksRequest#getSequenceIds() sequenceIds} list.
     * @param elements An iterable of sequenceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSequenceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.sequenceIds.add(Objects.requireNonNull(element, "sequenceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationTasksRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(PackageState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationTasksRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(PackageState... elements) {
      for (PackageState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationTasksRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends PackageState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link ListApplicationTasksRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends PackageState> elements) {
      for (PackageState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationTasksRequest#getTaskIds() taskIds} list.
     * @param element A taskIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskId(String element) {
      this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationTasksRequest#getTaskIds() taskIds} list.
     * @param elements An array of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskIds(String... elements) {
      for (String element : elements) {
        this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationTasksRequest#getTaskIds() taskIds} list.
     * @param elements An iterable of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskIds(Iterable<String> elements) {
      this.taskIds.clear();
      return addAllTaskIds(elements);
    }

    /**
     * Adds elements to {@link ListApplicationTasksRequest#getTaskIds() taskIds} list.
     * @param elements An iterable of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTaskIds(Iterable<String> elements) {
      for (String element : elements) {
        this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListApplicationTasksRequest ListApplicationTasksRequest}.
     * @return An immutable instance of ListApplicationTasksRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationTasksRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListApplicationTasksRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ListApplicationTasksRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
