package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response payload for the Update Application Feature operation
 */
@Generated(from = "_UpdateApplicationFeatureResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateApplicationFeatureResponse
    extends org.cloudfoundry.client.v3.applications._UpdateApplicationFeatureResponse {
  private final @Nullable String description;
  private final @Nullable Boolean enabled;
  private final @Nullable String name;

  private UpdateApplicationFeatureResponse(UpdateApplicationFeatureResponse.Builder builder) {
    this.description = builder.description;
    this.enabled = builder.enabled;
    this.name = builder.name;
  }

  /**
   * The description of the application feature
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * Denotes whether or not the application feature is enabled
   */
  @JsonProperty("enabled")
  @Override
  public @Nullable Boolean getEnabled() {
    return enabled;
  }

  /**
   * The name of the application feature
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code UpdateApplicationFeatureResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateApplicationFeatureResponse
        && equalTo((UpdateApplicationFeatureResponse) another);
  }

  private boolean equalTo(UpdateApplicationFeatureResponse another) {
    return Objects.equals(description, another.description)
        && Objects.equals(enabled, another.enabled)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code enabled}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateApplicationFeatureResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateApplicationFeatureResponse{"
        + "description=" + description
        + ", enabled=" + enabled
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateApplicationFeatureResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._UpdateApplicationFeatureResponse {
    String description;
    Boolean enabled;
    String name;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("enabled")
    public void setEnabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateApplicationFeatureResponse fromJson(Json json) {
    UpdateApplicationFeatureResponse.Builder builder = UpdateApplicationFeatureResponse.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateApplicationFeatureResponse UpdateApplicationFeatureResponse}.
   * <pre>
   * UpdateApplicationFeatureResponse.builder()
   *    .description(String | null) // nullable {@link UpdateApplicationFeatureResponse#getDescription() description}
   *    .enabled(Boolean | null) // nullable {@link UpdateApplicationFeatureResponse#getEnabled() enabled}
   *    .name(String | null) // nullable {@link UpdateApplicationFeatureResponse#getName() name}
   *    .build();
   * </pre>
   * @return A new UpdateApplicationFeatureResponse builder
   */
  public static UpdateApplicationFeatureResponse.Builder builder() {
    return new UpdateApplicationFeatureResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateApplicationFeatureResponse UpdateApplicationFeatureResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateApplicationFeatureResponse", generator = "Immutables")
  public static final class Builder {
    private String description;
    private Boolean enabled;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.applications.ApplicationFeature} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationFeature instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateApplicationFeatureResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateApplicationFeatureResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateApplicationFeatureResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateApplicationFeatureResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ApplicationFeature) {
        ApplicationFeature instance = (ApplicationFeature) object;
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        Boolean enabledValue = instance.getEnabled();
        if (enabledValue != null) {
          enabled(enabledValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link UpdateApplicationFeatureResponse#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationFeatureResponse#getEnabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("enabled")
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationFeatureResponse#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link UpdateApplicationFeatureResponse UpdateApplicationFeatureResponse}.
     * @return An immutable instance of UpdateApplicationFeatureResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateApplicationFeatureResponse build() {
      return new UpdateApplicationFeatureResponse(this);
    }
  }
}
