package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Create Deployment request
 */
@Generated(from = "_DeploymentRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeploymentRelationships
    extends org.cloudfoundry.client.v3.deployments._DeploymentRelationships {
  private final ToOneRelationship app;

  private DeploymentRelationships(DeploymentRelationships.Builder builder) {
    this.app = builder.app;
  }

  /**
   * The app relationship
   */
  @JsonProperty("app")
  @Override
  public ToOneRelationship getApp() {
    return app;
  }

  /**
   * This instance is equal to all instances of {@code DeploymentRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeploymentRelationships
        && equalTo((DeploymentRelationships) another);
  }

  private boolean equalTo(DeploymentRelationships another) {
    return app.equals(another.app);
  }

  /**
   * Computes a hash code from attributes: {@code app}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + app.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeploymentRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeploymentRelationships{"
        + "app=" + app
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_DeploymentRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.deployments._DeploymentRelationships {
    ToOneRelationship app;
    @JsonProperty("app")
    public void setApp(ToOneRelationship app) {
      this.app = app;
    }
    @Override
    public ToOneRelationship getApp() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DeploymentRelationships fromJson(Json json) {
    DeploymentRelationships.Builder builder = DeploymentRelationships.builder();
    if (json.app != null) {
      builder.app(json.app);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DeploymentRelationships DeploymentRelationships}.
   * <pre>
   * DeploymentRelationships.builder()
   *    .app(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link DeploymentRelationships#getApp() app}
   *    .build();
   * </pre>
   * @return A new DeploymentRelationships builder
   */
  public static DeploymentRelationships.Builder builder() {
    return new DeploymentRelationships.Builder();
  }

  /**
   * Builds instances of type {@link DeploymentRelationships DeploymentRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeploymentRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APP = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship app;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeploymentRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeploymentRelationships instance) {
      return from((_DeploymentRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _DeploymentRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeploymentRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      app(instance.getApp());
      return this;
    }

    /**
     * Initializes the value for the {@link DeploymentRelationships#getApp() app} attribute.
     * @param app The value for app 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder app(ToOneRelationship app) {
      this.app = Objects.requireNonNull(app, "app");
      initBits &= ~INIT_BIT_APP;
      return this;
    }

    /**
     * Builds a new {@link DeploymentRelationships DeploymentRelationships}.
     * @return An immutable instance of DeploymentRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeploymentRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeploymentRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APP) != 0) attributes.add("app");
      return "Cannot build DeploymentRelationships, some of required attributes are not set " + attributes;
    }
  }
}
