package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Check Reserved Routes operation
 */
@Generated(from = "_CheckReservedRoutesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CheckReservedRoutesRequest
    extends org.cloudfoundry.client.v3.domains._CheckReservedRoutesRequest {
  private final String domainId;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;

  private CheckReservedRoutesRequest(CheckReservedRoutesRequest.Builder builder) {
    this.domainId = builder.domainId;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
  }

  /**
   * The domain id
   */
  @JsonProperty("domainId")
  @JsonIgnore
  @Override
  public String getDomainId() {
    return domainId;
  }

  /**
   * The hostname filter
   */
  @JsonIgnore
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path filter
   */
  @JsonIgnore
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port filter
   */
  @JsonIgnore
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * This instance is equal to all instances of {@code CheckReservedRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CheckReservedRoutesRequest
        && equalTo((CheckReservedRoutesRequest) another);
  }

  private boolean equalTo(CheckReservedRoutesRequest another) {
    return domainId.equals(another.domainId)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}, {@code host}, {@code path}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domainId.hashCode();
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckReservedRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckReservedRoutesRequest{"
        + "domainId=" + domainId
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CheckReservedRoutesRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._CheckReservedRoutesRequest {
    String domainId;
    String host;
    String path;
    Integer port;
    @JsonProperty("domainId")
    @JsonIgnore
    public void setDomainId(String domainId) {
      this.domainId = domainId;
    }
    @JsonIgnore
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonIgnore
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonIgnore
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @Override
    public String getDomainId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CheckReservedRoutesRequest fromJson(Json json) {
    CheckReservedRoutesRequest.Builder builder = CheckReservedRoutesRequest.builder();
    if (json.domainId != null) {
      builder.domainId(json.domainId);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CheckReservedRoutesRequest CheckReservedRoutesRequest}.
   * <pre>
   * CheckReservedRoutesRequest.builder()
   *    .domainId(String) // required {@link CheckReservedRoutesRequest#getDomainId() domainId}
   *    .host(String | null) // nullable {@link CheckReservedRoutesRequest#getHost() host}
   *    .path(String | null) // nullable {@link CheckReservedRoutesRequest#getPath() path}
   *    .port(Integer | null) // nullable {@link CheckReservedRoutesRequest#getPort() port}
   *    .build();
   * </pre>
   * @return A new CheckReservedRoutesRequest builder
   */
  public static CheckReservedRoutesRequest.Builder builder() {
    return new CheckReservedRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link CheckReservedRoutesRequest CheckReservedRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CheckReservedRoutesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private String domainId;
    private String host;
    private String path;
    private Integer port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckReservedRoutesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckReservedRoutesRequest instance) {
      return from((_CheckReservedRoutesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CheckReservedRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CheckReservedRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domainId(instance.getDomainId());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CheckReservedRoutesRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String domainId) {
      this.domainId = Objects.requireNonNull(domainId, "domainId");
      initBits &= ~INIT_BIT_DOMAIN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckReservedRoutesRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckReservedRoutesRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckReservedRoutesRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Builds a new {@link CheckReservedRoutesRequest CheckReservedRoutesRequest}.
     * @return An immutable instance of CheckReservedRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CheckReservedRoutesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CheckReservedRoutesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_ID) != 0) attributes.add("domainId");
      return "Cannot build CheckReservedRoutesRequest, some of required attributes are not set " + attributes;
    }
  }
}
