package org.cloudfoundry.client.v3.droplets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Droplet operation
 */
@Generated(from = "_DeleteDropletRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteDropletRequest extends org.cloudfoundry.client.v3.droplets._DeleteDropletRequest {
  private final String dropletId;

  private DeleteDropletRequest(DeleteDropletRequest.Builder builder) {
    this.dropletId = builder.dropletId;
  }

  /**
   * The droplet id
   */
  @Override
  public String getDropletId() {
    return dropletId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteDropletRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteDropletRequest
        && equalTo((DeleteDropletRequest) another);
  }

  private boolean equalTo(DeleteDropletRequest another) {
    return dropletId.equals(another.dropletId);
  }

  /**
   * Computes a hash code from attributes: {@code dropletId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + dropletId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteDropletRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteDropletRequest{"
        + "dropletId=" + dropletId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteDropletRequest DeleteDropletRequest}.
   * <pre>
   * DeleteDropletRequest.builder()
   *    .dropletId(String) // required {@link DeleteDropletRequest#getDropletId() dropletId}
   *    .build();
   * </pre>
   * @return A new DeleteDropletRequest builder
   */
  public static DeleteDropletRequest.Builder builder() {
    return new DeleteDropletRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteDropletRequest DeleteDropletRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteDropletRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DROPLET_ID = 0x1L;
    private long initBits = 0x1L;

    private String dropletId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteDropletRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteDropletRequest instance) {
      return from((_DeleteDropletRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteDropletRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteDropletRequest instance) {
      Objects.requireNonNull(instance, "instance");
      dropletId(instance.getDropletId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteDropletRequest#getDropletId() dropletId} attribute.
     * @param dropletId The value for dropletId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletId(String dropletId) {
      this.dropletId = Objects.requireNonNull(dropletId, "dropletId");
      initBits &= ~INIT_BIT_DROPLET_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteDropletRequest DeleteDropletRequest}.
     * @return An immutable instance of DeleteDropletRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteDropletRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteDropletRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DROPLET_ID) != 0) attributes.add("dropletId");
      return "Cannot build DeleteDropletRequest, some of required attributes are not set " + attributes;
    }
  }
}
