package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Process operation
 */
@Generated(from = "_GetProcessRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetProcessRequest extends org.cloudfoundry.client.v3.processes._GetProcessRequest {
  private final String processId;

  private GetProcessRequest(GetProcessRequest.Builder builder) {
    this.processId = builder.processId;
  }

  /**
   * The process id
   */
  @Override
  public String getProcessId() {
    return processId;
  }

  /**
   * This instance is equal to all instances of {@code GetProcessRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetProcessRequest
        && equalTo((GetProcessRequest) another);
  }

  private boolean equalTo(GetProcessRequest another) {
    return processId.equals(another.processId);
  }

  /**
   * Computes a hash code from attributes: {@code processId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + processId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetProcessRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetProcessRequest{"
        + "processId=" + processId
        + "}";
  }

  /**
   * Creates a builder for {@link GetProcessRequest GetProcessRequest}.
   * <pre>
   * GetProcessRequest.builder()
   *    .processId(String) // required {@link GetProcessRequest#getProcessId() processId}
   *    .build();
   * </pre>
   * @return A new GetProcessRequest builder
   */
  public static GetProcessRequest.Builder builder() {
    return new GetProcessRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetProcessRequest GetProcessRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetProcessRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PROCESS_ID = 0x1L;
    private long initBits = 0x1L;

    private String processId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetProcessRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetProcessRequest instance) {
      return from((_GetProcessRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetProcessRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetProcessRequest instance) {
      Objects.requireNonNull(instance, "instance");
      processId(instance.getProcessId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetProcessRequest#getProcessId() processId} attribute.
     * @param processId The value for processId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String processId) {
      this.processId = Objects.requireNonNull(processId, "processId");
      initBits &= ~INIT_BIT_PROCESS_ID;
      return this;
    }

    /**
     * Builds a new {@link GetProcessRequest GetProcessRequest}.
     * @return An immutable instance of GetProcessRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetProcessRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetProcessRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROCESS_ID) != 0) attributes.add("processId");
      return "Cannot build GetProcessRequest, some of required attributes are not set " + attributes;
    }
  }
}
