package org.cloudfoundry.client.v3.serviceInstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The request payload for the Share Service Instance operation.
 */
@Generated(from = "_ShareServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ShareServiceInstanceRequest
    extends org.cloudfoundry.client.v3.serviceInstances._ShareServiceInstanceRequest {
  private final List<Relationship> data;
  private final String serviceInstanceId;

  private ShareServiceInstanceRequest(ShareServiceInstanceRequest.Builder builder) {
    this.data = createUnmodifiableList(true, builder.data);
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The spaces the service instance is shared to
   */
  @JsonProperty("data")
  @Override
  public List<Relationship> getData() {
    return data;
  }

  /**
   * The service instance id
   */
  @JsonProperty("serviceInstanceId")
  @JsonIgnore
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code ShareServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ShareServiceInstanceRequest
        && equalTo((ShareServiceInstanceRequest) another);
  }

  private boolean equalTo(ShareServiceInstanceRequest another) {
    return data.equals(another.data)
        && serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + data.hashCode();
    h += (h << 5) + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ShareServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ShareServiceInstanceRequest{"
        + "data=" + data
        + ", serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ShareServiceInstanceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceInstances._ShareServiceInstanceRequest {
    List<Relationship> data = Collections.emptyList();
    String serviceInstanceId;
    @JsonProperty("data")
    public void setData(List<Relationship> data) {
      this.data = data;
    }
    @JsonProperty("serviceInstanceId")
    @JsonIgnore
    public void setServiceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
    }
    @Override
    public List<Relationship> getData() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ShareServiceInstanceRequest fromJson(Json json) {
    ShareServiceInstanceRequest.Builder builder = ShareServiceInstanceRequest.builder();
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    if (json.serviceInstanceId != null) {
      builder.serviceInstanceId(json.serviceInstanceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ShareServiceInstanceRequest ShareServiceInstanceRequest}.
   * <pre>
   * ShareServiceInstanceRequest.builder()
   *    .data|addAllData(org.cloudfoundry.client.v3.Relationship) // {@link ShareServiceInstanceRequest#getData() data} elements
   *    .serviceInstanceId(String) // required {@link ShareServiceInstanceRequest#getServiceInstanceId() serviceInstanceId}
   *    .build();
   * </pre>
   * @return A new ShareServiceInstanceRequest builder
   */
  public static ShareServiceInstanceRequest.Builder builder() {
    return new ShareServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link ShareServiceInstanceRequest ShareServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ShareServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private List<Relationship> data = new ArrayList<Relationship>();
    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ShareServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ShareServiceInstanceRequest instance) {
      return from((_ShareServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ShareServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ShareServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllData(instance.getData());
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Adds one element to {@link ShareServiceInstanceRequest#getData() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link ShareServiceInstanceRequest#getData() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship... elements) {
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ShareServiceInstanceRequest#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Iterable<? extends Relationship> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link ShareServiceInstanceRequest#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends Relationship> elements) {
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ShareServiceInstanceRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link ShareServiceInstanceRequest ShareServiceInstanceRequest}.
     * @return An immutable instance of ShareServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ShareServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ShareServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build ShareServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
