package org.cloudfoundry.client.v3.serviceInstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Application operation
 */
@Generated(from = "_UpdateServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceInstanceRequest
    extends org.cloudfoundry.client.v3.serviceInstances._UpdateServiceInstanceRequest {
  private final Metadata metadata;
  private final String serviceInstanceId;

  private UpdateServiceInstanceRequest(UpdateServiceInstanceRequest.Builder builder) {
    this.metadata = builder.metadata;
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The service instance id
   */
  @JsonProperty("serviceInstanceId")
  @JsonIgnore
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceInstanceRequest
        && equalTo((UpdateServiceInstanceRequest) another);
  }

  private boolean equalTo(UpdateServiceInstanceRequest another) {
    return metadata.equals(another.metadata)
        && serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + metadata.hashCode();
    h += (h << 5) + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceInstanceRequest{"
        + "metadata=" + metadata
        + ", serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServiceInstanceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceInstances._UpdateServiceInstanceRequest {
    Metadata metadata;
    String serviceInstanceId;
    @JsonProperty("metadata")
    public void setMetadata(Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("serviceInstanceId")
    @JsonIgnore
    public void setServiceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
    }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServiceInstanceRequest fromJson(Json json) {
    UpdateServiceInstanceRequest.Builder builder = UpdateServiceInstanceRequest.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.serviceInstanceId != null) {
      builder.serviceInstanceId(json.serviceInstanceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
   * <pre>
   * UpdateServiceInstanceRequest.builder()
   *    .metadata(org.cloudfoundry.client.v3.Metadata) // required {@link UpdateServiceInstanceRequest#getMetadata() metadata}
   *    .serviceInstanceId(String) // required {@link UpdateServiceInstanceRequest#getServiceInstanceId() serviceInstanceId}
   *    .build();
   * </pre>
   * @return A new UpdateServiceInstanceRequest builder
   */
  public static UpdateServiceInstanceRequest.Builder builder() {
    return new UpdateServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_METADATA = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x2L;
    private long initBits = 0x3L;

    private Metadata metadata;
    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceInstanceRequest instance) {
      return from((_UpdateServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      metadata(instance.getMetadata());
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(Metadata metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
     * @return An immutable instance of UpdateServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build UpdateServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
