package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Service Binding operation.
 */
@Generated(from = "_CreateServiceBindingRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateServiceBindingRequest
    extends org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingRequest {
  private final @Nullable CreateServiceBindingData data;
  private final ServiceBindingRelationships relationships;
  private final ServiceBindingType type;

  private CreateServiceBindingRequest(CreateServiceBindingRequest.Builder builder) {
    this.data = builder.data;
    this.relationships = builder.relationships;
    this.type = builder.type;
  }

  /**
   * The data
   */
  @JsonProperty("data")
  @Override
  public @Nullable CreateServiceBindingData getData() {
    return data;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public ServiceBindingRelationships getRelationships() {
    return relationships;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public ServiceBindingType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceBindingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceBindingRequest
        && equalTo((CreateServiceBindingRequest) another);
  }

  private boolean equalTo(CreateServiceBindingRequest another) {
    return Objects.equals(data, another.data)
        && relationships.equals(another.relationships)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code relationships}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceBindingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceBindingRequest{"
        + "data=" + data
        + ", relationships=" + relationships
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateServiceBindingRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingRequest {
    CreateServiceBindingData data;
    ServiceBindingRelationships relationships;
    ServiceBindingType type;
    @JsonProperty("data")
    public void setData(@Nullable CreateServiceBindingData data) {
      this.data = data;
    }
    @JsonProperty("relationships")
    public void setRelationships(ServiceBindingRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("type")
    public void setType(ServiceBindingType type) {
      this.type = type;
    }
    @Override
    public CreateServiceBindingData getData() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceBindingRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceBindingType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateServiceBindingRequest fromJson(Json json) {
    CreateServiceBindingRequest.Builder builder = CreateServiceBindingRequest.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateServiceBindingRequest CreateServiceBindingRequest}.
   * <pre>
   * CreateServiceBindingRequest.builder()
   *    .data(org.cloudfoundry.client.v3.servicebindings.CreateServiceBindingData | null) // nullable {@link CreateServiceBindingRequest#getData() data}
   *    .relationships(org.cloudfoundry.client.v3.servicebindings.ServiceBindingRelationships) // required {@link CreateServiceBindingRequest#getRelationships() relationships}
   *    .type(org.cloudfoundry.client.v3.servicebindings.ServiceBindingType) // required {@link CreateServiceBindingRequest#getType() type}
   *    .build();
   * </pre>
   * @return A new CreateServiceBindingRequest builder
   */
  public static CreateServiceBindingRequest.Builder builder() {
    return new CreateServiceBindingRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceBindingRequest CreateServiceBindingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateServiceBindingRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_RELATIONSHIPS = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private CreateServiceBindingData data;
    private ServiceBindingRelationships relationships;
    private ServiceBindingType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceBindingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceBindingRequest instance) {
      return from((_CreateServiceBindingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceBindingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceBindingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      CreateServiceBindingData dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      relationships(instance.getRelationships());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBindingRequest#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(@Nullable CreateServiceBindingData data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBindingRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(ServiceBindingRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBindingRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(ServiceBindingType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceBindingRequest CreateServiceBindingRequest}.
     * @return An immutable instance of CreateServiceBindingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceBindingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceBindingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CreateServiceBindingRequest, some of required attributes are not set " + attributes;
    }
  }
}
