package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Cost data for a Service Plan
 */
@Generated(from = "_Cost", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Cost extends org.cloudfoundry.client.v3.serviceplans._Cost {
  private final Float amount;
  private final String currency;
  private final String unit;

  private Cost(Cost.Builder builder) {
    this.amount = builder.amount;
    this.currency = builder.currency;
    this.unit = builder.unit;
  }

  /**
   * Pricing amount
   */
  @JsonProperty("amount")
  @Override
  public Float getAmount() {
    return amount;
  }

  /**
   * Currency code for the pricing amount
   */
  @JsonProperty("currency")
  @Override
  public String getCurrency() {
    return currency;
  }

  /**
   * Display name for type of cost, e.g. Monthly, Hourly, Request, GB
   */
  @JsonProperty("unit")
  @Override
  public String getUnit() {
    return unit;
  }

  /**
   * This instance is equal to all instances of {@code Cost} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Cost
        && equalTo((Cost) another);
  }

  private boolean equalTo(Cost another) {
    return amount.equals(another.amount)
        && currency.equals(another.currency)
        && unit.equals(another.unit);
  }

  /**
   * Computes a hash code from attributes: {@code amount}, {@code currency}, {@code unit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + amount.hashCode();
    h += (h << 5) + currency.hashCode();
    h += (h << 5) + unit.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Cost} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Cost{"
        + "amount=" + amount
        + ", currency=" + currency
        + ", unit=" + unit
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Cost", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceplans._Cost {
    Float amount;
    String currency;
    String unit;
    @JsonProperty("amount")
    public void setAmount(Float amount) {
      this.amount = amount;
    }
    @JsonProperty("currency")
    public void setCurrency(String currency) {
      this.currency = currency;
    }
    @JsonProperty("unit")
    public void setUnit(String unit) {
      this.unit = unit;
    }
    @Override
    public Float getAmount() { throw new UnsupportedOperationException(); }
    @Override
    public String getCurrency() { throw new UnsupportedOperationException(); }
    @Override
    public String getUnit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Cost fromJson(Json json) {
    Cost.Builder builder = Cost.builder();
    if (json.amount != null) {
      builder.amount(json.amount);
    }
    if (json.currency != null) {
      builder.currency(json.currency);
    }
    if (json.unit != null) {
      builder.unit(json.unit);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Cost Cost}.
   * <pre>
   * Cost.builder()
   *    .amount(Float) // required {@link Cost#getAmount() amount}
   *    .currency(String) // required {@link Cost#getCurrency() currency}
   *    .unit(String) // required {@link Cost#getUnit() unit}
   *    .build();
   * </pre>
   * @return A new Cost builder
   */
  public static Cost.Builder builder() {
    return new Cost.Builder();
  }

  /**
   * Builds instances of type {@link Cost Cost}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Cost", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AMOUNT = 0x1L;
    private static final long INIT_BIT_CURRENCY = 0x2L;
    private static final long INIT_BIT_UNIT = 0x4L;
    private long initBits = 0x7L;

    private Float amount;
    private String currency;
    private String unit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Cost} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Cost instance) {
      return from((_Cost) instance);
    }

    /**
     * Copy abstract value type {@code _Cost} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Cost instance) {
      Objects.requireNonNull(instance, "instance");
      amount(instance.getAmount());
      currency(instance.getCurrency());
      unit(instance.getUnit());
      return this;
    }

    /**
     * Initializes the value for the {@link Cost#getAmount() amount} attribute.
     * @param amount The value for amount 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("amount")
    public final Builder amount(Float amount) {
      this.amount = Objects.requireNonNull(amount, "amount");
      initBits &= ~INIT_BIT_AMOUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link Cost#getCurrency() currency} attribute.
     * @param currency The value for currency 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("currency")
    public final Builder currency(String currency) {
      this.currency = Objects.requireNonNull(currency, "currency");
      initBits &= ~INIT_BIT_CURRENCY;
      return this;
    }

    /**
     * Initializes the value for the {@link Cost#getUnit() unit} attribute.
     * @param unit The value for unit 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("unit")
    public final Builder unit(String unit) {
      this.unit = Objects.requireNonNull(unit, "unit");
      initBits &= ~INIT_BIT_UNIT;
      return this;
    }

    /**
     * Builds a new {@link Cost Cost}.
     * @return An immutable instance of Cost
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Cost build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Cost(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AMOUNT) != 0) attributes.add("amount");
      if ((initBits & INIT_BIT_CURRENCY) != 0) attributes.add("currency");
      if ((initBits & INIT_BIT_UNIT) != 0) attributes.add("unit");
      return "Cannot build Cost, some of required attributes are not set " + attributes;
    }
  }
}
