package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Envelope}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Envelope.builder()}.
 */
@Generated(from = "_Envelope", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties("deprecated_tags")
public final class Envelope extends org.cloudfoundry.logcache.v1._Envelope {
  private final @Nullable Counter counter;
  private final @Nullable Event event;
  private final @Nullable Gauge gauge;
  private final @Nullable String instanceId;
  private final @Nullable Log log;
  private final @Nullable String sourceId;
  private final Map<String, String> tags;
  private final @Nullable Timer timer;
  private final @Nullable Long timestamp;

  private Envelope(Envelope.Builder builder) {
    this.counter = builder.counter;
    this.event = builder.event;
    this.gauge = builder.gauge;
    this.instanceId = builder.instanceId;
    this.log = builder.log;
    this.sourceId = builder.sourceId;
    this.tags = createUnmodifiableMap(false, false, builder.tags);
    this.timer = builder.timer;
    this.timestamp = builder.timestamp;
  }

  /**
   * The enclosed {@link Counter}
   */
  @JsonProperty("counter")
  @Override
  public @Nullable Counter getCounter() {
    return counter;
  }

  /**
   * The enclosed {@link Event}
   */
  @JsonProperty("event")
  @Override
  public @Nullable Event getEvent() {
    return event;
  }

  /**
   * The enclosed {@link Gauge}
   */
  @JsonProperty("gauge")
  @Override
  public @Nullable Gauge getGauge() {
    return gauge;
  }

  /**
   * The instance id
   */
  @JsonProperty("instance_id")
  @Override
  public @Nullable String getInstanceId() {
    return instanceId;
  }

  /**
   * The enclosed {@link Log}
   */
  @JsonProperty("log")
  @Override
  public @Nullable Log getLog() {
    return log;
  }

  /**
   * The source id
   */
  @JsonProperty("source_id")
  @Override
  public @Nullable String getSourceId() {
    return sourceId;
  }

  /**
   * Key/value tags to include additional identifying information
   */
  @JsonProperty("tags")
  @Override
  public Map<String, String> getTags() {
    return tags;
  }

  /**
   * The enclosed {@link Timer}
   */
  @JsonProperty("timer")
  @Override
  public @Nullable Timer getTimer() {
    return timer;
  }

  /**
   * UNIX timestamp (in nanoseconds) event was wrapped in this Envelope.
   */
  @JsonProperty("timestamp")
  @Override
  public @Nullable Long getTimestamp() {
    return timestamp;
  }

  /**
   * This instance is equal to all instances of {@code Envelope} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Envelope
        && equalTo((Envelope) another);
  }

  private boolean equalTo(Envelope another) {
    return Objects.equals(counter, another.counter)
        && Objects.equals(event, another.event)
        && Objects.equals(gauge, another.gauge)
        && Objects.equals(instanceId, another.instanceId)
        && Objects.equals(log, another.log)
        && Objects.equals(sourceId, another.sourceId)
        && tags.equals(another.tags)
        && Objects.equals(timer, another.timer)
        && Objects.equals(timestamp, another.timestamp);
  }

  /**
   * Computes a hash code from attributes: {@code counter}, {@code event}, {@code gauge}, {@code instanceId}, {@code log}, {@code sourceId}, {@code tags}, {@code timer}, {@code timestamp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(counter);
    h += (h << 5) + Objects.hashCode(event);
    h += (h << 5) + Objects.hashCode(gauge);
    h += (h << 5) + Objects.hashCode(instanceId);
    h += (h << 5) + Objects.hashCode(log);
    h += (h << 5) + Objects.hashCode(sourceId);
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + Objects.hashCode(timer);
    h += (h << 5) + Objects.hashCode(timestamp);
    return h;
  }

  /**
   * Prints the immutable value {@code Envelope} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Envelope{"
        + "counter=" + counter
        + ", event=" + event
        + ", gauge=" + gauge
        + ", instanceId=" + instanceId
        + ", log=" + log
        + ", sourceId=" + sourceId
        + ", tags=" + tags
        + ", timer=" + timer
        + ", timestamp=" + timestamp
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Envelope", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._Envelope {
    Counter counter;
    Event event;
    Gauge gauge;
    String instanceId;
    Log log;
    String sourceId;
    Map<String, String> tags = Collections.emptyMap();
    Timer timer;
    Long timestamp;
    @JsonProperty("counter")
    public void setCounter(@Nullable Counter counter) {
      this.counter = counter;
    }
    @JsonProperty("event")
    public void setEvent(@Nullable Event event) {
      this.event = event;
    }
    @JsonProperty("gauge")
    public void setGauge(@Nullable Gauge gauge) {
      this.gauge = gauge;
    }
    @JsonProperty("instance_id")
    public void setInstanceId(@Nullable String instanceId) {
      this.instanceId = instanceId;
    }
    @JsonProperty("log")
    public void setLog(@Nullable Log log) {
      this.log = log;
    }
    @JsonProperty("source_id")
    public void setSourceId(@Nullable String sourceId) {
      this.sourceId = sourceId;
    }
    @JsonProperty("tags")
    public void setTags(Map<String, String> tags) {
      this.tags = tags;
    }
    @JsonProperty("timer")
    public void setTimer(@Nullable Timer timer) {
      this.timer = timer;
    }
    @JsonProperty("timestamp")
    public void setTimestamp(@Nullable Long timestamp) {
      this.timestamp = timestamp;
    }
    @Override
    public Counter getCounter() { throw new UnsupportedOperationException(); }
    @Override
    public Event getEvent() { throw new UnsupportedOperationException(); }
    @Override
    public Gauge getGauge() { throw new UnsupportedOperationException(); }
    @Override
    public String getInstanceId() { throw new UnsupportedOperationException(); }
    @Override
    public Log getLog() { throw new UnsupportedOperationException(); }
    @Override
    public String getSourceId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Timer getTimer() { throw new UnsupportedOperationException(); }
    @Override
    public Long getTimestamp() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Envelope fromJson(Json json) {
    Envelope.Builder builder = Envelope.builder();
    if (json.counter != null) {
      builder.counter(json.counter);
    }
    if (json.event != null) {
      builder.event(json.event);
    }
    if (json.gauge != null) {
      builder.gauge(json.gauge);
    }
    if (json.instanceId != null) {
      builder.instanceId(json.instanceId);
    }
    if (json.log != null) {
      builder.log(json.log);
    }
    if (json.sourceId != null) {
      builder.sourceId(json.sourceId);
    }
    if (json.tags != null) {
      builder.putAllTags(json.tags);
    }
    if (json.timer != null) {
      builder.timer(json.timer);
    }
    if (json.timestamp != null) {
      builder.timestamp(json.timestamp);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Envelope Envelope}.
   * <pre>
   * Envelope.builder()
   *    .counter(org.cloudfoundry.logcache.v1.Counter | null) // nullable {@link Envelope#getCounter() counter}
   *    .event(org.cloudfoundry.logcache.v1.Event | null) // nullable {@link Envelope#getEvent() event}
   *    .gauge(org.cloudfoundry.logcache.v1.Gauge | null) // nullable {@link Envelope#getGauge() gauge}
   *    .instanceId(String | null) // nullable {@link Envelope#getInstanceId() instanceId}
   *    .log(org.cloudfoundry.logcache.v1.Log | null) // nullable {@link Envelope#getLog() log}
   *    .sourceId(String | null) // nullable {@link Envelope#getSourceId() sourceId}
   *    .tag|putAllTags(String =&gt; String) // {@link Envelope#getTags() tags} mappings
   *    .timer(org.cloudfoundry.logcache.v1.Timer | null) // nullable {@link Envelope#getTimer() timer}
   *    .timestamp(Long | null) // nullable {@link Envelope#getTimestamp() timestamp}
   *    .build();
   * </pre>
   * @return A new Envelope builder
   */
  public static Envelope.Builder builder() {
    return new Envelope.Builder();
  }

  /**
   * Builds instances of type {@link Envelope Envelope}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Envelope", generator = "Immutables")
  public static final class Builder {
    private Counter counter;
    private Event event;
    private Gauge gauge;
    private String instanceId;
    private Log log;
    private String sourceId;
    private Map<String, String> tags = new LinkedHashMap<String, String>();
    private Timer timer;
    private Long timestamp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Envelope} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Envelope instance) {
      return from((_Envelope) instance);
    }

    /**
     * Copy abstract value type {@code _Envelope} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Envelope instance) {
      Objects.requireNonNull(instance, "instance");
      Counter counterValue = instance.getCounter();
      if (counterValue != null) {
        counter(counterValue);
      }
      Event eventValue = instance.getEvent();
      if (eventValue != null) {
        event(eventValue);
      }
      Gauge gaugeValue = instance.getGauge();
      if (gaugeValue != null) {
        gauge(gaugeValue);
      }
      String instanceIdValue = instance.getInstanceId();
      if (instanceIdValue != null) {
        instanceId(instanceIdValue);
      }
      Log logValue = instance.getLog();
      if (logValue != null) {
        log(logValue);
      }
      String sourceIdValue = instance.getSourceId();
      if (sourceIdValue != null) {
        sourceId(sourceIdValue);
      }
      putAllTags(instance.getTags());
      Timer timerValue = instance.getTimer();
      if (timerValue != null) {
        timer(timerValue);
      }
      Long timestampValue = instance.getTimestamp();
      if (timestampValue != null) {
        timestamp(timestampValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Envelope#getCounter() counter} attribute.
     * @param counter The value for counter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("counter")
    public final Builder counter(@Nullable Counter counter) {
      this.counter = counter;
      return this;
    }

    /**
     * Initializes the value for the {@link Envelope#getEvent() event} attribute.
     * @param event The value for event (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("event")
    public final Builder event(@Nullable Event event) {
      this.event = event;
      return this;
    }

    /**
     * Initializes the value for the {@link Envelope#getGauge() gauge} attribute.
     * @param gauge The value for gauge (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("gauge")
    public final Builder gauge(@Nullable Gauge gauge) {
      this.gauge = gauge;
      return this;
    }

    /**
     * Initializes the value for the {@link Envelope#getInstanceId() instanceId} attribute.
     * @param instanceId The value for instanceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instance_id")
    public final Builder instanceId(@Nullable String instanceId) {
      this.instanceId = instanceId;
      return this;
    }

    /**
     * Initializes the value for the {@link Envelope#getLog() log} attribute.
     * @param log The value for log (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("log")
    public final Builder log(@Nullable Log log) {
      this.log = log;
      return this;
    }

    /**
     * Initializes the value for the {@link Envelope#getSourceId() sourceId} attribute.
     * @param sourceId The value for sourceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source_id")
    public final Builder sourceId(@Nullable String sourceId) {
      this.sourceId = sourceId;
      return this;
    }

    /**
     * Put one entry to the {@link Envelope#getTags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String key, String value) {
      this.tags.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Envelope#getTags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Envelope#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(Map<String, ? extends String> entries) {
      this.tags.clear();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Envelope#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Envelope#getTimer() timer} attribute.
     * @param timer The value for timer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timer")
    public final Builder timer(@Nullable Timer timer) {
      this.timer = timer;
      return this;
    }

    /**
     * Initializes the value for the {@link Envelope#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timestamp")
    public final Builder timestamp(@Nullable Long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Builds a new {@link Envelope Envelope}.
     * @return An immutable instance of Envelope
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Envelope build() {
      return new Envelope(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
