package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Event}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Event.builder()}.
 */
@Generated(from = "_Event", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Event extends org.cloudfoundry.logcache.v1._Event {
  private final @Nullable String body;
  private final @Nullable String title;

  private Event(Event.Builder builder) {
    this.body = builder.body;
    this.title = builder.title;
  }

  /**
   * The event body
   */
  @JsonProperty("body")
  @Override
  public @Nullable String getBody() {
    return body;
  }

  /**
   * The event title
   */
  @JsonProperty("title")
  @Override
  public @Nullable String getTitle() {
    return title;
  }

  /**
   * This instance is equal to all instances of {@code Event} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Event
        && equalTo((Event) another);
  }

  private boolean equalTo(Event another) {
    return Objects.equals(body, another.body)
        && Objects.equals(title, another.title);
  }

  /**
   * Computes a hash code from attributes: {@code body}, {@code title}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(title);
    return h;
  }

  /**
   * Prints the immutable value {@code Event} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Event{"
        + "body=" + body
        + ", title=" + title
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Event", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._Event {
    String body;
    String title;
    @JsonProperty("body")
    public void setBody(@Nullable String body) {
      this.body = body;
    }
    @JsonProperty("title")
    public void setTitle(@Nullable String title) {
      this.title = title;
    }
    @Override
    public String getBody() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Event fromJson(Json json) {
    Event.Builder builder = Event.builder();
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Event Event}.
   * <pre>
   * Event.builder()
   *    .body(String | null) // nullable {@link Event#getBody() body}
   *    .title(String | null) // nullable {@link Event#getTitle() title}
   *    .build();
   * </pre>
   * @return A new Event builder
   */
  public static Event.Builder builder() {
    return new Event.Builder();
  }

  /**
   * Builds instances of type {@link Event Event}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Event", generator = "Immutables")
  public static final class Builder {
    private String body;
    private String title;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Event} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Event instance) {
      return from((_Event) instance);
    }

    /**
     * Copy abstract value type {@code _Event} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Event instance) {
      Objects.requireNonNull(instance, "instance");
      String bodyValue = instance.getBody();
      if (bodyValue != null) {
        body(bodyValue);
      }
      String titleValue = instance.getTitle();
      if (titleValue != null) {
        title(titleValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getBody() body} attribute.
     * @param body The value for body (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("body")
    public final Builder body(@Nullable String body) {
      this.body = body;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getTitle() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("title")
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Builds a new {@link Event Event}.
     * @return An immutable instance of Event
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Event build() {
      return new Event(this);
    }
  }
}
