package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response from the Change Secret request
 */
@Generated(from = "_ChangeSecretResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ChangeSecretResponse extends org.cloudfoundry.uaa.clients._ChangeSecretResponse {
  private final String message;
  private final String status;

  private ChangeSecretResponse(ChangeSecretResponse.Builder builder) {
    this.message = builder.message;
    this.status = builder.status;
  }

  /**
   * The change message
   */
  @JsonProperty("message")
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * The change status
   */
  @JsonProperty("status")
  @Override
  public String getStatus() {
    return status;
  }

  /**
   * This instance is equal to all instances of {@code ChangeSecretResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ChangeSecretResponse
        && equalTo((ChangeSecretResponse) another);
  }

  private boolean equalTo(ChangeSecretResponse another) {
    return message.equals(another.message)
        && status.equals(another.status);
  }

  /**
   * Computes a hash code from attributes: {@code message}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + message.hashCode();
    h += (h << 5) + status.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChangeSecretResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChangeSecretResponse{"
        + "message=" + message
        + ", status=" + status
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ChangeSecretResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._ChangeSecretResponse {
    String message;
    String status;
    @JsonProperty("message")
    public void setMessage(String message) {
      this.message = message;
    }
    @JsonProperty("status")
    public void setStatus(String status) {
      this.status = status;
    }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ChangeSecretResponse fromJson(Json json) {
    ChangeSecretResponse.Builder builder = ChangeSecretResponse.builder();
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ChangeSecretResponse ChangeSecretResponse}.
   * <pre>
   * ChangeSecretResponse.builder()
   *    .message(String) // required {@link ChangeSecretResponse#getMessage() message}
   *    .status(String) // required {@link ChangeSecretResponse#getStatus() status}
   *    .build();
   * </pre>
   * @return A new ChangeSecretResponse builder
   */
  public static ChangeSecretResponse.Builder builder() {
    return new ChangeSecretResponse.Builder();
  }

  /**
   * Builds instances of type {@link ChangeSecretResponse ChangeSecretResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ChangeSecretResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MESSAGE = 0x1L;
    private static final long INIT_BIT_STATUS = 0x2L;
    private long initBits = 0x3L;

    private String message;
    private String status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChangeSecretResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChangeSecretResponse instance) {
      return from((_ChangeSecretResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ChangeSecretResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ChangeSecretResponse instance) {
      Objects.requireNonNull(instance, "instance");
      message(instance.getMessage());
      status(instance.getStatus());
      return this;
    }

    /**
     * Initializes the value for the {@link ChangeSecretResponse#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link ChangeSecretResponse#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(String status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Builds a new {@link ChangeSecretResponse ChangeSecretResponse}.
     * @return An immutable instance of ChangeSecretResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ChangeSecretResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ChangeSecretResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build ChangeSecretResponse, some of required attributes are not set " + attributes;
    }
  }
}
