package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for Get Metadata
 */
@Generated(from = "_GetMetadataRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetMetadataRequest extends org.cloudfoundry.uaa.clients._GetMetadataRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final String clientId;

  private GetMetadataRequest(GetMetadataRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.clientId = builder.clientId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * The client id
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * This instance is equal to all instances of {@code GetMetadataRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetMetadataRequest
        && equalTo((GetMetadataRequest) another);
  }

  private boolean equalTo(GetMetadataRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && clientId.equals(another.clientId);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code clientId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + clientId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetMetadataRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetMetadataRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", clientId=" + clientId
        + "}";
  }

  /**
   * Creates a builder for {@link GetMetadataRequest GetMetadataRequest}.
   * <pre>
   * GetMetadataRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link GetMetadataRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link GetMetadataRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .clientId(String) // required {@link GetMetadataRequest#getClientId() clientId}
   *    .build();
   * </pre>
   * @return A new GetMetadataRequest builder
   */
  public static GetMetadataRequest.Builder builder() {
    return new GetMetadataRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetMetadataRequest GetMetadataRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetMetadataRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String clientId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetMetadataRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetMetadataRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetMetadataRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetMetadataRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.clients._GetMetadataRequest) {
        org.cloudfoundry.uaa.clients._GetMetadataRequest instance = (org.cloudfoundry.uaa.clients._GetMetadataRequest) object;
        clientId(instance.getClientId());
      }
    }

    /**
     * Initializes the value for the {@link GetMetadataRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link GetMetadataRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link GetMetadataRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Builds a new {@link GetMetadataRequest GetMetadataRequest}.
     * @return An immutable instance of GetMetadataRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetMetadataRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetMetadataRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build GetMetadataRequest, some of required attributes are not set " + attributes;
    }
  }
}
