package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response from the list clients request
 */
@Generated(from = "_ListMetadatasResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListMetadatasResponse extends org.cloudfoundry.uaa.clients._ListMetadatasResponse {
  private final List<Metadata> metadatas;

  private ListMetadatasResponse(ListMetadatasResponse.Builder builder) {
    this.metadatas = createUnmodifiableList(true, builder.metadatas);
  }

  /**
   * The metadatas
   */
  @JsonProperty("metadatas")
  @Override
  public List<Metadata> getMetadatas() {
    return metadatas;
  }

  /**
   * This instance is equal to all instances of {@code ListMetadatasResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListMetadatasResponse
        && equalTo((ListMetadatasResponse) another);
  }

  private boolean equalTo(ListMetadatasResponse another) {
    return metadatas.equals(another.metadatas);
  }

  /**
   * Computes a hash code from attributes: {@code metadatas}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + metadatas.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListMetadatasResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListMetadatasResponse{"
        + "metadatas=" + metadatas
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListMetadatasResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._ListMetadatasResponse {
    List<Metadata> metadatas = Collections.emptyList();
    @JsonProperty("metadatas")
    public void setMetadatas(List<Metadata> metadatas) {
      this.metadatas = metadatas;
    }
    @Override
    public List<Metadata> getMetadatas() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListMetadatasResponse fromJson(Json json) {
    ListMetadatasResponse.Builder builder = ListMetadatasResponse.builder();
    if (json.metadatas != null) {
      builder.addAllMetadatas(json.metadatas);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListMetadatasResponse ListMetadatasResponse}.
   * <pre>
   * ListMetadatasResponse.builder()
   *    .metadata|addAllMetadatas(Metadata) // {@link ListMetadatasResponse#getMetadatas() metadatas} elements
   *    .build();
   * </pre>
   * @return A new ListMetadatasResponse builder
   */
  public static ListMetadatasResponse.Builder builder() {
    return new ListMetadatasResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListMetadatasResponse ListMetadatasResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListMetadatasResponse", generator = "Immutables")
  public static final class Builder {
    private List<Metadata> metadatas = new ArrayList<Metadata>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListMetadatasResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListMetadatasResponse instance) {
      return from((_ListMetadatasResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListMetadatasResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListMetadatasResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllMetadatas(instance.getMetadatas());
      return this;
    }

    /**
     * Adds one element to {@link ListMetadatasResponse#getMetadatas() metadatas} list.
     * @param element A metadatas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(Metadata element) {
      this.metadatas.add(Objects.requireNonNull(element, "metadatas element"));
      return this;
    }

    /**
     * Adds elements to {@link ListMetadatasResponse#getMetadatas() metadatas} list.
     * @param elements An array of metadatas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadatas(Metadata... elements) {
      for (Metadata element : elements) {
        this.metadatas.add(Objects.requireNonNull(element, "metadatas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListMetadatasResponse#getMetadatas() metadatas} list.
     * @param elements An iterable of metadatas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadatas")
    public final Builder metadatas(Iterable<? extends Metadata> elements) {
      this.metadatas.clear();
      return addAllMetadatas(elements);
    }

    /**
     * Adds elements to {@link ListMetadatasResponse#getMetadatas() metadatas} list.
     * @param elements An iterable of metadatas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMetadatas(Iterable<? extends Metadata> elements) {
      for (Metadata element : elements) {
        this.metadatas.add(Objects.requireNonNull(element, "metadatas element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListMetadatasResponse ListMetadatasResponse}.
     * @return An immutable instance of ListMetadatasResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListMetadatasResponse build() {
      return new ListMetadatasResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
