package org.cloudfoundry.uaa.serverinformation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Perform Auto Login operation
 */
@Generated(from = "_AutoLoginRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AutoLoginRequest extends org.cloudfoundry.uaa.serverinformation._AutoLoginRequest {
  private final String clientId;
  private final String code;

  private AutoLoginRequest(AutoLoginRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.code = builder.code;
  }

  /**
   * The client_id that generated the autologin code
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The code generated from the POST /autologin
   */
  @Override
  public String getCode() {
    return code;
  }

  /**
   * This instance is equal to all instances of {@code AutoLoginRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AutoLoginRequest
        && equalTo((AutoLoginRequest) another);
  }

  private boolean equalTo(AutoLoginRequest another) {
    return clientId.equals(another.clientId)
        && code.equals(another.code);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code code}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + code.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AutoLoginRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AutoLoginRequest{"
        + "clientId=" + clientId
        + ", code=" + code
        + "}";
  }

  /**
   * Creates a builder for {@link AutoLoginRequest AutoLoginRequest}.
   * <pre>
   * AutoLoginRequest.builder()
   *    .clientId(String) // required {@link AutoLoginRequest#getClientId() clientId}
   *    .code(String) // required {@link AutoLoginRequest#getCode() code}
   *    .build();
   * </pre>
   * @return A new AutoLoginRequest builder
   */
  public static AutoLoginRequest.Builder builder() {
    return new AutoLoginRequest.Builder();
  }

  /**
   * Builds instances of type {@link AutoLoginRequest AutoLoginRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AutoLoginRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_CODE = 0x2L;
    private long initBits = 0x3L;

    private String clientId;
    private String code;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AutoLoginRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AutoLoginRequest instance) {
      return from((_AutoLoginRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AutoLoginRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AutoLoginRequest instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      code(instance.getCode());
      return this;
    }

    /**
     * Initializes the value for the {@link AutoLoginRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AutoLoginRequest#getCode() code} attribute.
     * @param code The value for code 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder code(String code) {
      this.code = Objects.requireNonNull(code, "code");
      initBits &= ~INIT_BIT_CODE;
      return this;
    }

    /**
     * Builds a new {@link AutoLoginRequest AutoLoginRequest}.
     * @return An immutable instance of AutoLoginRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AutoLoginRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AutoLoginRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CODE) != 0) attributes.add("code");
      return "Cannot build AutoLoginRequest, some of required attributes are not set " + attributes;
    }
  }
}
