package org.cloudfoundry.uaa.serverinformation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Info operation
 */
@Generated(from = "_GetInfoResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetInfoResponse extends org.cloudfoundry.uaa.serverinformation._GetInfoResponse {
  private final @Nullable ApplicationInfo app;
  private final @Nullable String commitId;
  private final @Nullable String entityId;
  private final @Nullable Map<String, String> idpDefinitions;
  private final @Nullable Links links;
  private final @Nullable Prompts prompts;
  private final @Nullable Boolean showLoginLinks;
  private final @Nullable String timestamp;
  private final @Nullable String zoneName;

  private GetInfoResponse(GetInfoResponse.Builder builder) {
    this.app = builder.app;
    this.commitId = builder.commitId;
    this.entityId = builder.entityId;
    this.idpDefinitions = builder.idpDefinitions == null ? null : createUnmodifiableMap(false, false, builder.idpDefinitions);
    this.links = builder.links;
    this.prompts = builder.prompts;
    this.showLoginLinks = builder.showLoginLinks;
    this.timestamp = builder.timestamp;
    this.zoneName = builder.zoneName;
  }

  /**
   * The UAA application information
   */
  @JsonProperty("app")
  @Override
  public @Nullable ApplicationInfo getApp() {
    return app;
  }

  /**
   * The git sha for the UAA version
   */
  @JsonProperty("commit_id")
  @Override
  public @Nullable String getCommitId() {
    return commitId;
  }

  /**
   * The configured SAML entityId
   */
  @JsonProperty("entityID")
  @Override
  public @Nullable String getEntityId() {
    return entityId;
  }

  /**
   * A list of alias/url pairs of SAML IDP providers configured.
   */
  @JsonProperty("idpDefinitions")
  @Override
  public @Nullable Map<String, String> getIdpDefinitions() {
    return idpDefinitions;
  }

  /**
   * A list of alias/url pairs of configured action URLs for the UAA
   */
  @JsonProperty("links")
  @Override
  public @Nullable Links getLinks() {
    return links;
  }

  /**
   * Name/value pairs of configured prompts that the UAA will login a user.
   */
  @JsonProperty("prompts")
  @Override
  public @Nullable Prompts getPrompts() {
    return prompts;
  }

  /**
   * Whether login links are shown
   */
  @JsonProperty("showLoginLinks")
  @Override
  public @Nullable Boolean getShowLoginLinks() {
    return showLoginLinks;
  }

  /**
   * JSON timestamp for the commit of the UAA version
   */
  @JsonProperty("timestamp")
  @Override
  public @Nullable String getTimestamp() {
    return timestamp;
  }

  /**
   * The name of the zone invoked
   */
  @JsonProperty("zone_name")
  @Override
  public @Nullable String getZoneName() {
    return zoneName;
  }

  /**
   * This instance is equal to all instances of {@code GetInfoResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetInfoResponse
        && equalTo((GetInfoResponse) another);
  }

  private boolean equalTo(GetInfoResponse another) {
    return Objects.equals(app, another.app)
        && Objects.equals(commitId, another.commitId)
        && Objects.equals(entityId, another.entityId)
        && Objects.equals(idpDefinitions, another.idpDefinitions)
        && Objects.equals(links, another.links)
        && Objects.equals(prompts, another.prompts)
        && Objects.equals(showLoginLinks, another.showLoginLinks)
        && Objects.equals(timestamp, another.timestamp)
        && Objects.equals(zoneName, another.zoneName);
  }

  /**
   * Computes a hash code from attributes: {@code app}, {@code commitId}, {@code entityId}, {@code idpDefinitions}, {@code links}, {@code prompts}, {@code showLoginLinks}, {@code timestamp}, {@code zoneName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(app);
    h += (h << 5) + Objects.hashCode(commitId);
    h += (h << 5) + Objects.hashCode(entityId);
    h += (h << 5) + Objects.hashCode(idpDefinitions);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(prompts);
    h += (h << 5) + Objects.hashCode(showLoginLinks);
    h += (h << 5) + Objects.hashCode(timestamp);
    h += (h << 5) + Objects.hashCode(zoneName);
    return h;
  }

  /**
   * Prints the immutable value {@code GetInfoResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetInfoResponse{"
        + "app=" + app
        + ", commitId=" + commitId
        + ", entityId=" + entityId
        + ", idpDefinitions=" + idpDefinitions
        + ", links=" + links
        + ", prompts=" + prompts
        + ", showLoginLinks=" + showLoginLinks
        + ", timestamp=" + timestamp
        + ", zoneName=" + zoneName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetInfoResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.serverinformation._GetInfoResponse {
    ApplicationInfo app;
    String commitId;
    String entityId;
    Map<String, String> idpDefinitions = null;
    Links links;
    Prompts prompts;
    Boolean showLoginLinks;
    String timestamp;
    String zoneName;
    @JsonProperty("app")
    public void setApp(@Nullable ApplicationInfo app) {
      this.app = app;
    }
    @JsonProperty("commit_id")
    public void setCommitId(@Nullable String commitId) {
      this.commitId = commitId;
    }
    @JsonProperty("entityID")
    public void setEntityId(@Nullable String entityId) {
      this.entityId = entityId;
    }
    @JsonProperty("idpDefinitions")
    public void setIdpDefinitions(@Nullable Map<String, String> idpDefinitions) {
      this.idpDefinitions = idpDefinitions;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Links links) {
      this.links = links;
    }
    @JsonProperty("prompts")
    public void setPrompts(@Nullable Prompts prompts) {
      this.prompts = prompts;
    }
    @JsonProperty("showLoginLinks")
    public void setShowLoginLinks(@Nullable Boolean showLoginLinks) {
      this.showLoginLinks = showLoginLinks;
    }
    @JsonProperty("timestamp")
    public void setTimestamp(@Nullable String timestamp) {
      this.timestamp = timestamp;
    }
    @JsonProperty("zone_name")
    public void setZoneName(@Nullable String zoneName) {
      this.zoneName = zoneName;
    }
    @Override
    public ApplicationInfo getApp() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommitId() { throw new UnsupportedOperationException(); }
    @Override
    public String getEntityId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getIdpDefinitions() { throw new UnsupportedOperationException(); }
    @Override
    public Links getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public Prompts getPrompts() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getShowLoginLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetInfoResponse fromJson(Json json) {
    GetInfoResponse.Builder builder = GetInfoResponse.builder();
    if (json.app != null) {
      builder.app(json.app);
    }
    if (json.commitId != null) {
      builder.commitId(json.commitId);
    }
    if (json.entityId != null) {
      builder.entityId(json.entityId);
    }
    if (json.idpDefinitions != null) {
      builder.putAllIdpDefinitions(json.idpDefinitions);
    }
    if (json.links != null) {
      builder.links(json.links);
    }
    if (json.prompts != null) {
      builder.prompts(json.prompts);
    }
    if (json.showLoginLinks != null) {
      builder.showLoginLinks(json.showLoginLinks);
    }
    if (json.timestamp != null) {
      builder.timestamp(json.timestamp);
    }
    if (json.zoneName != null) {
      builder.zoneName(json.zoneName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetInfoResponse GetInfoResponse}.
   * <pre>
   * GetInfoResponse.builder()
   *    .app(org.cloudfoundry.uaa.serverinformation.ApplicationInfo | null) // nullable {@link GetInfoResponse#getApp() app}
   *    .commitId(String | null) // nullable {@link GetInfoResponse#getCommitId() commitId}
   *    .entityId(String | null) // nullable {@link GetInfoResponse#getEntityId() entityId}
   *    .idpDefinitions(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link GetInfoResponse#getIdpDefinitions() idpDefinitions}
   *    .links(org.cloudfoundry.uaa.serverinformation.Links | null) // nullable {@link GetInfoResponse#getLinks() links}
   *    .prompts(org.cloudfoundry.uaa.serverinformation.Prompts | null) // nullable {@link GetInfoResponse#getPrompts() prompts}
   *    .showLoginLinks(Boolean | null) // nullable {@link GetInfoResponse#getShowLoginLinks() showLoginLinks}
   *    .timestamp(String | null) // nullable {@link GetInfoResponse#getTimestamp() timestamp}
   *    .zoneName(String | null) // nullable {@link GetInfoResponse#getZoneName() zoneName}
   *    .build();
   * </pre>
   * @return A new GetInfoResponse builder
   */
  public static GetInfoResponse.Builder builder() {
    return new GetInfoResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetInfoResponse GetInfoResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetInfoResponse", generator = "Immutables")
  public static final class Builder {
    private ApplicationInfo app;
    private String commitId;
    private String entityId;
    private Map<String, String> idpDefinitions = null;
    private Links links;
    private Prompts prompts;
    private Boolean showLoginLinks;
    private String timestamp;
    private String zoneName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetInfoResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetInfoResponse instance) {
      return from((_GetInfoResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetInfoResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetInfoResponse instance) {
      Objects.requireNonNull(instance, "instance");
      ApplicationInfo appValue = instance.getApp();
      if (appValue != null) {
        app(appValue);
      }
      String commitIdValue = instance.getCommitId();
      if (commitIdValue != null) {
        commitId(commitIdValue);
      }
      String entityIdValue = instance.getEntityId();
      if (entityIdValue != null) {
        entityId(entityIdValue);
      }
      Map<String, String> idpDefinitionsValue = instance.getIdpDefinitions();
      if (idpDefinitionsValue != null) {
        putAllIdpDefinitions(idpDefinitionsValue);
      }
      Links linksValue = instance.getLinks();
      if (linksValue != null) {
        links(linksValue);
      }
      Prompts promptsValue = instance.getPrompts();
      if (promptsValue != null) {
        prompts(promptsValue);
      }
      Boolean showLoginLinksValue = instance.getShowLoginLinks();
      if (showLoginLinksValue != null) {
        showLoginLinks(showLoginLinksValue);
      }
      String timestampValue = instance.getTimestamp();
      if (timestampValue != null) {
        timestamp(timestampValue);
      }
      String zoneNameValue = instance.getZoneName();
      if (zoneNameValue != null) {
        zoneName(zoneNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getApp() app} attribute.
     * @param app The value for app (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder app(@Nullable ApplicationInfo app) {
      this.app = app;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getCommitId() commitId} attribute.
     * @param commitId The value for commitId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("commit_id")
    public final Builder commitId(@Nullable String commitId) {
      this.commitId = commitId;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getEntityId() entityId} attribute.
     * @param entityId The value for entityId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entityID")
    public final Builder entityId(@Nullable String entityId) {
      this.entityId = entityId;
      return this;
    }

    /**
     * Put one entry to the {@link GetInfoResponse#getIdpDefinitions() idpDefinitions} map.
     * @param key The key in the idpDefinitions map
     * @param value The associated value in the idpDefinitions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder idpDefinition(String key, String value) {
      if (this.idpDefinitions == null) {
        this.idpDefinitions = new LinkedHashMap<String, String>();
      }
      this.idpDefinitions.put(
          Objects.requireNonNull(key, "idpDefinitions key"),
          Objects.requireNonNull(value, "idpDefinitions value"));
      return this;
    }

    /**
     * Put one entry to the {@link GetInfoResponse#getIdpDefinitions() idpDefinitions} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder idpDefinition(Map.Entry<String, ? extends String> entry) {
      if (this.idpDefinitions == null) {
        this.idpDefinitions = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.idpDefinitions.put(
          Objects.requireNonNull(k, "idpDefinitions key"),
          Objects.requireNonNull(v, "idpDefinitions value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetInfoResponse#getIdpDefinitions() idpDefinitions} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the idpDefinitions map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("idpDefinitions")
    public final Builder idpDefinitions(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.idpDefinitions = null;
        return this;
      }
      this.idpDefinitions = new LinkedHashMap<String, String>();
      return putAllIdpDefinitions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetInfoResponse#getIdpDefinitions() idpDefinitions} map. Nulls are not permitted
     * @param entries The entries that will be added to the idpDefinitions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllIdpDefinitions(Map<String, ? extends String> entries) {
      if (this.idpDefinitions == null) {
        this.idpDefinitions = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.idpDefinitions.put(
            Objects.requireNonNull(k, "idpDefinitions key"),
            Objects.requireNonNull(v, "idpDefinitions value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getLinks() links} attribute.
     * @param links The value for links (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Links links) {
      this.links = links;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getPrompts() prompts} attribute.
     * @param prompts The value for prompts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("prompts")
    public final Builder prompts(@Nullable Prompts prompts) {
      this.prompts = prompts;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getShowLoginLinks() showLoginLinks} attribute.
     * @param showLoginLinks The value for showLoginLinks (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("showLoginLinks")
    public final Builder showLoginLinks(@Nullable Boolean showLoginLinks) {
      this.showLoginLinks = showLoginLinks;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timestamp")
    public final Builder timestamp(@Nullable String timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getZoneName() zoneName} attribute.
     * @param zoneName The value for zoneName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("zone_name")
    public final Builder zoneName(@Nullable String zoneName) {
      this.zoneName = zoneName;
      return this;
    }

    /**
     * Builds a new {@link GetInfoResponse GetInfoResponse}.
     * @return An immutable instance of GetInfoResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetInfoResponse build() {
      return new GetInfoResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
