/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceInstances;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ServiceInstanceType {
    MANAGED("managed"),
    USER_PROVIDED("user-provided");

    private final String value;

    private ServiceInstanceType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ServiceInstanceType from(String s) {
        switch (s.toLowerCase()) {
            case "managed": {
                return MANAGED;
            }
            case "user-provided": {
                return USER_PROVIDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown service instance type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

