/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityzones.Key;
import org.cloudfoundry.uaa.identityzones._SamlConfiguration;
import org.immutables.value.Generated;

@Generated(from="_SamlConfiguration", generator="Immutables")
public final class SamlConfiguration
extends _SamlConfiguration {
    @Nullable
    private final String activeKeyId;
    @Nullable
    private final Boolean assertionSigned;
    @Nullable
    private final Integer assertionTimeToLive;
    @Nullable
    private final String certificate;
    @Nullable
    private final Boolean disableInResponseToCheck;
    @Nullable
    private final String entityId;
    @Nullable
    private final Map<String, Key> keys;
    @Nullable
    private final String privateKey;
    @Nullable
    private final String privateKeyPassword;
    @Nullable
    private final Boolean requestSigned;
    @Nullable
    private final Boolean wantAssertionSigned;
    @Nullable
    private final Boolean wantPartnerAuthenticationRequestSigned;

    private SamlConfiguration(Builder builder) {
        this.activeKeyId = builder.activeKeyId;
        this.assertionSigned = builder.assertionSigned;
        this.assertionTimeToLive = builder.assertionTimeToLive;
        this.certificate = builder.certificate;
        this.disableInResponseToCheck = builder.disableInResponseToCheck;
        this.entityId = builder.entityId;
        this.keys = builder.keys == null ? null : SamlConfiguration.createUnmodifiableMap(false, false, builder.keys);
        this.privateKey = builder.privateKey;
        this.privateKeyPassword = builder.privateKeyPassword;
        this.requestSigned = builder.requestSigned;
        this.wantAssertionSigned = builder.wantAssertionSigned;
        this.wantPartnerAuthenticationRequestSigned = builder.wantPartnerAuthenticationRequestSigned;
    }

    @Override
    @JsonProperty(value="activeKeyId")
    @Nullable
    public String getActiveKeyId() {
        return this.activeKeyId;
    }

    @Override
    @JsonProperty(value="assertionSigned")
    @Nullable
    public Boolean getAssertionSigned() {
        return this.assertionSigned;
    }

    @Override
    @JsonProperty(value="assertionTimeToLiveSeconds")
    @Nullable
    public Integer getAssertionTimeToLive() {
        return this.assertionTimeToLive;
    }

    @Override
    @JsonProperty(value="certificate")
    @Nullable
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    @JsonProperty(value="disableInResponseToCheck")
    @Nullable
    public Boolean getDisableInResponseToCheck() {
        return this.disableInResponseToCheck;
    }

    @Override
    @JsonProperty(value="entityID")
    @Nullable
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    @JsonProperty(value="keys")
    @Nullable
    public Map<String, Key> getKeys() {
        return this.keys;
    }

    @Override
    @JsonProperty(value="privateKey")
    @Nullable
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    @JsonProperty(value="privateKeyPassword")
    @Nullable
    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @Override
    @JsonProperty(value="requestSigned")
    @Nullable
    public Boolean getRequestSigned() {
        return this.requestSigned;
    }

    @Override
    @JsonProperty(value="wantAssertionSigned")
    @Nullable
    public Boolean getWantAssertionSigned() {
        return this.wantAssertionSigned;
    }

    @Override
    @JsonProperty(value="wantAuthnRequestSigned")
    @Nullable
    public Boolean getWantPartnerAuthenticationRequestSigned() {
        return this.wantPartnerAuthenticationRequestSigned;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SamlConfiguration && this.equalTo((SamlConfiguration)another);
    }

    private boolean equalTo(SamlConfiguration another) {
        return Objects.equals(this.activeKeyId, another.activeKeyId) && Objects.equals(this.assertionSigned, another.assertionSigned) && Objects.equals(this.assertionTimeToLive, another.assertionTimeToLive) && Objects.equals(this.certificate, another.certificate) && Objects.equals(this.disableInResponseToCheck, another.disableInResponseToCheck) && Objects.equals(this.entityId, another.entityId) && Objects.equals(this.keys, another.keys) && Objects.equals(this.privateKey, another.privateKey) && Objects.equals(this.privateKeyPassword, another.privateKeyPassword) && Objects.equals(this.requestSigned, another.requestSigned) && Objects.equals(this.wantAssertionSigned, another.wantAssertionSigned) && Objects.equals(this.wantPartnerAuthenticationRequestSigned, another.wantPartnerAuthenticationRequestSigned);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.activeKeyId);
        h += (h << 5) + Objects.hashCode(this.assertionSigned);
        h += (h << 5) + Objects.hashCode(this.assertionTimeToLive);
        h += (h << 5) + Objects.hashCode(this.certificate);
        h += (h << 5) + Objects.hashCode(this.disableInResponseToCheck);
        h += (h << 5) + Objects.hashCode(this.entityId);
        h += (h << 5) + Objects.hashCode(this.keys);
        h += (h << 5) + Objects.hashCode(this.privateKey);
        h += (h << 5) + Objects.hashCode(this.privateKeyPassword);
        h += (h << 5) + Objects.hashCode(this.requestSigned);
        h += (h << 5) + Objects.hashCode(this.wantAssertionSigned);
        h += (h << 5) + Objects.hashCode(this.wantPartnerAuthenticationRequestSigned);
        return h;
    }

    public String toString() {
        return "SamlConfiguration{activeKeyId=" + this.activeKeyId + ", assertionSigned=" + this.assertionSigned + ", assertionTimeToLive=" + this.assertionTimeToLive + ", certificate=" + this.certificate + ", disableInResponseToCheck=" + this.disableInResponseToCheck + ", entityId=" + this.entityId + ", keys=" + this.keys + ", privateKey=" + this.privateKey + ", privateKeyPassword=" + this.privateKeyPassword + ", requestSigned=" + this.requestSigned + ", wantAssertionSigned=" + this.wantAssertionSigned + ", wantPartnerAuthenticationRequestSigned=" + this.wantPartnerAuthenticationRequestSigned + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SamlConfiguration fromJson(Json json) {
        Builder builder = SamlConfiguration.builder();
        if (json.activeKeyId != null) {
            builder.activeKeyId(json.activeKeyId);
        }
        if (json.assertionSigned != null) {
            builder.assertionSigned(json.assertionSigned);
        }
        if (json.assertionTimeToLive != null) {
            builder.assertionTimeToLive(json.assertionTimeToLive);
        }
        if (json.certificate != null) {
            builder.certificate(json.certificate);
        }
        if (json.disableInResponseToCheck != null) {
            builder.disableInResponseToCheck(json.disableInResponseToCheck);
        }
        if (json.entityId != null) {
            builder.entityId(json.entityId);
        }
        if (json.keys != null) {
            builder.putAllKeys(json.keys);
        }
        if (json.privateKey != null) {
            builder.privateKey(json.privateKey);
        }
        if (json.privateKeyPassword != null) {
            builder.privateKeyPassword(json.privateKeyPassword);
        }
        if (json.requestSigned != null) {
            builder.requestSigned(json.requestSigned);
        }
        if (json.wantAssertionSigned != null) {
            builder.wantAssertionSigned(json.wantAssertionSigned);
        }
        if (json.wantPartnerAuthenticationRequestSigned != null) {
            builder.wantPartnerAuthenticationRequestSigned(json.wantPartnerAuthenticationRequestSigned);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_SamlConfiguration", generator="Immutables")
    public static final class Builder {
        private String activeKeyId;
        private Boolean assertionSigned;
        private Integer assertionTimeToLive;
        private String certificate;
        private Boolean disableInResponseToCheck;
        private String entityId;
        private Map<String, Key> keys = null;
        private String privateKey;
        private String privateKeyPassword;
        private Boolean requestSigned;
        private Boolean wantAssertionSigned;
        private Boolean wantPartnerAuthenticationRequestSigned;

        private Builder() {
        }

        public final Builder from(SamlConfiguration instance) {
            return this.from((_SamlConfiguration)instance);
        }

        final Builder from(_SamlConfiguration instance) {
            Boolean wantPartnerAuthenticationRequestSignedValue;
            Boolean wantAssertionSignedValue;
            Boolean requestSignedValue;
            String privateKeyPasswordValue;
            String privateKeyValue;
            Map<String, Key> keysValue;
            String entityIdValue;
            Boolean disableInResponseToCheckValue;
            String certificateValue;
            Integer assertionTimeToLiveValue;
            Boolean assertionSignedValue;
            Objects.requireNonNull(instance, "instance");
            String activeKeyIdValue = instance.getActiveKeyId();
            if (activeKeyIdValue != null) {
                this.activeKeyId(activeKeyIdValue);
            }
            if ((assertionSignedValue = instance.getAssertionSigned()) != null) {
                this.assertionSigned(assertionSignedValue);
            }
            if ((assertionTimeToLiveValue = instance.getAssertionTimeToLive()) != null) {
                this.assertionTimeToLive(assertionTimeToLiveValue);
            }
            if ((certificateValue = instance.getCertificate()) != null) {
                this.certificate(certificateValue);
            }
            if ((disableInResponseToCheckValue = instance.getDisableInResponseToCheck()) != null) {
                this.disableInResponseToCheck(disableInResponseToCheckValue);
            }
            if ((entityIdValue = instance.getEntityId()) != null) {
                this.entityId(entityIdValue);
            }
            if ((keysValue = instance.getKeys()) != null) {
                this.putAllKeys(keysValue);
            }
            if ((privateKeyValue = instance.getPrivateKey()) != null) {
                this.privateKey(privateKeyValue);
            }
            if ((privateKeyPasswordValue = instance.getPrivateKeyPassword()) != null) {
                this.privateKeyPassword(privateKeyPasswordValue);
            }
            if ((requestSignedValue = instance.getRequestSigned()) != null) {
                this.requestSigned(requestSignedValue);
            }
            if ((wantAssertionSignedValue = instance.getWantAssertionSigned()) != null) {
                this.wantAssertionSigned(wantAssertionSignedValue);
            }
            if ((wantPartnerAuthenticationRequestSignedValue = instance.getWantPartnerAuthenticationRequestSigned()) != null) {
                this.wantPartnerAuthenticationRequestSigned(wantPartnerAuthenticationRequestSignedValue);
            }
            return this;
        }

        @JsonProperty(value="activeKeyId")
        public final Builder activeKeyId(@Nullable String activeKeyId) {
            this.activeKeyId = activeKeyId;
            return this;
        }

        @JsonProperty(value="assertionSigned")
        public final Builder assertionSigned(@Nullable Boolean assertionSigned) {
            this.assertionSigned = assertionSigned;
            return this;
        }

        @JsonProperty(value="assertionTimeToLiveSeconds")
        public final Builder assertionTimeToLive(@Nullable Integer assertionTimeToLive) {
            this.assertionTimeToLive = assertionTimeToLive;
            return this;
        }

        @JsonProperty(value="certificate")
        public final Builder certificate(@Nullable String certificate) {
            this.certificate = certificate;
            return this;
        }

        @JsonProperty(value="disableInResponseToCheck")
        public final Builder disableInResponseToCheck(@Nullable Boolean disableInResponseToCheck) {
            this.disableInResponseToCheck = disableInResponseToCheck;
            return this;
        }

        @JsonProperty(value="entityID")
        public final Builder entityId(@Nullable String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final Builder key(String key, Key value) {
            if (this.keys == null) {
                this.keys = new LinkedHashMap<String, Key>();
            }
            this.keys.put(Objects.requireNonNull(key, "keys key"), Objects.requireNonNull(value, "keys value"));
            return this;
        }

        public final Builder key(Map.Entry<String, ? extends Key> entry) {
            if (this.keys == null) {
                this.keys = new LinkedHashMap<String, Key>();
            }
            String k = entry.getKey();
            Key v = entry.getValue();
            this.keys.put(Objects.requireNonNull(k, "keys key"), Objects.requireNonNull(v, "keys value"));
            return this;
        }

        @JsonProperty(value="keys")
        public final Builder keys(@Nullable Map<String, ? extends Key> entries) {
            if (entries == null) {
                this.keys = null;
                return this;
            }
            this.keys = new LinkedHashMap<String, Key>();
            return this.putAllKeys(entries);
        }

        public final Builder putAllKeys(Map<String, ? extends Key> entries) {
            if (this.keys == null) {
                this.keys = new LinkedHashMap<String, Key>();
            }
            for (Map.Entry<String, ? extends Key> e : entries.entrySet()) {
                String k = e.getKey();
                Key v = e.getValue();
                this.keys.put(Objects.requireNonNull(k, "keys key"), Objects.requireNonNull(v, "keys value"));
            }
            return this;
        }

        @JsonProperty(value="privateKey")
        public final Builder privateKey(@Nullable String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @JsonProperty(value="privateKeyPassword")
        public final Builder privateKeyPassword(@Nullable String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
            return this;
        }

        @JsonProperty(value="requestSigned")
        public final Builder requestSigned(@Nullable Boolean requestSigned) {
            this.requestSigned = requestSigned;
            return this;
        }

        @JsonProperty(value="wantAssertionSigned")
        public final Builder wantAssertionSigned(@Nullable Boolean wantAssertionSigned) {
            this.wantAssertionSigned = wantAssertionSigned;
            return this;
        }

        @JsonProperty(value="wantAuthnRequestSigned")
        public final Builder wantPartnerAuthenticationRequestSigned(@Nullable Boolean wantPartnerAuthenticationRequestSigned) {
            this.wantPartnerAuthenticationRequestSigned = wantPartnerAuthenticationRequestSigned;
            return this;
        }

        public SamlConfiguration build() {
            return new SamlConfiguration(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_SamlConfiguration", generator="Immutables")
    static final class Json
    extends _SamlConfiguration {
        String activeKeyId;
        Boolean assertionSigned;
        Integer assertionTimeToLive;
        String certificate;
        Boolean disableInResponseToCheck;
        String entityId;
        Map<String, Key> keys = null;
        String privateKey;
        String privateKeyPassword;
        Boolean requestSigned;
        Boolean wantAssertionSigned;
        Boolean wantPartnerAuthenticationRequestSigned;

        Json() {
        }

        @JsonProperty(value="activeKeyId")
        public void setActiveKeyId(@Nullable String activeKeyId) {
            this.activeKeyId = activeKeyId;
        }

        @JsonProperty(value="assertionSigned")
        public void setAssertionSigned(@Nullable Boolean assertionSigned) {
            this.assertionSigned = assertionSigned;
        }

        @JsonProperty(value="assertionTimeToLiveSeconds")
        public void setAssertionTimeToLive(@Nullable Integer assertionTimeToLive) {
            this.assertionTimeToLive = assertionTimeToLive;
        }

        @JsonProperty(value="certificate")
        public void setCertificate(@Nullable String certificate) {
            this.certificate = certificate;
        }

        @JsonProperty(value="disableInResponseToCheck")
        public void setDisableInResponseToCheck(@Nullable Boolean disableInResponseToCheck) {
            this.disableInResponseToCheck = disableInResponseToCheck;
        }

        @JsonProperty(value="entityID")
        public void setEntityId(@Nullable String entityId) {
            this.entityId = entityId;
        }

        @JsonProperty(value="keys")
        public void setKeys(@Nullable Map<String, Key> keys) {
            this.keys = keys;
        }

        @JsonProperty(value="privateKey")
        public void setPrivateKey(@Nullable String privateKey) {
            this.privateKey = privateKey;
        }

        @JsonProperty(value="privateKeyPassword")
        public void setPrivateKeyPassword(@Nullable String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
        }

        @JsonProperty(value="requestSigned")
        public void setRequestSigned(@Nullable Boolean requestSigned) {
            this.requestSigned = requestSigned;
        }

        @JsonProperty(value="wantAssertionSigned")
        public void setWantAssertionSigned(@Nullable Boolean wantAssertionSigned) {
            this.wantAssertionSigned = wantAssertionSigned;
        }

        @JsonProperty(value="wantAuthnRequestSigned")
        public void setWantPartnerAuthenticationRequestSigned(@Nullable Boolean wantPartnerAuthenticationRequestSigned) {
            this.wantPartnerAuthenticationRequestSigned = wantPartnerAuthenticationRequestSigned;
        }

        @Override
        public String getActiveKeyId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getAssertionSigned() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getAssertionTimeToLive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCertificate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDisableInResponseToCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEntityId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Key> getKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrivateKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrivateKeyPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getRequestSigned() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getWantAssertionSigned() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getWantPartnerAuthenticationRequestSigned() {
            throw new UnsupportedOperationException();
        }
    }
}

