/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.cloudfoundry.client.v3.deployments.Deployment;
import org.cloudfoundry.client.v3.deployments.DeploymentRelationships;
import org.cloudfoundry.client.v3.deployments.DeploymentState;
import org.cloudfoundry.client.v3.deployments.Process;
import org.cloudfoundry.client.v3.deployments.Revision;
import org.cloudfoundry.client.v3.deployments.Status;
import org.cloudfoundry.client.v3.deployments._CreateDeploymentResponse;
import org.immutables.value.Generated;

@Generated(from="_CreateDeploymentResponse", generator="Immutables")
public final class CreateDeploymentResponse
extends _CreateDeploymentResponse {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    @Nullable
    private final ToOneRelationship application;
    @Nullable
    private final Relationship droplet;
    @Nullable
    private final Metadata metadata;
    @Nullable
    private final List<Process> newProcesses;
    @Nullable
    private final Relationship previousDroplet;
    @Nullable
    private final DeploymentRelationships relationships;
    @Nullable
    private final Revision revision;
    private final DeploymentState state;
    @Nullable
    private final Status status;

    private CreateDeploymentResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = CreateDeploymentResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.application = builder.application;
        this.droplet = builder.droplet;
        this.metadata = builder.metadata;
        this.newProcesses = builder.newProcesses == null ? null : CreateDeploymentResponse.createUnmodifiableList(true, builder.newProcesses);
        this.previousDroplet = builder.previousDroplet;
        this.relationships = builder.relationships;
        this.revision = builder.revision;
        this.state = builder.state;
        this.status = builder.status;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="app")
    @Nullable
    public ToOneRelationship getApplication() {
        return this.application;
    }

    @Override
    @JsonProperty(value="droplet")
    @Nullable
    public Relationship getDroplet() {
        return this.droplet;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="new_processes")
    @Nullable
    public List<Process> getNewProcesses() {
        return this.newProcesses;
    }

    @Override
    @JsonProperty(value="previous_droplet")
    @Nullable
    public Relationship getPreviousDroplet() {
        return this.previousDroplet;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public DeploymentRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="revision")
    @Nullable
    public Revision getRevision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="state")
    @Deprecated
    public DeploymentState getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="status")
    @Nullable
    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateDeploymentResponse && this.equalTo((CreateDeploymentResponse)another);
    }

    private boolean equalTo(CreateDeploymentResponse another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.application, another.application) && Objects.equals(this.droplet, another.droplet) && Objects.equals(this.metadata, another.metadata) && Objects.equals(this.newProcesses, another.newProcesses) && Objects.equals(this.previousDroplet, another.previousDroplet) && Objects.equals(this.relationships, another.relationships) && Objects.equals(this.revision, another.revision) && this.state.equals((Object)another.state) && Objects.equals(this.status, another.status);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.application);
        h += (h << 5) + Objects.hashCode(this.droplet);
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Objects.hashCode(this.newProcesses);
        h += (h << 5) + Objects.hashCode(this.previousDroplet);
        h += (h << 5) + Objects.hashCode(this.relationships);
        h += (h << 5) + Objects.hashCode(this.revision);
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + Objects.hashCode(this.status);
        return h;
    }

    public String toString() {
        return "CreateDeploymentResponse{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", application=" + this.application + ", droplet=" + this.droplet + ", metadata=" + this.metadata + ", newProcesses=" + this.newProcesses + ", previousDroplet=" + this.previousDroplet + ", relationships=" + this.relationships + ", revision=" + this.revision + ", state=" + (Object)((Object)this.state) + ", status=" + this.status + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateDeploymentResponse fromJson(Json json) {
        Builder builder = CreateDeploymentResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.application != null) {
            builder.application(json.application);
        }
        if (json.droplet != null) {
            builder.droplet(json.droplet);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.newProcesses != null) {
            builder.addAllNewProcesses(json.newProcesses);
        }
        if (json.previousDroplet != null) {
            builder.previousDroplet(json.previousDroplet);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_CreateDeploymentResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_STATE = 4L;
        private long initBits = 7L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private ToOneRelationship application;
        private Relationship droplet;
        private Metadata metadata;
        private List<Process> newProcesses = null;
        private Relationship previousDroplet;
        private DeploymentRelationships relationships;
        private Revision revision;
        private DeploymentState state;
        private Status status;

        private Builder() {
        }

        public final Builder from(Deployment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CreateDeploymentResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_CreateDeploymentResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof Deployment) {
                Status statusValue;
                Relationship previousDropletValue;
                List<Process> newProcessesValue;
                ToOneRelationship applicationValue;
                Relationship dropletValue;
                Metadata metadataValue;
                instance = (Deployment)object;
                DeploymentRelationships relationshipsValue = ((Deployment)instance).getRelationships();
                if (relationshipsValue != null) {
                    this.relationships(relationshipsValue);
                }
                if ((metadataValue = ((Deployment)instance).getMetadata()) != null) {
                    this.metadata(metadataValue);
                }
                if ((dropletValue = ((Deployment)instance).getDroplet()) != null) {
                    this.droplet(dropletValue);
                }
                if ((applicationValue = ((Deployment)instance).getApplication()) != null) {
                    this.application(applicationValue);
                }
                if ((newProcessesValue = ((Deployment)instance).getNewProcesses()) != null) {
                    this.addAllNewProcesses(newProcessesValue);
                }
                this.state(((Deployment)instance).getState());
                Revision revisionValue = ((Deployment)instance).getRevision();
                if (revisionValue != null) {
                    this.revision(revisionValue);
                }
                if ((previousDropletValue = ((Deployment)instance).getPreviousDroplet()) != null) {
                    this.previousDroplet(previousDropletValue);
                }
                if ((statusValue = ((Deployment)instance).getStatus()) != null) {
                    this.status(statusValue);
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="app")
        public final Builder application(@Nullable ToOneRelationship application) {
            this.application = application;
            return this;
        }

        @JsonProperty(value="droplet")
        public final Builder droplet(@Nullable Relationship droplet) {
            this.droplet = droplet;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Builder newProcesse(Process element) {
            if (this.newProcesses == null) {
                this.newProcesses = new ArrayList<Process>();
            }
            this.newProcesses.add(Objects.requireNonNull(element, "newProcesses element"));
            return this;
        }

        public final Builder newProcesses(Process ... elements) {
            if (this.newProcesses == null) {
                this.newProcesses = new ArrayList<Process>();
            }
            for (Process element : elements) {
                this.newProcesses.add(Objects.requireNonNull(element, "newProcesses element"));
            }
            return this;
        }

        @JsonProperty(value="new_processes")
        public final Builder newProcesses(@Nullable Iterable<? extends Process> elements) {
            if (elements == null) {
                this.newProcesses = null;
                return this;
            }
            this.newProcesses = new ArrayList<Process>();
            return this.addAllNewProcesses(elements);
        }

        public final Builder addAllNewProcesses(Iterable<? extends Process> elements) {
            Objects.requireNonNull(elements, "newProcesses element");
            if (this.newProcesses == null) {
                this.newProcesses = new ArrayList<Process>();
            }
            for (Process process : elements) {
                this.newProcesses.add(Objects.requireNonNull(process, "newProcesses element"));
            }
            return this;
        }

        @JsonProperty(value="previous_droplet")
        public final Builder previousDroplet(@Nullable Relationship previousDroplet) {
            this.previousDroplet = previousDroplet;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(@Nullable DeploymentRelationships relationships) {
            this.relationships = relationships;
            return this;
        }

        @JsonProperty(value="revision")
        public final Builder revision(@Nullable Revision revision) {
            this.revision = revision;
            return this;
        }

        @JsonProperty(value="state")
        @Deprecated
        public final Builder state(DeploymentState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(@Nullable Status status) {
            this.status = status;
            return this;
        }

        public CreateDeploymentResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateDeploymentResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build CreateDeploymentResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateDeploymentResponse", generator="Immutables")
    static final class Json
    extends _CreateDeploymentResponse {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        ToOneRelationship application;
        Relationship droplet;
        Metadata metadata;
        List<Process> newProcesses = null;
        Relationship previousDroplet;
        DeploymentRelationships relationships;
        Revision revision;
        DeploymentState state;
        Status status;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="app")
        public void setApplication(@Nullable ToOneRelationship application) {
            this.application = application;
        }

        @JsonProperty(value="droplet")
        public void setDroplet(@Nullable Relationship droplet) {
            this.droplet = droplet;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="new_processes")
        public void setNewProcesses(@Nullable List<Process> newProcesses) {
            this.newProcesses = newProcesses;
        }

        @JsonProperty(value="previous_droplet")
        public void setPreviousDroplet(@Nullable Relationship previousDroplet) {
            this.previousDroplet = previousDroplet;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(@Nullable DeploymentRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="revision")
        public void setRevision(@Nullable Revision revision) {
            this.revision = revision;
        }

        @JsonProperty(value="state")
        public void setState(DeploymentState state) {
            this.state = state;
        }

        @JsonProperty(value="status")
        public void setStatus(@Nullable Status status) {
            this.status = status;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ToOneRelationship getApplication() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Relationship getDroplet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Process> getNewProcesses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Relationship getPreviousDroplet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DeploymentRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Revision getRevision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DeploymentState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Status getStatus() {
            throw new UnsupportedOperationException();
        }
    }
}

