package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The entity representing a service binding schema
 */
@Generated(from = "_ServiceBindingSchema", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceBindingSchema extends org.cloudfoundry.client.v2.serviceplans._ServiceBindingSchema {
  private final Schema create;

  private ServiceBindingSchema(ServiceBindingSchema.Builder builder) {
    this.create = builder.create;
  }

  /**
   * The create schema
   */
  @JsonProperty("create")
  @Override
  public Schema getCreate() {
    return create;
  }

  /**
   * This instance is equal to all instances of {@code ServiceBindingSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceBindingSchema
        && equalTo((ServiceBindingSchema) another);
  }

  private boolean equalTo(ServiceBindingSchema another) {
    return create.equals(another.create);
  }

  /**
   * Computes a hash code from attributes: {@code create}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + create.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceBindingSchema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceBindingSchema{"
        + "create=" + create
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceBindingSchema", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceplans._ServiceBindingSchema {
    Schema create;
    @JsonProperty("create")
    public void setCreate(Schema create) {
      this.create = create;
    }
    @Override
    public Schema getCreate() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceBindingSchema fromJson(Json json) {
    ServiceBindingSchema.Builder builder = ServiceBindingSchema.builder();
    if (json.create != null) {
      builder.create(json.create);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceBindingSchema ServiceBindingSchema}.
   * <pre>
   * ServiceBindingSchema.builder()
   *    .create(org.cloudfoundry.client.v2.serviceplans.Schema) // required {@link ServiceBindingSchema#getCreate() create}
   *    .build();
   * </pre>
   * @return A new ServiceBindingSchema builder
   */
  public static ServiceBindingSchema.Builder builder() {
    return new ServiceBindingSchema.Builder();
  }

  /**
   * Builds instances of type {@link ServiceBindingSchema ServiceBindingSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceBindingSchema", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATE = 0x1L;
    private long initBits = 0x1L;

    private Schema create;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceBindingSchema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBindingSchema instance) {
      return from((_ServiceBindingSchema) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceBindingSchema} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceBindingSchema instance) {
      Objects.requireNonNull(instance, "instance");
      create(instance.getCreate());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBindingSchema#getCreate() create} attribute.
     * @param create The value for create 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("create")
    public final Builder create(Schema create) {
      this.create = Objects.requireNonNull(create, "create");
      initBits &= ~INIT_BIT_CREATE;
      return this;
    }

    /**
     * Builds a new {@link ServiceBindingSchema ServiceBindingSchema}.
     * @return An immutable instance of ServiceBindingSchema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceBindingSchema build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceBindingSchema(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATE) != 0) attributes.add("create");
      return "Cannot build ServiceBindingSchema, some of required attributes are not set " + attributes;
    }
  }
}
