package org.cloudfoundry.client.v3.auditevents;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Audit Event operation
 */
@Generated(from = "_GetAuditEventResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetAuditEventResponse extends org.cloudfoundry.client.v3.auditevents._GetAuditEventResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final @Nullable AuditEventActor auditEventActor;
  private final @Nullable AuditEventTarget auditEventTarget;
  private final @Nullable Map<String, Object> data;
  private final @Nullable Relationship organizationRelationship;
  private final @Nullable Relationship spaceRelationship;
  private final @Nullable String type;

  private GetAuditEventResponse(GetAuditEventResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.auditEventActor = builder.auditEventActor;
    this.auditEventTarget = builder.auditEventTarget;
    this.data = builder.data == null ? null : createUnmodifiableMap(false, false, builder.data);
    this.organizationRelationship = builder.organizationRelationship;
    this.spaceRelationship = builder.spaceRelationship;
    this.type = builder.type;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The event actor
   */
  @JsonProperty("actor")
  @Override
  public @Nullable AuditEventActor getAuditEventActor() {
    return auditEventActor;
  }

  /**
   * The event target
   */
  @JsonProperty("target")
  @Override
  public @Nullable AuditEventTarget getAuditEventTarget() {
    return auditEventTarget;
  }

  /**
   * Additional information about event
   */
  @JsonProperty("data")
  @Override
  public @Nullable Map<String, Object> getData() {
    return data;
  }

  /**
   * The organization where the event occurred
   */
  @JsonProperty("organization")
  @Override
  public @Nullable Relationship getOrganizationRelationship() {
    return organizationRelationship;
  }

  /**
   * The space where the event occurred.
   */
  @JsonProperty("space")
  @Override
  public @Nullable Relationship getSpaceRelationship() {
    return spaceRelationship;
  }

  /**
   * The event type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code GetAuditEventResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetAuditEventResponse
        && equalTo((GetAuditEventResponse) another);
  }

  private boolean equalTo(GetAuditEventResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(auditEventActor, another.auditEventActor)
        && Objects.equals(auditEventTarget, another.auditEventTarget)
        && Objects.equals(data, another.data)
        && Objects.equals(organizationRelationship, another.organizationRelationship)
        && Objects.equals(spaceRelationship, another.spaceRelationship)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code auditEventActor}, {@code auditEventTarget}, {@code data}, {@code organizationRelationship}, {@code spaceRelationship}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(auditEventActor);
    h += (h << 5) + Objects.hashCode(auditEventTarget);
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + Objects.hashCode(organizationRelationship);
    h += (h << 5) + Objects.hashCode(spaceRelationship);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code GetAuditEventResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetAuditEventResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", auditEventActor=" + auditEventActor
        + ", auditEventTarget=" + auditEventTarget
        + ", data=" + data
        + ", organizationRelationship=" + organizationRelationship
        + ", spaceRelationship=" + spaceRelationship
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetAuditEventResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.auditevents._GetAuditEventResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    AuditEventActor auditEventActor;
    AuditEventTarget auditEventTarget;
    Map<String, Object> data = null;
    Relationship organizationRelationship;
    Relationship spaceRelationship;
    String type;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("actor")
    public void setAuditEventActor(@Nullable AuditEventActor auditEventActor) {
      this.auditEventActor = auditEventActor;
    }
    @JsonProperty("target")
    public void setAuditEventTarget(@Nullable AuditEventTarget auditEventTarget) {
      this.auditEventTarget = auditEventTarget;
    }
    @JsonProperty("data")
    public void setData(@Nullable Map<String, Object> data) {
      this.data = data;
    }
    @JsonProperty("organization")
    public void setOrganizationRelationship(@Nullable Relationship organizationRelationship) {
      this.organizationRelationship = organizationRelationship;
    }
    @JsonProperty("space")
    public void setSpaceRelationship(@Nullable Relationship spaceRelationship) {
      this.spaceRelationship = spaceRelationship;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public AuditEventActor getAuditEventActor() { throw new UnsupportedOperationException(); }
    @Override
    public AuditEventTarget getAuditEventTarget() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getData() { throw new UnsupportedOperationException(); }
    @Override
    public Relationship getOrganizationRelationship() { throw new UnsupportedOperationException(); }
    @Override
    public Relationship getSpaceRelationship() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetAuditEventResponse fromJson(Json json) {
    GetAuditEventResponse.Builder builder = GetAuditEventResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.auditEventActor != null) {
      builder.auditEventActor(json.auditEventActor);
    }
    if (json.auditEventTarget != null) {
      builder.auditEventTarget(json.auditEventTarget);
    }
    if (json.data != null) {
      builder.putAllData(json.data);
    }
    if (json.organizationRelationship != null) {
      builder.organizationRelationship(json.organizationRelationship);
    }
    if (json.spaceRelationship != null) {
      builder.spaceRelationship(json.spaceRelationship);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetAuditEventResponse GetAuditEventResponse}.
   * <pre>
   * GetAuditEventResponse.builder()
   *    .createdAt(String) // required {@link GetAuditEventResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetAuditEventResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link GetAuditEventResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetAuditEventResponse#getUpdatedAt() updatedAt}
   *    .auditEventActor(org.cloudfoundry.client.v3.auditevents.AuditEventActor | null) // nullable {@link GetAuditEventResponse#getAuditEventActor() auditEventActor}
   *    .auditEventTarget(org.cloudfoundry.client.v3.auditevents.AuditEventTarget | null) // nullable {@link GetAuditEventResponse#getAuditEventTarget() auditEventTarget}
   *    .data(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link GetAuditEventResponse#getData() data}
   *    .organizationRelationship(org.cloudfoundry.client.v3.Relationship | null) // nullable {@link GetAuditEventResponse#getOrganizationRelationship() organizationRelationship}
   *    .spaceRelationship(org.cloudfoundry.client.v3.Relationship | null) // nullable {@link GetAuditEventResponse#getSpaceRelationship() spaceRelationship}
   *    .type(String | null) // nullable {@link GetAuditEventResponse#getType() type}
   *    .build();
   * </pre>
   * @return A new GetAuditEventResponse builder
   */
  public static GetAuditEventResponse.Builder builder() {
    return new GetAuditEventResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetAuditEventResponse GetAuditEventResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetAuditEventResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private long initBits = 0x3L;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private AuditEventActor auditEventActor;
    private AuditEventTarget auditEventTarget;
    private Map<String, Object> data = null;
    private Relationship organizationRelationship;
    private Relationship spaceRelationship;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.auditevents.AuditEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuditEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetAuditEventResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetAuditEventResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetAuditEventResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetAuditEventResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AuditEvent) {
        AuditEvent instance = (AuditEvent) object;
        Relationship organizationRelationshipValue = instance.getOrganizationRelationship();
        if (organizationRelationshipValue != null) {
          organizationRelationship(organizationRelationshipValue);
        }
        AuditEventTarget auditEventTargetValue = instance.getAuditEventTarget();
        if (auditEventTargetValue != null) {
          auditEventTarget(auditEventTargetValue);
        }
        AuditEventActor auditEventActorValue = instance.getAuditEventActor();
        if (auditEventActorValue != null) {
          auditEventActor(auditEventActorValue);
        }
        Map<String, Object> dataValue = instance.getData();
        if (dataValue != null) {
          putAllData(dataValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        Relationship spaceRelationshipValue = instance.getSpaceRelationship();
        if (spaceRelationshipValue != null) {
          spaceRelationship(spaceRelationshipValue);
        }
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link GetAuditEventResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAuditEventResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetAuditEventResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetAuditEventResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetAuditEventResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetAuditEventResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetAuditEventResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAuditEventResponse#getAuditEventActor() auditEventActor} attribute.
     * @param auditEventActor The value for auditEventActor (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actor")
    public final Builder auditEventActor(@Nullable AuditEventActor auditEventActor) {
      this.auditEventActor = auditEventActor;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAuditEventResponse#getAuditEventTarget() auditEventTarget} attribute.
     * @param auditEventTarget The value for auditEventTarget (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("target")
    public final Builder auditEventTarget(@Nullable AuditEventTarget auditEventTarget) {
      this.auditEventTarget = auditEventTarget;
      return this;
    }

    /**
     * Put one entry to the {@link GetAuditEventResponse#getData() data} map.
     * @param key The key in the data map
     * @param value The associated value in the data map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(String key, Object value) {
      if (this.data == null) {
        this.data = new LinkedHashMap<String, Object>();
      }
      this.data.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetAuditEventResponse#getData() data} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Map.Entry<String, ? extends Object> entry) {
      if (this.data == null) {
        this.data = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.data.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetAuditEventResponse#getData() data} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the data map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.data = null;
        return this;
      }
      this.data = new LinkedHashMap<String, Object>();
      return putAllData(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetAuditEventResponse#getData() data} map. Nulls are not permitted
     * @param entries The entries that will be added to the data map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllData(Map<String, ? extends Object> entries) {
      if (this.data == null) {
        this.data = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.data.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetAuditEventResponse#getOrganizationRelationship() organizationRelationship} attribute.
     * @param organizationRelationship The value for organizationRelationship (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization")
    public final Builder organizationRelationship(@Nullable Relationship organizationRelationship) {
      this.organizationRelationship = organizationRelationship;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAuditEventResponse#getSpaceRelationship() spaceRelationship} attribute.
     * @param spaceRelationship The value for spaceRelationship (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space")
    public final Builder spaceRelationship(@Nullable Relationship spaceRelationship) {
      this.spaceRelationship = spaceRelationship;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAuditEventResponse#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link GetAuditEventResponse GetAuditEventResponse}.
     * @return An immutable instance of GetAuditEventResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetAuditEventResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetAuditEventResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build GetAuditEventResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
