package org.cloudfoundry.uaa;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The metadata payload entities
 */
@Generated(from = "_Metadata", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Metadata extends org.cloudfoundry.uaa._Metadata {
  private final @Nullable String created;
  private final @Nullable String lastModified;
  private final @Nullable Integer version;

  private Metadata(Metadata.Builder builder) {
    this.created = builder.created;
    this.lastModified = builder.lastModified;
    this.version = builder.version;
  }

  /**
   * When the resource record was created
   */
  @JsonProperty("created")
  @Override
  public @Nullable String getCreated() {
    return created;
  }

  /**
   * When the resource record was last modified
   */
  @JsonProperty("lastModified")
  @Override
  public @Nullable String getLastModified() {
    return lastModified;
  }

  /**
   * The metadata version
   */
  @JsonProperty("version")
  @Override
  public @Nullable Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code Metadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Metadata
        && equalTo((Metadata) another);
  }

  private boolean equalTo(Metadata another) {
    return Objects.equals(created, another.created)
        && Objects.equals(lastModified, another.lastModified)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code created}, {@code lastModified}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(lastModified);
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code Metadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Metadata{"
        + "created=" + created
        + ", lastModified=" + lastModified
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Metadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa._Metadata {
    String created;
    String lastModified;
    Integer version;
    @JsonProperty("created")
    public void setCreated(@Nullable String created) {
      this.created = created;
    }
    @JsonProperty("lastModified")
    public void setLastModified(@Nullable String lastModified) {
      this.lastModified = lastModified;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable Integer version) {
      this.version = version;
    }
    @Override
    public String getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public String getLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Metadata fromJson(Json json) {
    Metadata.Builder builder = Metadata.builder();
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Metadata Metadata}.
   * <pre>
   * Metadata.builder()
   *    .created(String | null) // nullable {@link Metadata#getCreated() created}
   *    .lastModified(String | null) // nullable {@link Metadata#getLastModified() lastModified}
   *    .version(Integer | null) // nullable {@link Metadata#getVersion() version}
   *    .build();
   * </pre>
   * @return A new Metadata builder
   */
  public static Metadata.Builder builder() {
    return new Metadata.Builder();
  }

  /**
   * Builds instances of type {@link Metadata Metadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Metadata", generator = "Immutables")
  public static final class Builder {
    private String created;
    private String lastModified;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Metadata instance) {
      return from((_Metadata) instance);
    }

    /**
     * Copy abstract value type {@code _Metadata} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Metadata instance) {
      Objects.requireNonNull(instance, "instance");
      String createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      String lastModifiedValue = instance.getLastModified();
      if (lastModifiedValue != null) {
        lastModified(lastModifiedValue);
      }
      Integer versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(@Nullable String created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastModified")
    public final Builder lastModified(@Nullable String lastModified) {
      this.lastModified = lastModified;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable Integer version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link Metadata Metadata}.
     * @return An immutable instance of Metadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Metadata build() {
      return new Metadata(this);
    }
  }
}
