package org.cloudfoundry.uaa.authorizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for authorize by open id with an id token operation
 */
@Generated(from = "_AuthorizeByOpenIdWithAuthorizationCodeGrantRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AuthorizeByOpenIdWithAuthorizationCodeGrantRequest
    extends org.cloudfoundry.uaa.authorizations._AuthorizeByOpenIdWithAuthorizationCodeGrantRequest {
  private final String clientId;
  private final @Nullable String redirectUri;
  private final @Nullable List<String> scopes;
  private final @Nullable String loginHint;

  private AuthorizeByOpenIdWithAuthorizationCodeGrantRequest(AuthorizeByOpenIdWithAuthorizationCodeGrantRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.redirectUri = builder.redirectUri;
    this.scopes = builder.scopes == null ? null : createUnmodifiableList(true, builder.scopes);
    this.loginHint = builder.loginHint;
  }

  /**
   * A unique string representing the registration information provided by the client
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * Redirection URI to which the authorization server will send the user-agent back once access is granted (or denied), optional if pre-registered by the client
   */
  @Override
  public @Nullable String getRedirectUri() {
    return redirectUri;
  }

  /**
   * requested scopes, space-delimited
   */
  @Override
  public @Nullable List<String> getScopes() {
    return scopes;
  }

  /**
   * The login hint
   */
  @Override
  public @Nullable String getLoginHint() {
    return loginHint;
  }

  /**
   * This instance is equal to all instances of {@code AuthorizeByOpenIdWithAuthorizationCodeGrantRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AuthorizeByOpenIdWithAuthorizationCodeGrantRequest
        && equalTo((AuthorizeByOpenIdWithAuthorizationCodeGrantRequest) another);
  }

  private boolean equalTo(AuthorizeByOpenIdWithAuthorizationCodeGrantRequest another) {
    return clientId.equals(another.clientId)
        && Objects.equals(redirectUri, another.redirectUri)
        && Objects.equals(scopes, another.scopes)
        && Objects.equals(loginHint, another.loginHint);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code redirectUri}, {@code scopes}, {@code loginHint}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(redirectUri);
    h += (h << 5) + Objects.hashCode(scopes);
    h += (h << 5) + Objects.hashCode(loginHint);
    return h;
  }

  /**
   * Prints the immutable value {@code AuthorizeByOpenIdWithAuthorizationCodeGrantRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuthorizeByOpenIdWithAuthorizationCodeGrantRequest{"
        + "clientId=" + clientId
        + ", redirectUri=" + redirectUri
        + ", scopes=" + scopes
        + ", loginHint=" + loginHint
        + "}";
  }

  /**
   * Creates a builder for {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest AuthorizeByOpenIdWithAuthorizationCodeGrantRequest}.
   * <pre>
   * AuthorizeByOpenIdWithAuthorizationCodeGrantRequest.builder()
   *    .clientId(String) // required {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getClientId() clientId}
   *    .redirectUri(String | null) // nullable {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getRedirectUri() redirectUri}
   *    .scopes(List&amp;lt;String&amp;gt; | null) // nullable {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getScopes() scopes}
   *    .loginHint(String | null) // nullable {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getLoginHint() loginHint}
   *    .build();
   * </pre>
   * @return A new AuthorizeByOpenIdWithAuthorizationCodeGrantRequest builder
   */
  public static AuthorizeByOpenIdWithAuthorizationCodeGrantRequest.Builder builder() {
    return new AuthorizeByOpenIdWithAuthorizationCodeGrantRequest.Builder();
  }

  /**
   * Builds instances of type {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest AuthorizeByOpenIdWithAuthorizationCodeGrantRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AuthorizeByOpenIdWithAuthorizationCodeGrantRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String clientId;
    private String redirectUri;
    private List<String> scopes = null;
    private String loginHint;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.authorizations.AbstractAuthorizationRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractAuthorizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuthorizeByOpenIdWithAuthorizationCodeGrantRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuthorizeByOpenIdWithAuthorizationCodeGrantRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _AuthorizeByOpenIdWithAuthorizationCodeGrantRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_AuthorizeByOpenIdWithAuthorizationCodeGrantRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractAuthorizationRequest) {
        AbstractAuthorizationRequest instance = (AbstractAuthorizationRequest) object;
        String redirectUriValue = instance.getRedirectUri();
        if (redirectUriValue != null) {
          redirectUri(redirectUriValue);
        }
        clientId(instance.getClientId());
        List<String> scopesValue = instance.getScopes();
        if (scopesValue != null) {
          addAllScopes(scopesValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.authorizations._AuthorizeByOpenIdWithAuthorizationCodeGrantRequest) {
        org.cloudfoundry.uaa.authorizations._AuthorizeByOpenIdWithAuthorizationCodeGrantRequest instance = (org.cloudfoundry.uaa.authorizations._AuthorizeByOpenIdWithAuthorizationCodeGrantRequest) object;
        String loginHintValue = instance.getLoginHint();
        if (loginHintValue != null) {
          loginHint(loginHintValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getRedirectUri() redirectUri} attribute.
     * @param redirectUri The value for redirectUri (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUri(@Nullable String redirectUri) {
      this.redirectUri = redirectUri;
      return this;
    }

    /**
     * Adds one element to {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(String... elements) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.scopes = null;
        return this;
      }
      this.scopes = new ArrayList<String>();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "scopes element");
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest#getLoginHint() loginHint} attribute.
     * @param loginHint The value for loginHint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder loginHint(@Nullable String loginHint) {
      this.loginHint = loginHint;
      return this;
    }

    /**
     * Builds a new {@link AuthorizeByOpenIdWithAuthorizationCodeGrantRequest AuthorizeByOpenIdWithAuthorizationCodeGrantRequest}.
     * @return An immutable instance of AuthorizeByOpenIdWithAuthorizationCodeGrantRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AuthorizeByOpenIdWithAuthorizationCodeGrantRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AuthorizeByOpenIdWithAuthorizationCodeGrantRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build AuthorizeByOpenIdWithAuthorizationCodeGrantRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
