package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityproviders.Type;
import org.immutables.value.Generated;

/**
 * The payload for the Multi-factor Authentication configuration
 */
@Generated(from = "_MfaConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class MfaConfig extends org.cloudfoundry.uaa.identityzones._MfaConfig {
  private final @Nullable Boolean enabled;
  private final @Nullable List<Type> identityProviders;
  private final @Nullable String providerName;

  private MfaConfig(MfaConfig.Builder builder) {
    this.enabled = builder.enabled;
    this.identityProviders = builder.identityProviders == null ? null : createUnmodifiableList(true, builder.identityProviders);
    this.providerName = builder.providerName;
  }

  /**
   * Whether Multi-factor Authentication is enabled
   */
  @JsonProperty("enabled")
  @Override
  public @Nullable Boolean getEnabled() {
    return enabled;
  }

  /**
   * The identity providers
   */
  @JsonProperty("identityProviders")
  @Override
  public @Nullable List<Type> getIdentityProviders() {
    return identityProviders;
  }

  /**
   * The XHR configuration
   */
  @JsonProperty("providerName")
  @Override
  public @Nullable String getProviderName() {
    return providerName;
  }

  /**
   * This instance is equal to all instances of {@code MfaConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MfaConfig
        && equalTo((MfaConfig) another);
  }

  private boolean equalTo(MfaConfig another) {
    return Objects.equals(enabled, another.enabled)
        && Objects.equals(identityProviders, another.identityProviders)
        && Objects.equals(providerName, another.providerName);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code identityProviders}, {@code providerName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(identityProviders);
    h += (h << 5) + Objects.hashCode(providerName);
    return h;
  }

  /**
   * Prints the immutable value {@code MfaConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MfaConfig{"
        + "enabled=" + enabled
        + ", identityProviders=" + identityProviders
        + ", providerName=" + providerName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_MfaConfig", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._MfaConfig {
    Boolean enabled;
    List<Type> identityProviders = null;
    String providerName;
    @JsonProperty("enabled")
    public void setEnabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
    }
    @JsonProperty("identityProviders")
    public void setIdentityProviders(@Nullable List<Type> identityProviders) {
      this.identityProviders = identityProviders;
    }
    @JsonProperty("providerName")
    public void setProviderName(@Nullable String providerName) {
      this.providerName = providerName;
    }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public List<Type> getIdentityProviders() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static MfaConfig fromJson(Json json) {
    MfaConfig.Builder builder = MfaConfig.builder();
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    if (json.identityProviders != null) {
      builder.addAllIdentityProviders(json.identityProviders);
    }
    if (json.providerName != null) {
      builder.providerName(json.providerName);
    }
    return builder.build();
  }

  private static MfaConfig validate(MfaConfig instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link MfaConfig MfaConfig}.
   * <pre>
   * MfaConfig.builder()
   *    .enabled(Boolean | null) // nullable {@link MfaConfig#getEnabled() enabled}
   *    .identityProviders(List&amp;lt;org.cloudfoundry.uaa.identityproviders.Type&amp;gt; | null) // nullable {@link MfaConfig#getIdentityProviders() identityProviders}
   *    .providerName(String | null) // nullable {@link MfaConfig#getProviderName() providerName}
   *    .build();
   * </pre>
   * @return A new MfaConfig builder
   */
  public static MfaConfig.Builder builder() {
    return new MfaConfig.Builder();
  }

  /**
   * Builds instances of type {@link MfaConfig MfaConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_MfaConfig", generator = "Immutables")
  public static final class Builder {
    private Boolean enabled;
    private List<Type> identityProviders = null;
    private String providerName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MfaConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MfaConfig instance) {
      return from((_MfaConfig) instance);
    }

    /**
     * Copy abstract value type {@code _MfaConfig} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_MfaConfig instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean enabledValue = instance.getEnabled();
      if (enabledValue != null) {
        enabled(enabledValue);
      }
      List<Type> identityProvidersValue = instance.getIdentityProviders();
      if (identityProvidersValue != null) {
        addAllIdentityProviders(identityProvidersValue);
      }
      String providerNameValue = instance.getProviderName();
      if (providerNameValue != null) {
        providerName(providerNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MfaConfig#getEnabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("enabled")
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Adds one element to {@link MfaConfig#getIdentityProviders() identityProviders} list.
     * @param element A identityProviders element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProvider(Type element) {
      if (this.identityProviders == null) {
        this.identityProviders = new ArrayList<Type>();
      }
      this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
      return this;
    }

    /**
     * Adds elements to {@link MfaConfig#getIdentityProviders() identityProviders} list.
     * @param elements An array of identityProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProviders(Type... elements) {
      if (this.identityProviders == null) {
        this.identityProviders = new ArrayList<Type>();
      }
      for (Type element : elements) {
        this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MfaConfig#getIdentityProviders() identityProviders} list.
     * @param elements An iterable of identityProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("identityProviders")
    public final Builder identityProviders(@Nullable Iterable<? extends Type> elements) {
      if (elements == null) {
        this.identityProviders = null;
        return this;
      }
      this.identityProviders = new ArrayList<Type>();
      return addAllIdentityProviders(elements);
    }

    /**
     * Adds elements to {@link MfaConfig#getIdentityProviders() identityProviders} list.
     * @param elements An iterable of identityProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIdentityProviders(Iterable<? extends Type> elements) {
      Objects.requireNonNull(elements, "identityProviders element");
      if (this.identityProviders == null) {
        this.identityProviders = new ArrayList<Type>();
      }
      for (Type element : elements) {
        this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MfaConfig#getProviderName() providerName} attribute.
     * @param providerName The value for providerName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("providerName")
    public final Builder providerName(@Nullable String providerName) {
      this.providerName = providerName;
      return this;
    }

    /**
     * Builds a new {@link MfaConfig MfaConfig}.
     * @return An immutable instance of MfaConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MfaConfig build() {
      return MfaConfig.validate(new MfaConfig(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
