/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.networking.v1.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.networking.v1.policies._ListPoliciesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListPoliciesRequest", generator="Immutables")
public final class ListPoliciesRequest
extends _ListPoliciesRequest {
    @Nullable
    private final List<String> policyGroupIds;

    private ListPoliciesRequest(Builder builder) {
        this.policyGroupIds = builder.policyGroupIds == null ? null : ListPoliciesRequest.createUnmodifiableList(true, builder.policyGroupIds);
    }

    @Override
    @Nullable
    public List<String> getPolicyGroupIds() {
        return this.policyGroupIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListPoliciesRequest && this.equalTo((ListPoliciesRequest)another);
    }

    private boolean equalTo(ListPoliciesRequest another) {
        return Objects.equals(this.policyGroupIds, another.policyGroupIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.policyGroupIds);
        return h;
    }

    public String toString() {
        return "ListPoliciesRequest{policyGroupIds=" + this.policyGroupIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListPoliciesRequest", generator="Immutables")
    public static final class Builder {
        private List<String> policyGroupIds = null;

        private Builder() {
        }

        public final Builder from(ListPoliciesRequest instance) {
            return this.from((_ListPoliciesRequest)instance);
        }

        final Builder from(_ListPoliciesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            List<String> policyGroupIdsValue = instance.getPolicyGroupIds();
            if (policyGroupIdsValue != null) {
                this.addAllPolicyGroupIds(policyGroupIdsValue);
            }
            return this;
        }

        public final Builder policyGroupId(String element) {
            if (this.policyGroupIds == null) {
                this.policyGroupIds = new ArrayList<String>();
            }
            this.policyGroupIds.add(Objects.requireNonNull(element, "policyGroupIds element"));
            return this;
        }

        public final Builder policyGroupIds(String ... elements) {
            if (this.policyGroupIds == null) {
                this.policyGroupIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.policyGroupIds.add(Objects.requireNonNull(element, "policyGroupIds element"));
            }
            return this;
        }

        public final Builder policyGroupIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.policyGroupIds = null;
                return this;
            }
            this.policyGroupIds = new ArrayList<String>();
            return this.addAllPolicyGroupIds(elements);
        }

        public final Builder addAllPolicyGroupIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "policyGroupIds element");
            if (this.policyGroupIds == null) {
                this.policyGroupIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.policyGroupIds.add(Objects.requireNonNull(element, "policyGroupIds element"));
            }
            return this;
        }

        public ListPoliciesRequest build() {
            return new ListPoliciesRequest(this);
        }
    }
}

