package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Create Service Binding request
 */
@Generated(from = "_ServiceBindingRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceBindingRelationships
    extends org.cloudfoundry.client.v3.servicebindings._ServiceBindingRelationships {
  private final Relationship application;
  private final Relationship serviceInstance;

  private ServiceBindingRelationships(ServiceBindingRelationships.Builder builder) {
    this.application = builder.application;
    this.serviceInstance = builder.serviceInstance;
  }

  /**
   * The application relationship
   */
  @Override
  public Relationship getApplication() {
    return application;
  }

  /**
   * The service instance relationship
   */
  @Override
  public Relationship getServiceInstance() {
    return serviceInstance;
  }

  /**
   * This instance is equal to all instances of {@code ServiceBindingRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceBindingRelationships
        && equalTo((ServiceBindingRelationships) another);
  }

  private boolean equalTo(ServiceBindingRelationships another) {
    return application.equals(another.application)
        && serviceInstance.equals(another.serviceInstance);
  }

  /**
   * Computes a hash code from attributes: {@code application}, {@code serviceInstance}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + application.hashCode();
    h += (h << 5) + serviceInstance.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceBindingRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceBindingRelationships{"
        + "application=" + application
        + ", serviceInstance=" + serviceInstance
        + "}";
  }

  /**
   * Creates a builder for {@link ServiceBindingRelationships ServiceBindingRelationships}.
   * <pre>
   * ServiceBindingRelationships.builder()
   *    .application(org.cloudfoundry.client.v3.Relationship) // required {@link ServiceBindingRelationships#getApplication() application}
   *    .serviceInstance(org.cloudfoundry.client.v3.Relationship) // required {@link ServiceBindingRelationships#getServiceInstance() serviceInstance}
   *    .build();
   * </pre>
   * @return A new ServiceBindingRelationships builder
   */
  public static ServiceBindingRelationships.Builder builder() {
    return new ServiceBindingRelationships.Builder();
  }

  /**
   * Builds instances of type {@link ServiceBindingRelationships ServiceBindingRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceBindingRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE = 0x2L;
    private long initBits = 0x3L;

    private Relationship application;
    private Relationship serviceInstance;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceBindingRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBindingRelationships instance) {
      return from((_ServiceBindingRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceBindingRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceBindingRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      application(instance.getApplication());
      serviceInstance(instance.getServiceInstance());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBindingRelationships#getApplication() application} attribute.
     * @param application The value for application 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(Relationship application) {
      this.application = Objects.requireNonNull(application, "application");
      initBits &= ~INIT_BIT_APPLICATION;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBindingRelationships#getServiceInstance() serviceInstance} attribute.
     * @param serviceInstance The value for serviceInstance 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstance(Relationship serviceInstance) {
      this.serviceInstance = Objects.requireNonNull(serviceInstance, "serviceInstance");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE;
      return this;
    }

    /**
     * Builds a new {@link ServiceBindingRelationships ServiceBindingRelationships}.
     * @return An immutable instance of ServiceBindingRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceBindingRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceBindingRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION) != 0) attributes.add("application");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE) != 0) attributes.add("serviceInstance");
      return "Cannot build ServiceBindingRelationships, some of required attributes are not set " + attributes;
    }
  }
}
