package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload to check a membership of a group
 */
@Generated(from = "_CheckMembershipRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CheckMembershipRequest extends org.cloudfoundry.uaa.groups._CheckMembershipRequest {
  private final String groupId;
  private final String memberId;

  private CheckMembershipRequest(CheckMembershipRequest.Builder builder) {
    this.groupId = builder.groupId;
    this.memberId = builder.memberId;
  }

  /**
   * The group id
   */
  @JsonProperty("groupId")
  @JsonIgnore
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * The member id
   */
  @JsonProperty("memberId")
  @JsonIgnore
  @Override
  public String getMemberId() {
    return memberId;
  }

  /**
   * This instance is equal to all instances of {@code CheckMembershipRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CheckMembershipRequest
        && equalTo((CheckMembershipRequest) another);
  }

  private boolean equalTo(CheckMembershipRequest another) {
    return groupId.equals(another.groupId)
        && memberId.equals(another.memberId);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code memberId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + memberId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckMembershipRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckMembershipRequest{"
        + "groupId=" + groupId
        + ", memberId=" + memberId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CheckMembershipRequest", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._CheckMembershipRequest {
    String groupId;
    String memberId;
    @JsonProperty("groupId")
    @JsonIgnore
    public void setGroupId(String groupId) {
      this.groupId = groupId;
    }
    @JsonProperty("memberId")
    @JsonIgnore
    public void setMemberId(String memberId) {
      this.memberId = memberId;
    }
    @Override
    public String getGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMemberId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CheckMembershipRequest fromJson(Json json) {
    CheckMembershipRequest.Builder builder = CheckMembershipRequest.builder();
    if (json.groupId != null) {
      builder.groupId(json.groupId);
    }
    if (json.memberId != null) {
      builder.memberId(json.memberId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CheckMembershipRequest CheckMembershipRequest}.
   * <pre>
   * CheckMembershipRequest.builder()
   *    .groupId(String) // required {@link CheckMembershipRequest#getGroupId() groupId}
   *    .memberId(String) // required {@link CheckMembershipRequest#getMemberId() memberId}
   *    .build();
   * </pre>
   * @return A new CheckMembershipRequest builder
   */
  public static CheckMembershipRequest.Builder builder() {
    return new CheckMembershipRequest.Builder();
  }

  /**
   * Builds instances of type {@link CheckMembershipRequest CheckMembershipRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CheckMembershipRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_MEMBER_ID = 0x2L;
    private long initBits = 0x3L;

    private String groupId;
    private String memberId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckMembershipRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckMembershipRequest instance) {
      return from((_CheckMembershipRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CheckMembershipRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CheckMembershipRequest instance) {
      Objects.requireNonNull(instance, "instance");
      groupId(instance.getGroupId());
      memberId(instance.getMemberId());
      return this;
    }

    /**
     * Initializes the value for the {@link CheckMembershipRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    @JsonIgnore
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckMembershipRequest#getMemberId() memberId} attribute.
     * @param memberId The value for memberId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memberId")
    @JsonIgnore
    public final Builder memberId(String memberId) {
      this.memberId = Objects.requireNonNull(memberId, "memberId");
      initBits &= ~INIT_BIT_MEMBER_ID;
      return this;
    }

    /**
     * Builds a new {@link CheckMembershipRequest CheckMembershipRequest}.
     * @return An immutable instance of CheckMembershipRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CheckMembershipRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CheckMembershipRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_MEMBER_ID) != 0) attributes.add("memberId");
      return "Cannot build CheckMembershipRequest, some of required attributes are not set " + attributes;
    }
  }
}
