package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response from the verify user request
 */
@Generated(from = "_InviteUsersResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class InviteUsersResponse extends org.cloudfoundry.uaa.users._InviteUsersResponse {
  private final List<Invite> failedInvites;
  private final List<Invite> newInvites;

  private InviteUsersResponse(InviteUsersResponse.Builder builder) {
    this.failedInvites = createUnmodifiableList(true, builder.failedInvites);
    this.newInvites = createUnmodifiableList(true, builder.newInvites);
  }

  /**
   * Failed invites
   */
  @JsonProperty("failed_invites")
  @Override
  public List<Invite> getFailedInvites() {
    return failedInvites;
  }

  /**
   * Successful invites
   */
  @JsonProperty("new_invites")
  @Override
  public List<Invite> getNewInvites() {
    return newInvites;
  }

  /**
   * This instance is equal to all instances of {@code InviteUsersResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InviteUsersResponse
        && equalTo((InviteUsersResponse) another);
  }

  private boolean equalTo(InviteUsersResponse another) {
    return failedInvites.equals(another.failedInvites)
        && newInvites.equals(another.newInvites);
  }

  /**
   * Computes a hash code from attributes: {@code failedInvites}, {@code newInvites}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + failedInvites.hashCode();
    h += (h << 5) + newInvites.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InviteUsersResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InviteUsersResponse{"
        + "failedInvites=" + failedInvites
        + ", newInvites=" + newInvites
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_InviteUsersResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._InviteUsersResponse {
    List<Invite> failedInvites = Collections.emptyList();
    List<Invite> newInvites = Collections.emptyList();
    @JsonProperty("failed_invites")
    public void setFailedInvites(List<Invite> failedInvites) {
      this.failedInvites = failedInvites;
    }
    @JsonProperty("new_invites")
    public void setNewInvites(List<Invite> newInvites) {
      this.newInvites = newInvites;
    }
    @Override
    public List<Invite> getFailedInvites() { throw new UnsupportedOperationException(); }
    @Override
    public List<Invite> getNewInvites() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static InviteUsersResponse fromJson(Json json) {
    InviteUsersResponse.Builder builder = InviteUsersResponse.builder();
    if (json.failedInvites != null) {
      builder.addAllFailedInvites(json.failedInvites);
    }
    if (json.newInvites != null) {
      builder.addAllNewInvites(json.newInvites);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link InviteUsersResponse InviteUsersResponse}.
   * <pre>
   * InviteUsersResponse.builder()
   *    .failedInvite|addAllFailedInvites(Invite) // {@link InviteUsersResponse#getFailedInvites() failedInvites} elements
   *    .newInvite|addAllNewInvites(Invite) // {@link InviteUsersResponse#getNewInvites() newInvites} elements
   *    .build();
   * </pre>
   * @return A new InviteUsersResponse builder
   */
  public static InviteUsersResponse.Builder builder() {
    return new InviteUsersResponse.Builder();
  }

  /**
   * Builds instances of type {@link InviteUsersResponse InviteUsersResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_InviteUsersResponse", generator = "Immutables")
  public static final class Builder {
    private List<Invite> failedInvites = new ArrayList<Invite>();
    private List<Invite> newInvites = new ArrayList<Invite>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InviteUsersResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InviteUsersResponse instance) {
      return from((_InviteUsersResponse) instance);
    }

    /**
     * Copy abstract value type {@code _InviteUsersResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_InviteUsersResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllFailedInvites(instance.getFailedInvites());
      addAllNewInvites(instance.getNewInvites());
      return this;
    }

    /**
     * Adds one element to {@link InviteUsersResponse#getFailedInvites() failedInvites} list.
     * @param element A failedInvites element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder failedInvite(Invite element) {
      this.failedInvites.add(Objects.requireNonNull(element, "failedInvites element"));
      return this;
    }

    /**
     * Adds elements to {@link InviteUsersResponse#getFailedInvites() failedInvites} list.
     * @param elements An array of failedInvites elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder failedInvites(Invite... elements) {
      for (Invite element : elements) {
        this.failedInvites.add(Objects.requireNonNull(element, "failedInvites element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InviteUsersResponse#getFailedInvites() failedInvites} list.
     * @param elements An iterable of failedInvites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("failed_invites")
    public final Builder failedInvites(Iterable<? extends Invite> elements) {
      this.failedInvites.clear();
      return addAllFailedInvites(elements);
    }

    /**
     * Adds elements to {@link InviteUsersResponse#getFailedInvites() failedInvites} list.
     * @param elements An iterable of failedInvites elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFailedInvites(Iterable<? extends Invite> elements) {
      for (Invite element : elements) {
        this.failedInvites.add(Objects.requireNonNull(element, "failedInvites element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link InviteUsersResponse#getNewInvites() newInvites} list.
     * @param element A newInvites element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder newInvite(Invite element) {
      this.newInvites.add(Objects.requireNonNull(element, "newInvites element"));
      return this;
    }

    /**
     * Adds elements to {@link InviteUsersResponse#getNewInvites() newInvites} list.
     * @param elements An array of newInvites elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder newInvites(Invite... elements) {
      for (Invite element : elements) {
        this.newInvites.add(Objects.requireNonNull(element, "newInvites element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InviteUsersResponse#getNewInvites() newInvites} list.
     * @param elements An iterable of newInvites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("new_invites")
    public final Builder newInvites(Iterable<? extends Invite> elements) {
      this.newInvites.clear();
      return addAllNewInvites(elements);
    }

    /**
     * Adds elements to {@link InviteUsersResponse#getNewInvites() newInvites} list.
     * @param elements An iterable of newInvites elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNewInvites(Iterable<? extends Invite> elements) {
      for (Invite element : elements) {
        this.newInvites.add(Objects.requireNonNull(element, "newInvites element"));
      }
      return this;
    }

    /**
     * Builds a new {@link InviteUsersResponse InviteUsersResponse}.
     * @return An immutable instance of InviteUsersResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InviteUsersResponse build() {
      return new InviteUsersResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
