package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for the Space resource
 */
@Generated(from = "_SpaceEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SpaceEntity extends org.cloudfoundry.client.v2.spaces._SpaceEntity {
  private final @Nullable Boolean allowSsh;
  private final @Nullable String applicationEventsUrl;
  private final @Nullable String applicationsUrl;
  private final @Nullable String auditorsUrl;
  private final @Nullable String developersUrl;
  private final @Nullable String domainsUrl;
  private final @Nullable String eventsUrl;
  private final @Nullable String isolationSegmentId;
  private final @Nullable String isolationSegmentUrl;
  private final @Nullable String managersUrl;
  private final @Nullable String name;
  private final @Nullable String organizationId;
  private final @Nullable String organizationUrl;
  private final @Nullable String routesUrl;
  private final @Nullable String securityGroupsUrl;
  private final @Nullable String serviceInstancesUrl;
  private final @Nullable String spaceQuotaDefinitionId;
  private final @Nullable String spaceQuotaDefinitionUrl;
  private final @Nullable String stagingSecurityGroupsUrl;

  private SpaceEntity(SpaceEntity.Builder builder) {
    this.allowSsh = builder.allowSsh;
    this.applicationEventsUrl = builder.applicationEventsUrl;
    this.applicationsUrl = builder.applicationsUrl;
    this.auditorsUrl = builder.auditorsUrl;
    this.developersUrl = builder.developersUrl;
    this.domainsUrl = builder.domainsUrl;
    this.eventsUrl = builder.eventsUrl;
    this.isolationSegmentId = builder.isolationSegmentId;
    this.isolationSegmentUrl = builder.isolationSegmentUrl;
    this.managersUrl = builder.managersUrl;
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.organizationUrl = builder.organizationUrl;
    this.routesUrl = builder.routesUrl;
    this.securityGroupsUrl = builder.securityGroupsUrl;
    this.serviceInstancesUrl = builder.serviceInstancesUrl;
    this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
    this.spaceQuotaDefinitionUrl = builder.spaceQuotaDefinitionUrl;
    this.stagingSecurityGroupsUrl = builder.stagingSecurityGroupsUrl;
  }

  /**
   * Allow SSH
   */
  @JsonProperty("allow_ssh")
  @Override
  public @Nullable Boolean getAllowSsh() {
    return allowSsh;
  }

  /**
   * The application events url
   */
  @JsonProperty("app_events_url")
  @Override
  public @Nullable String getApplicationEventsUrl() {
    return applicationEventsUrl;
  }

  /**
   * The applications url
   */
  @JsonProperty("apps_url")
  @Override
  public @Nullable String getApplicationsUrl() {
    return applicationsUrl;
  }

  /**
   * The auditors url
   */
  @JsonProperty("auditors_url")
  @Override
  public @Nullable String getAuditorsUrl() {
    return auditorsUrl;
  }

  /**
   * The developers url
   */
  @JsonProperty("developers_url")
  @Override
  public @Nullable String getDevelopersUrl() {
    return developersUrl;
  }

  /**
   * The domains url
   */
  @JsonProperty("domains_url")
  @Override
  public @Nullable String getDomainsUrl() {
    return domainsUrl;
  }

  /**
   * The events url
   */
  @JsonProperty("events_url")
  @Override
  public @Nullable String getEventsUrl() {
    return eventsUrl;
  }

  /**
   * The isolation segment id
   */
  @JsonProperty("isolation_segment_guid")
  @Override
  public @Nullable String getIsolationSegmentId() {
    return isolationSegmentId;
  }

  /**
   * The isolation segment url
   */
  @JsonProperty("isolation_segment_url")
  @Override
  public @Nullable String getIsolationSegmentUrl() {
    return isolationSegmentUrl;
  }

  /**
   * The managers url
   */
  @JsonProperty("managers_url")
  @Override
  public @Nullable String getManagersUrl() {
    return managersUrl;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The organization url
   */
  @JsonProperty("organization_url")
  @Override
  public @Nullable String getOrganizationUrl() {
    return organizationUrl;
  }

  /**
   * The routes url
   */
  @JsonProperty("routes_url")
  @Override
  public @Nullable String getRoutesUrl() {
    return routesUrl;
  }

  /**
   * The security groups url
   */
  @JsonProperty("security_groups_url")
  @Override
  public @Nullable String getSecurityGroupsUrl() {
    return securityGroupsUrl;
  }

  /**
   * The service instances url
   */
  @JsonProperty("service_instances_url")
  @Override
  public @Nullable String getServiceInstancesUrl() {
    return serviceInstancesUrl;
  }

  /**
   * The space quota definition id
   */
  @JsonProperty("space_quota_definition_guid")
  @Override
  public @Nullable String getSpaceQuotaDefinitionId() {
    return spaceQuotaDefinitionId;
  }

  /**
   * The space quota definition url
   */
  @JsonProperty("space_quota_definition_url")
  @Override
  public @Nullable String getSpaceQuotaDefinitionUrl() {
    return spaceQuotaDefinitionUrl;
  }

  /**
   * The space quota definition url
   */
  @JsonProperty("staging_security_groups_url")
  @Override
  public @Nullable String getStagingSecurityGroupsUrl() {
    return stagingSecurityGroupsUrl;
  }

  /**
   * This instance is equal to all instances of {@code SpaceEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SpaceEntity
        && equalTo((SpaceEntity) another);
  }

  private boolean equalTo(SpaceEntity another) {
    return Objects.equals(allowSsh, another.allowSsh)
        && Objects.equals(applicationEventsUrl, another.applicationEventsUrl)
        && Objects.equals(applicationsUrl, another.applicationsUrl)
        && Objects.equals(auditorsUrl, another.auditorsUrl)
        && Objects.equals(developersUrl, another.developersUrl)
        && Objects.equals(domainsUrl, another.domainsUrl)
        && Objects.equals(eventsUrl, another.eventsUrl)
        && Objects.equals(isolationSegmentId, another.isolationSegmentId)
        && Objects.equals(isolationSegmentUrl, another.isolationSegmentUrl)
        && Objects.equals(managersUrl, another.managersUrl)
        && Objects.equals(name, another.name)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(organizationUrl, another.organizationUrl)
        && Objects.equals(routesUrl, another.routesUrl)
        && Objects.equals(securityGroupsUrl, another.securityGroupsUrl)
        && Objects.equals(serviceInstancesUrl, another.serviceInstancesUrl)
        && Objects.equals(spaceQuotaDefinitionId, another.spaceQuotaDefinitionId)
        && Objects.equals(spaceQuotaDefinitionUrl, another.spaceQuotaDefinitionUrl)
        && Objects.equals(stagingSecurityGroupsUrl, another.stagingSecurityGroupsUrl);
  }

  /**
   * Computes a hash code from attributes: {@code allowSsh}, {@code applicationEventsUrl}, {@code applicationsUrl}, {@code auditorsUrl}, {@code developersUrl}, {@code domainsUrl}, {@code eventsUrl}, {@code isolationSegmentId}, {@code isolationSegmentUrl}, {@code managersUrl}, {@code name}, {@code organizationId}, {@code organizationUrl}, {@code routesUrl}, {@code securityGroupsUrl}, {@code serviceInstancesUrl}, {@code spaceQuotaDefinitionId}, {@code spaceQuotaDefinitionUrl}, {@code stagingSecurityGroupsUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(allowSsh);
    h += (h << 5) + Objects.hashCode(applicationEventsUrl);
    h += (h << 5) + Objects.hashCode(applicationsUrl);
    h += (h << 5) + Objects.hashCode(auditorsUrl);
    h += (h << 5) + Objects.hashCode(developersUrl);
    h += (h << 5) + Objects.hashCode(domainsUrl);
    h += (h << 5) + Objects.hashCode(eventsUrl);
    h += (h << 5) + Objects.hashCode(isolationSegmentId);
    h += (h << 5) + Objects.hashCode(isolationSegmentUrl);
    h += (h << 5) + Objects.hashCode(managersUrl);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + Objects.hashCode(organizationUrl);
    h += (h << 5) + Objects.hashCode(routesUrl);
    h += (h << 5) + Objects.hashCode(securityGroupsUrl);
    h += (h << 5) + Objects.hashCode(serviceInstancesUrl);
    h += (h << 5) + Objects.hashCode(spaceQuotaDefinitionId);
    h += (h << 5) + Objects.hashCode(spaceQuotaDefinitionUrl);
    h += (h << 5) + Objects.hashCode(stagingSecurityGroupsUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code SpaceEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpaceEntity{"
        + "allowSsh=" + allowSsh
        + ", applicationEventsUrl=" + applicationEventsUrl
        + ", applicationsUrl=" + applicationsUrl
        + ", auditorsUrl=" + auditorsUrl
        + ", developersUrl=" + developersUrl
        + ", domainsUrl=" + domainsUrl
        + ", eventsUrl=" + eventsUrl
        + ", isolationSegmentId=" + isolationSegmentId
        + ", isolationSegmentUrl=" + isolationSegmentUrl
        + ", managersUrl=" + managersUrl
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", organizationUrl=" + organizationUrl
        + ", routesUrl=" + routesUrl
        + ", securityGroupsUrl=" + securityGroupsUrl
        + ", serviceInstancesUrl=" + serviceInstancesUrl
        + ", spaceQuotaDefinitionId=" + spaceQuotaDefinitionId
        + ", spaceQuotaDefinitionUrl=" + spaceQuotaDefinitionUrl
        + ", stagingSecurityGroupsUrl=" + stagingSecurityGroupsUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_SpaceEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.spaces._SpaceEntity {
    Boolean allowSsh;
    String applicationEventsUrl;
    String applicationsUrl;
    String auditorsUrl;
    String developersUrl;
    String domainsUrl;
    String eventsUrl;
    String isolationSegmentId;
    String isolationSegmentUrl;
    String managersUrl;
    String name;
    String organizationId;
    String organizationUrl;
    String routesUrl;
    String securityGroupsUrl;
    String serviceInstancesUrl;
    String spaceQuotaDefinitionId;
    String spaceQuotaDefinitionUrl;
    String stagingSecurityGroupsUrl;
    @JsonProperty("allow_ssh")
    public void setAllowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
    }
    @JsonProperty("app_events_url")
    public void setApplicationEventsUrl(@Nullable String applicationEventsUrl) {
      this.applicationEventsUrl = applicationEventsUrl;
    }
    @JsonProperty("apps_url")
    public void setApplicationsUrl(@Nullable String applicationsUrl) {
      this.applicationsUrl = applicationsUrl;
    }
    @JsonProperty("auditors_url")
    public void setAuditorsUrl(@Nullable String auditorsUrl) {
      this.auditorsUrl = auditorsUrl;
    }
    @JsonProperty("developers_url")
    public void setDevelopersUrl(@Nullable String developersUrl) {
      this.developersUrl = developersUrl;
    }
    @JsonProperty("domains_url")
    public void setDomainsUrl(@Nullable String domainsUrl) {
      this.domainsUrl = domainsUrl;
    }
    @JsonProperty("events_url")
    public void setEventsUrl(@Nullable String eventsUrl) {
      this.eventsUrl = eventsUrl;
    }
    @JsonProperty("isolation_segment_guid")
    public void setIsolationSegmentId(@Nullable String isolationSegmentId) {
      this.isolationSegmentId = isolationSegmentId;
    }
    @JsonProperty("isolation_segment_url")
    public void setIsolationSegmentUrl(@Nullable String isolationSegmentUrl) {
      this.isolationSegmentUrl = isolationSegmentUrl;
    }
    @JsonProperty("managers_url")
    public void setManagersUrl(@Nullable String managersUrl) {
      this.managersUrl = managersUrl;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("organization_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("organization_url")
    public void setOrganizationUrl(@Nullable String organizationUrl) {
      this.organizationUrl = organizationUrl;
    }
    @JsonProperty("routes_url")
    public void setRoutesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
    }
    @JsonProperty("security_groups_url")
    public void setSecurityGroupsUrl(@Nullable String securityGroupsUrl) {
      this.securityGroupsUrl = securityGroupsUrl;
    }
    @JsonProperty("service_instances_url")
    public void setServiceInstancesUrl(@Nullable String serviceInstancesUrl) {
      this.serviceInstancesUrl = serviceInstancesUrl;
    }
    @JsonProperty("space_quota_definition_guid")
    public void setSpaceQuotaDefinitionId(@Nullable String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
    }
    @JsonProperty("space_quota_definition_url")
    public void setSpaceQuotaDefinitionUrl(@Nullable String spaceQuotaDefinitionUrl) {
      this.spaceQuotaDefinitionUrl = spaceQuotaDefinitionUrl;
    }
    @JsonProperty("staging_security_groups_url")
    public void setStagingSecurityGroupsUrl(@Nullable String stagingSecurityGroupsUrl) {
      this.stagingSecurityGroupsUrl = stagingSecurityGroupsUrl;
    }
    @Override
    public Boolean getAllowSsh() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationEventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuditorsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getDevelopersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getDomainsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getEventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getIsolationSegmentId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIsolationSegmentUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getManagersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getRoutesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSecurityGroupsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstancesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceQuotaDefinitionId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceQuotaDefinitionUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getStagingSecurityGroupsUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SpaceEntity fromJson(Json json) {
    SpaceEntity.Builder builder = SpaceEntity.builder();
    if (json.allowSsh != null) {
      builder.allowSsh(json.allowSsh);
    }
    if (json.applicationEventsUrl != null) {
      builder.applicationEventsUrl(json.applicationEventsUrl);
    }
    if (json.applicationsUrl != null) {
      builder.applicationsUrl(json.applicationsUrl);
    }
    if (json.auditorsUrl != null) {
      builder.auditorsUrl(json.auditorsUrl);
    }
    if (json.developersUrl != null) {
      builder.developersUrl(json.developersUrl);
    }
    if (json.domainsUrl != null) {
      builder.domainsUrl(json.domainsUrl);
    }
    if (json.eventsUrl != null) {
      builder.eventsUrl(json.eventsUrl);
    }
    if (json.isolationSegmentId != null) {
      builder.isolationSegmentId(json.isolationSegmentId);
    }
    if (json.isolationSegmentUrl != null) {
      builder.isolationSegmentUrl(json.isolationSegmentUrl);
    }
    if (json.managersUrl != null) {
      builder.managersUrl(json.managersUrl);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.organizationUrl != null) {
      builder.organizationUrl(json.organizationUrl);
    }
    if (json.routesUrl != null) {
      builder.routesUrl(json.routesUrl);
    }
    if (json.securityGroupsUrl != null) {
      builder.securityGroupsUrl(json.securityGroupsUrl);
    }
    if (json.serviceInstancesUrl != null) {
      builder.serviceInstancesUrl(json.serviceInstancesUrl);
    }
    if (json.spaceQuotaDefinitionId != null) {
      builder.spaceQuotaDefinitionId(json.spaceQuotaDefinitionId);
    }
    if (json.spaceQuotaDefinitionUrl != null) {
      builder.spaceQuotaDefinitionUrl(json.spaceQuotaDefinitionUrl);
    }
    if (json.stagingSecurityGroupsUrl != null) {
      builder.stagingSecurityGroupsUrl(json.stagingSecurityGroupsUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SpaceEntity SpaceEntity}.
   * <pre>
   * SpaceEntity.builder()
   *    .allowSsh(Boolean | null) // nullable {@link SpaceEntity#getAllowSsh() allowSsh}
   *    .applicationEventsUrl(String | null) // nullable {@link SpaceEntity#getApplicationEventsUrl() applicationEventsUrl}
   *    .applicationsUrl(String | null) // nullable {@link SpaceEntity#getApplicationsUrl() applicationsUrl}
   *    .auditorsUrl(String | null) // nullable {@link SpaceEntity#getAuditorsUrl() auditorsUrl}
   *    .developersUrl(String | null) // nullable {@link SpaceEntity#getDevelopersUrl() developersUrl}
   *    .domainsUrl(String | null) // nullable {@link SpaceEntity#getDomainsUrl() domainsUrl}
   *    .eventsUrl(String | null) // nullable {@link SpaceEntity#getEventsUrl() eventsUrl}
   *    .isolationSegmentId(String | null) // nullable {@link SpaceEntity#getIsolationSegmentId() isolationSegmentId}
   *    .isolationSegmentUrl(String | null) // nullable {@link SpaceEntity#getIsolationSegmentUrl() isolationSegmentUrl}
   *    .managersUrl(String | null) // nullable {@link SpaceEntity#getManagersUrl() managersUrl}
   *    .name(String | null) // nullable {@link SpaceEntity#getName() name}
   *    .organizationId(String | null) // nullable {@link SpaceEntity#getOrganizationId() organizationId}
   *    .organizationUrl(String | null) // nullable {@link SpaceEntity#getOrganizationUrl() organizationUrl}
   *    .routesUrl(String | null) // nullable {@link SpaceEntity#getRoutesUrl() routesUrl}
   *    .securityGroupsUrl(String | null) // nullable {@link SpaceEntity#getSecurityGroupsUrl() securityGroupsUrl}
   *    .serviceInstancesUrl(String | null) // nullable {@link SpaceEntity#getServiceInstancesUrl() serviceInstancesUrl}
   *    .spaceQuotaDefinitionId(String | null) // nullable {@link SpaceEntity#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId}
   *    .spaceQuotaDefinitionUrl(String | null) // nullable {@link SpaceEntity#getSpaceQuotaDefinitionUrl() spaceQuotaDefinitionUrl}
   *    .stagingSecurityGroupsUrl(String | null) // nullable {@link SpaceEntity#getStagingSecurityGroupsUrl() stagingSecurityGroupsUrl}
   *    .build();
   * </pre>
   * @return A new SpaceEntity builder
   */
  public static SpaceEntity.Builder builder() {
    return new SpaceEntity.Builder();
  }

  /**
   * Builds instances of type {@link SpaceEntity SpaceEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SpaceEntity", generator = "Immutables")
  public static final class Builder {
    private Boolean allowSsh;
    private String applicationEventsUrl;
    private String applicationsUrl;
    private String auditorsUrl;
    private String developersUrl;
    private String domainsUrl;
    private String eventsUrl;
    private String isolationSegmentId;
    private String isolationSegmentUrl;
    private String managersUrl;
    private String name;
    private String organizationId;
    private String organizationUrl;
    private String routesUrl;
    private String securityGroupsUrl;
    private String serviceInstancesUrl;
    private String spaceQuotaDefinitionId;
    private String spaceQuotaDefinitionUrl;
    private String stagingSecurityGroupsUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpaceEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpaceEntity instance) {
      return from((_SpaceEntity) instance);
    }

    /**
     * Copy abstract value type {@code _SpaceEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SpaceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean allowSshValue = instance.getAllowSsh();
      if (allowSshValue != null) {
        allowSsh(allowSshValue);
      }
      String applicationEventsUrlValue = instance.getApplicationEventsUrl();
      if (applicationEventsUrlValue != null) {
        applicationEventsUrl(applicationEventsUrlValue);
      }
      String applicationsUrlValue = instance.getApplicationsUrl();
      if (applicationsUrlValue != null) {
        applicationsUrl(applicationsUrlValue);
      }
      String auditorsUrlValue = instance.getAuditorsUrl();
      if (auditorsUrlValue != null) {
        auditorsUrl(auditorsUrlValue);
      }
      String developersUrlValue = instance.getDevelopersUrl();
      if (developersUrlValue != null) {
        developersUrl(developersUrlValue);
      }
      String domainsUrlValue = instance.getDomainsUrl();
      if (domainsUrlValue != null) {
        domainsUrl(domainsUrlValue);
      }
      String eventsUrlValue = instance.getEventsUrl();
      if (eventsUrlValue != null) {
        eventsUrl(eventsUrlValue);
      }
      String isolationSegmentIdValue = instance.getIsolationSegmentId();
      if (isolationSegmentIdValue != null) {
        isolationSegmentId(isolationSegmentIdValue);
      }
      String isolationSegmentUrlValue = instance.getIsolationSegmentUrl();
      if (isolationSegmentUrlValue != null) {
        isolationSegmentUrl(isolationSegmentUrlValue);
      }
      String managersUrlValue = instance.getManagersUrl();
      if (managersUrlValue != null) {
        managersUrl(managersUrlValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      String organizationUrlValue = instance.getOrganizationUrl();
      if (organizationUrlValue != null) {
        organizationUrl(organizationUrlValue);
      }
      String routesUrlValue = instance.getRoutesUrl();
      if (routesUrlValue != null) {
        routesUrl(routesUrlValue);
      }
      String securityGroupsUrlValue = instance.getSecurityGroupsUrl();
      if (securityGroupsUrlValue != null) {
        securityGroupsUrl(securityGroupsUrlValue);
      }
      String serviceInstancesUrlValue = instance.getServiceInstancesUrl();
      if (serviceInstancesUrlValue != null) {
        serviceInstancesUrl(serviceInstancesUrlValue);
      }
      String spaceQuotaDefinitionIdValue = instance.getSpaceQuotaDefinitionId();
      if (spaceQuotaDefinitionIdValue != null) {
        spaceQuotaDefinitionId(spaceQuotaDefinitionIdValue);
      }
      String spaceQuotaDefinitionUrlValue = instance.getSpaceQuotaDefinitionUrl();
      if (spaceQuotaDefinitionUrlValue != null) {
        spaceQuotaDefinitionUrl(spaceQuotaDefinitionUrlValue);
      }
      String stagingSecurityGroupsUrlValue = instance.getStagingSecurityGroupsUrl();
      if (stagingSecurityGroupsUrlValue != null) {
        stagingSecurityGroupsUrl(stagingSecurityGroupsUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getAllowSsh() allowSsh} attribute.
     * @param allowSsh The value for allowSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allow_ssh")
    public final Builder allowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getApplicationEventsUrl() applicationEventsUrl} attribute.
     * @param applicationEventsUrl The value for applicationEventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_events_url")
    public final Builder applicationEventsUrl(@Nullable String applicationEventsUrl) {
      this.applicationEventsUrl = applicationEventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getApplicationsUrl() applicationsUrl} attribute.
     * @param applicationsUrl The value for applicationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apps_url")
    public final Builder applicationsUrl(@Nullable String applicationsUrl) {
      this.applicationsUrl = applicationsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getAuditorsUrl() auditorsUrl} attribute.
     * @param auditorsUrl The value for auditorsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("auditors_url")
    public final Builder auditorsUrl(@Nullable String auditorsUrl) {
      this.auditorsUrl = auditorsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getDevelopersUrl() developersUrl} attribute.
     * @param developersUrl The value for developersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("developers_url")
    public final Builder developersUrl(@Nullable String developersUrl) {
      this.developersUrl = developersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getDomainsUrl() domainsUrl} attribute.
     * @param domainsUrl The value for domainsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("domains_url")
    public final Builder domainsUrl(@Nullable String domainsUrl) {
      this.domainsUrl = domainsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getEventsUrl() eventsUrl} attribute.
     * @param eventsUrl The value for eventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("events_url")
    public final Builder eventsUrl(@Nullable String eventsUrl) {
      this.eventsUrl = eventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getIsolationSegmentId() isolationSegmentId} attribute.
     * @param isolationSegmentId The value for isolationSegmentId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("isolation_segment_guid")
    public final Builder isolationSegmentId(@Nullable String isolationSegmentId) {
      this.isolationSegmentId = isolationSegmentId;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getIsolationSegmentUrl() isolationSegmentUrl} attribute.
     * @param isolationSegmentUrl The value for isolationSegmentUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("isolation_segment_url")
    public final Builder isolationSegmentUrl(@Nullable String isolationSegmentUrl) {
      this.isolationSegmentUrl = isolationSegmentUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getManagersUrl() managersUrl} attribute.
     * @param managersUrl The value for managersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("managers_url")
    public final Builder managersUrl(@Nullable String managersUrl) {
      this.managersUrl = managersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization_guid")
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getOrganizationUrl() organizationUrl} attribute.
     * @param organizationUrl The value for organizationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization_url")
    public final Builder organizationUrl(@Nullable String organizationUrl) {
      this.organizationUrl = organizationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getRoutesUrl() routesUrl} attribute.
     * @param routesUrl The value for routesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routes_url")
    public final Builder routesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getSecurityGroupsUrl() securityGroupsUrl} attribute.
     * @param securityGroupsUrl The value for securityGroupsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("security_groups_url")
    public final Builder securityGroupsUrl(@Nullable String securityGroupsUrl) {
      this.securityGroupsUrl = securityGroupsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getServiceInstancesUrl() serviceInstancesUrl} attribute.
     * @param serviceInstancesUrl The value for serviceInstancesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instances_url")
    public final Builder serviceInstancesUrl(@Nullable String serviceInstancesUrl) {
      this.serviceInstancesUrl = serviceInstancesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId} attribute.
     * @param spaceQuotaDefinitionId The value for spaceQuotaDefinitionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_quota_definition_guid")
    public final Builder spaceQuotaDefinitionId(@Nullable String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getSpaceQuotaDefinitionUrl() spaceQuotaDefinitionUrl} attribute.
     * @param spaceQuotaDefinitionUrl The value for spaceQuotaDefinitionUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_quota_definition_url")
    public final Builder spaceQuotaDefinitionUrl(@Nullable String spaceQuotaDefinitionUrl) {
      this.spaceQuotaDefinitionUrl = spaceQuotaDefinitionUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceEntity#getStagingSecurityGroupsUrl() stagingSecurityGroupsUrl} attribute.
     * @param stagingSecurityGroupsUrl The value for stagingSecurityGroupsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_security_groups_url")
    public final Builder stagingSecurityGroupsUrl(@Nullable String stagingSecurityGroupsUrl) {
      this.stagingSecurityGroupsUrl = stagingSecurityGroupsUrl;
      return this;
    }

    /**
     * Builds a new {@link SpaceEntity SpaceEntity}.
     * @return An immutable instance of SpaceEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SpaceEntity build() {
      return new SpaceEntity(this);
    }
  }
}
