package org.cloudfoundry.client.v3.builds;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The Build relationships
 */
@Generated(from = "_BuildRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BuildRelationships extends org.cloudfoundry.client.v3.builds._BuildRelationships {
  private final ToOneRelationship application;

  private BuildRelationships(BuildRelationships.Builder builder) {
    this.application = builder.application;
  }

  /**
   * The application relationship
   */
  @JsonProperty("app")
  @Override
  public ToOneRelationship getApplication() {
    return application;
  }

  /**
   * This instance is equal to all instances of {@code BuildRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BuildRelationships
        && equalTo((BuildRelationships) another);
  }

  private boolean equalTo(BuildRelationships another) {
    return application.equals(another.application);
  }

  /**
   * Computes a hash code from attributes: {@code application}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + application.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BuildRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BuildRelationships{"
        + "application=" + application
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BuildRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.builds._BuildRelationships {
    ToOneRelationship application;
    @JsonProperty("app")
    public void setApplication(ToOneRelationship application) {
      this.application = application;
    }
    @Override
    public ToOneRelationship getApplication() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BuildRelationships fromJson(Json json) {
    BuildRelationships.Builder builder = BuildRelationships.builder();
    if (json.application != null) {
      builder.application(json.application);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BuildRelationships BuildRelationships}.
   * <pre>
   * BuildRelationships.builder()
   *    .application(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link BuildRelationships#getApplication() application}
   *    .build();
   * </pre>
   * @return A new BuildRelationships builder
   */
  public static BuildRelationships.Builder builder() {
    return new BuildRelationships.Builder();
  }

  /**
   * Builds instances of type {@link BuildRelationships BuildRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BuildRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship application;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BuildRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BuildRelationships instance) {
      return from((_BuildRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _BuildRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BuildRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      application(instance.getApplication());
      return this;
    }

    /**
     * Initializes the value for the {@link BuildRelationships#getApplication() application} attribute.
     * @param application The value for application 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder application(ToOneRelationship application) {
      this.application = Objects.requireNonNull(application, "application");
      initBits &= ~INIT_BIT_APPLICATION;
      return this;
    }

    /**
     * Builds a new {@link BuildRelationships BuildRelationships}.
     * @return An immutable instance of BuildRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BuildRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new BuildRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION) != 0) attributes.add("application");
      return "Cannot build BuildRelationships, some of required attributes are not set " + attributes;
    }
  }
}
