package org.cloudfoundry.client.v3.deployments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Deployments operation.
 */
@Generated(from = "_ListDeploymentsRequest", generator = "Immutables")
@SuppressWarnings({"all", "deprecation"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListDeploymentsRequest
    extends org.cloudfoundry.client.v3.deployments._ListDeploymentsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> applicationIds;
  private final List<DeploymentState> states;
  private final List<DeploymentStatusReason> statusReasons;
  private final List<DeploymentStatusValue> statusValues;

  private ListDeploymentsRequest(ListDeploymentsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.states = createUnmodifiableList(true, builder.states);
    this.statusReasons = createUnmodifiableList(true, builder.statusReasons);
    this.statusValues = createUnmodifiableList(true, builder.statusValues);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * List of app guids to filter by
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * List of states to filter by
   */
  @Override
  public List<DeploymentState> getStates() {
    return states;
  }

  /**
   * List of status reasons to filter by
   */
  @Override
  public List<DeploymentStatusReason> getStatusReasons() {
    return statusReasons;
  }

  /**
   * List of status values to filter by
   */
  @Override
  public List<DeploymentStatusValue> getStatusValues() {
    return statusValues;
  }

  /**
   * This instance is equal to all instances of {@code ListDeploymentsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListDeploymentsRequest
        && equalTo((ListDeploymentsRequest) another);
  }

  private boolean equalTo(ListDeploymentsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationIds.equals(another.applicationIds)
        && states.equals(another.states)
        && statusReasons.equals(another.statusReasons)
        && statusValues.equals(another.statusValues);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationIds}, {@code states}, {@code statusReasons}, {@code statusValues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + states.hashCode();
    h += (h << 5) + statusReasons.hashCode();
    h += (h << 5) + statusValues.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListDeploymentsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListDeploymentsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationIds=" + applicationIds
        + ", states=" + states
        + ", statusReasons=" + statusReasons
        + ", statusValues=" + statusValues
        + "}";
  }

  /**
   * Creates a builder for {@link ListDeploymentsRequest ListDeploymentsRequest}.
   * <pre>
   * ListDeploymentsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListDeploymentsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListDeploymentsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListDeploymentsRequest#getPerPage() perPage}
   *    .applicationId|addAllApplicationIds(String) // {@link ListDeploymentsRequest#getApplicationIds() applicationIds} elements
   *    .state|addAllStates(org.cloudfoundry.client.v3.deployments.DeploymentState) // {@link ListDeploymentsRequest#getStates() states} elements
   *    .statusReason|addAllStatusReasons(org.cloudfoundry.client.v3.deployments.DeploymentStatusReason) // {@link ListDeploymentsRequest#getStatusReasons() statusReasons} elements
   *    .statusValue|addAllStatusValues(org.cloudfoundry.client.v3.deployments.DeploymentStatusValue) // {@link ListDeploymentsRequest#getStatusValues() statusValues} elements
   *    .build();
   * </pre>
   * @return A new ListDeploymentsRequest builder
   */
  public static ListDeploymentsRequest.Builder builder() {
    return new ListDeploymentsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListDeploymentsRequest ListDeploymentsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListDeploymentsRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> applicationIds = new ArrayList<String>();
    private List<DeploymentState> states = new ArrayList<DeploymentState>();
    private List<DeploymentStatusReason> statusReasons = new ArrayList<DeploymentStatusReason>();
    private List<DeploymentStatusValue> statusValues = new ArrayList<DeploymentStatusValue>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListDeploymentsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListDeploymentsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListDeploymentsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListDeploymentsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.deployments._ListDeploymentsRequest) {
        org.cloudfoundry.client.v3.deployments._ListDeploymentsRequest instance = (org.cloudfoundry.client.v3.deployments._ListDeploymentsRequest) object;
        addAllStatusReasons(instance.getStatusReasons());
        addAllStatusValues(instance.getStatusValues());
        addAllApplicationIds(instance.getApplicationIds());
        addAllStates(instance.getStates());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListDeploymentsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListDeploymentsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListDeploymentsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListDeploymentsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDeploymentsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDeploymentsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListDeploymentsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListDeploymentsRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(DeploymentState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDeploymentsRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(DeploymentState... elements) {
      for (DeploymentState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDeploymentsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends DeploymentState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link ListDeploymentsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends DeploymentState> elements) {
      for (DeploymentState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListDeploymentsRequest#getStatusReasons() statusReasons} list.
     * @param element A statusReasons element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statusReason(DeploymentStatusReason element) {
      this.statusReasons.add(Objects.requireNonNull(element, "statusReasons element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDeploymentsRequest#getStatusReasons() statusReasons} list.
     * @param elements An array of statusReasons elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statusReasons(DeploymentStatusReason... elements) {
      for (DeploymentStatusReason element : elements) {
        this.statusReasons.add(Objects.requireNonNull(element, "statusReasons element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDeploymentsRequest#getStatusReasons() statusReasons} list.
     * @param elements An iterable of statusReasons elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statusReasons(Iterable<? extends DeploymentStatusReason> elements) {
      this.statusReasons.clear();
      return addAllStatusReasons(elements);
    }

    /**
     * Adds elements to {@link ListDeploymentsRequest#getStatusReasons() statusReasons} list.
     * @param elements An iterable of statusReasons elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStatusReasons(Iterable<? extends DeploymentStatusReason> elements) {
      for (DeploymentStatusReason element : elements) {
        this.statusReasons.add(Objects.requireNonNull(element, "statusReasons element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListDeploymentsRequest#getStatusValues() statusValues} list.
     * @param element A statusValues element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statusValue(DeploymentStatusValue element) {
      this.statusValues.add(Objects.requireNonNull(element, "statusValues element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDeploymentsRequest#getStatusValues() statusValues} list.
     * @param elements An array of statusValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statusValues(DeploymentStatusValue... elements) {
      for (DeploymentStatusValue element : elements) {
        this.statusValues.add(Objects.requireNonNull(element, "statusValues element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDeploymentsRequest#getStatusValues() statusValues} list.
     * @param elements An iterable of statusValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statusValues(Iterable<? extends DeploymentStatusValue> elements) {
      this.statusValues.clear();
      return addAllStatusValues(elements);
    }

    /**
     * Adds elements to {@link ListDeploymentsRequest#getStatusValues() statusValues} list.
     * @param elements An iterable of statusValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStatusValues(Iterable<? extends DeploymentStatusValue> elements) {
      for (DeploymentStatusValue element : elements) {
        this.statusValues.add(Objects.requireNonNull(element, "statusValues element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListDeploymentsRequest ListDeploymentsRequest}.
     * @return An immutable instance of ListDeploymentsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListDeploymentsRequest build() {
      return new ListDeploymentsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
