package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Isolation Segment operation.
 */
@Generated(from = "_DeleteIsolationSegmentRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteIsolationSegmentRequest
    extends org.cloudfoundry.client.v3.isolationsegments._DeleteIsolationSegmentRequest {
  private final String isolationSegmentId;

  private DeleteIsolationSegmentRequest(DeleteIsolationSegmentRequest.Builder builder) {
    this.isolationSegmentId = builder.isolationSegmentId;
  }

  /**
   * The isolation segment id
   */
  @Override
  public String getIsolationSegmentId() {
    return isolationSegmentId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteIsolationSegmentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteIsolationSegmentRequest
        && equalTo((DeleteIsolationSegmentRequest) another);
  }

  private boolean equalTo(DeleteIsolationSegmentRequest another) {
    return isolationSegmentId.equals(another.isolationSegmentId);
  }

  /**
   * Computes a hash code from attributes: {@code isolationSegmentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + isolationSegmentId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteIsolationSegmentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteIsolationSegmentRequest{"
        + "isolationSegmentId=" + isolationSegmentId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteIsolationSegmentRequest DeleteIsolationSegmentRequest}.
   * <pre>
   * DeleteIsolationSegmentRequest.builder()
   *    .isolationSegmentId(String) // required {@link DeleteIsolationSegmentRequest#getIsolationSegmentId() isolationSegmentId}
   *    .build();
   * </pre>
   * @return A new DeleteIsolationSegmentRequest builder
   */
  public static DeleteIsolationSegmentRequest.Builder builder() {
    return new DeleteIsolationSegmentRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteIsolationSegmentRequest DeleteIsolationSegmentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteIsolationSegmentRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ISOLATION_SEGMENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String isolationSegmentId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteIsolationSegmentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteIsolationSegmentRequest instance) {
      return from((_DeleteIsolationSegmentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteIsolationSegmentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteIsolationSegmentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      isolationSegmentId(instance.getIsolationSegmentId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIsolationSegmentRequest#getIsolationSegmentId() isolationSegmentId} attribute.
     * @param isolationSegmentId The value for isolationSegmentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentId(String isolationSegmentId) {
      this.isolationSegmentId = Objects.requireNonNull(isolationSegmentId, "isolationSegmentId");
      initBits &= ~INIT_BIT_ISOLATION_SEGMENT_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteIsolationSegmentRequest DeleteIsolationSegmentRequest}.
     * @return An immutable instance of DeleteIsolationSegmentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteIsolationSegmentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteIsolationSegmentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ISOLATION_SEGMENT_ID) != 0) attributes.add("isolationSegmentId");
      return "Cannot build DeleteIsolationSegmentRequest, some of required attributes are not set " + attributes;
    }
  }
}
